/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.rpc.consumer.dispatcher;

import org.jupiter.rpc.DispatchType;
import org.jupiter.rpc.JClient;
import org.jupiter.rpc.JRequest;
import org.jupiter.rpc.consumer.ConsumerInterceptor;
import org.jupiter.rpc.consumer.dispatcher.AbstractDispatcher;
import org.jupiter.rpc.consumer.future.DefaultInvokeFuture;
import org.jupiter.rpc.consumer.future.DefaultInvokeFutureGroup;
import org.jupiter.rpc.consumer.future.InvokeFuture;
import org.jupiter.rpc.model.metadata.MessageWrapper;
import org.jupiter.serialization.Serializer;
import org.jupiter.serialization.SerializerType;
import org.jupiter.serialization.io.OutputBuf;
import org.jupiter.transport.CodecConfig;
import org.jupiter.transport.channel.JChannel;
import org.jupiter.transport.channel.JChannelGroup;

public class DefaultBroadcastDispatcher
extends AbstractDispatcher {
    public DefaultBroadcastDispatcher(JClient client, SerializerType serializerType) {
        super(client, serializerType);
    }

    @Override
    public <T> InvokeFuture<T> dispatch(JRequest request, Class<T> returnType) {
        Serializer _serializer = this.serializer();
        MessageWrapper message = request.message();
        JChannelGroup[] groups = this.groups(message.getMetadata());
        JChannel[] channels = new JChannel[groups.length];
        for (int i = 0; i < groups.length; ++i) {
            channels[i] = groups[i].next();
        }
        byte s_code = _serializer.code();
        boolean isLowCopy = CodecConfig.isCodecLowCopy();
        if (!isLowCopy) {
            byte[] bytes = _serializer.writeObject((Object)message);
            request.bytes(s_code, bytes);
        }
        long invokeId = request.invokeId();
        ConsumerInterceptor[] interceptors = this.interceptors();
        DefaultInvokeFuture[] futures = new DefaultInvokeFuture[channels.length];
        long timeoutMillis = this.getMethodSpecialTimeoutMillis(message.getMethodName());
        for (int i = 0; i < channels.length; ++i) {
            JChannel channel = channels[i];
            DefaultInvokeFuture<T> future = DefaultInvokeFuture.with(invokeId, channel, returnType, timeoutMillis, DispatchType.BROADCAST).interceptors(interceptors).traceId(message.getTraceId());
            if (isLowCopy) {
                OutputBuf outputBuf = _serializer.writeObject(channel.allocOutputBuf(), (Object)message);
                request.outputBuf(s_code, outputBuf);
            }
            futures[i] = DefaultBroadcastDispatcher.write(channel, request, future, DispatchType.BROADCAST);
        }
        return DefaultInvokeFutureGroup.with(futures);
    }
}

