/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.rpc.consumer.future;

import org.jupiter.common.util.Preconditions;
import org.jupiter.rpc.JListener;
import org.jupiter.rpc.consumer.future.AbstractFuture;
import org.jupiter.rpc.consumer.future.DefaultListeners;
import org.jupiter.rpc.consumer.future.ListenableFuture;

public abstract class AbstractListenableFuture<V>
extends AbstractFuture<V>
implements ListenableFuture<V> {
    private Object listeners;

    @Override
    protected void done(int state, Object x) {
        this.notifyListeners(state, x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListenableFuture<V> addListener(JListener<V> listener) {
        Preconditions.checkNotNull(listener, (Object)"listener");
        AbstractListenableFuture abstractListenableFuture = this;
        synchronized (abstractListenableFuture) {
            this.addListener0(listener);
        }
        if (this.isDone()) {
            this.notifyListeners(this.state(), this.outcome());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListenableFuture<V> addListeners(JListener<V> ... listeners) {
        Preconditions.checkNotNull(listeners, (Object)"listeners");
        AbstractListenableFuture abstractListenableFuture = this;
        synchronized (abstractListenableFuture) {
            for (JListener<V> listener : listeners) {
                if (listener == null) continue;
                this.addListener0(listener);
            }
        }
        if (this.isDone()) {
            this.notifyListeners(this.state(), this.outcome());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListenableFuture<V> removeListener(JListener<V> listener) {
        Preconditions.checkNotNull(listener, (Object)"listener");
        AbstractListenableFuture abstractListenableFuture = this;
        synchronized (abstractListenableFuture) {
            this.removeListener0(listener);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListenableFuture<V> removeListeners(JListener<V> ... listeners) {
        Preconditions.checkNotNull(listeners, (Object)"listeners");
        AbstractListenableFuture abstractListenableFuture = this;
        synchronized (abstractListenableFuture) {
            for (JListener<V> listener : listeners) {
                if (listener == null) continue;
                this.removeListener0(listener);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListeners(int state, Object x) {
        Object listeners;
        AbstractListenableFuture abstractListenableFuture = this;
        synchronized (abstractListenableFuture) {
            if (this.listeners == null) {
                return;
            }
            listeners = this.listeners;
            this.listeners = null;
        }
        if (listeners instanceof DefaultListeners) {
            JListener<V>[] array = ((DefaultListeners)listeners).listeners();
            int size = ((DefaultListeners)listeners).size();
            for (int i = 0; i < size; ++i) {
                this.notifyListener0(array[i], state, x);
            }
        } else {
            this.notifyListener0((JListener)listeners, state, x);
        }
    }

    protected abstract void notifyListener0(JListener<V> var1, int var2, Object var3);

    private void addListener0(JListener<V> listener) {
        if (this.listeners == null) {
            this.listeners = listener;
        } else if (this.listeners instanceof DefaultListeners) {
            ((DefaultListeners)this.listeners).add(listener);
        } else {
            this.listeners = DefaultListeners.with((JListener)this.listeners, listener);
        }
    }

    private void removeListener0(JListener<V> listener) {
        if (this.listeners instanceof DefaultListeners) {
            ((DefaultListeners)this.listeners).remove(listener);
        } else if (this.listeners == listener) {
            this.listeners = null;
        }
    }
}

