/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.rpc.consumer.future;

import org.jupiter.common.util.Reflects;
import org.jupiter.common.util.StackTraceUtil;
import org.jupiter.common.util.internal.logging.InternalLogger;
import org.jupiter.common.util.internal.logging.InternalLoggerFactory;
import org.jupiter.rpc.JListener;
import org.jupiter.rpc.consumer.future.InvokeFuture;

public class FailSafeInvokeFuture<V>
implements InvokeFuture<V> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(FailSafeInvokeFuture.class);
    private final InvokeFuture<V> future;

    public static <T> FailSafeInvokeFuture<T> with(InvokeFuture<T> future) {
        return new FailSafeInvokeFuture<T>(future);
    }

    private FailSafeInvokeFuture(InvokeFuture<V> future) {
        this.future = future;
    }

    @Override
    public Class<V> returnType() {
        return this.future.returnType();
    }

    @Override
    public V getResult() throws Throwable {
        try {
            return this.future.getResult();
        }
        catch (Throwable t) {
            if (logger.isWarnEnabled()) {
                logger.warn("Ignored exception on [Fail-safe]: {}.", (Object)StackTraceUtil.stackTrace((Throwable)t));
            }
            return (V)Reflects.getTypeDefaultValue(this.returnType());
        }
    }

    @Override
    public InvokeFuture<V> addListener(JListener<V> listener) {
        this.future.addListener(listener);
        return this;
    }

    @Override
    public InvokeFuture<V> addListeners(JListener<V> ... listeners) {
        this.future.addListeners(listeners);
        return this;
    }

    @Override
    public InvokeFuture<V> removeListener(JListener<V> listener) {
        this.future.removeListener(listener);
        return this;
    }

    @Override
    public InvokeFuture<V> removeListeners(JListener<V> ... listeners) {
        this.future.removeListeners(listeners);
        return this;
    }

    public InvokeFuture<V> future() {
        return this.future;
    }
}

