/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.rpc.provider.processor;

import org.jupiter.common.util.JServiceLoader;
import org.jupiter.common.util.StackTraceUtil;
import org.jupiter.common.util.SystemPropertyUtil;
import org.jupiter.common.util.internal.logging.InternalLogger;
import org.jupiter.common.util.internal.logging.InternalLoggerFactory;
import org.jupiter.rpc.consumer.processor.ConsumerExecutors;
import org.jupiter.rpc.executor.CloseableExecutor;
import org.jupiter.rpc.executor.ExecutorFactory;
import org.jupiter.rpc.executor.ThreadPoolExecutorFactory;
import org.jupiter.rpc.provider.processor.ProviderExecutorFactory;

public class ProviderExecutors {
    private static final InternalLogger logger;
    private static final CloseableExecutor executor;

    public static CloseableExecutor executor() {
        return executor;
    }

    public static void execute(Runnable r) {
        executor.execute(r);
    }

    static {
        ExecutorFactory factory;
        logger = InternalLoggerFactory.getInstance(ConsumerExecutors.class);
        String factoryName = SystemPropertyUtil.get((String)"jupiter.executor.factory.provider.factory_name", (String)"threadPool");
        try {
            factory = (ExecutorFactory)JServiceLoader.load(ProviderExecutorFactory.class).find(factoryName);
        }
        catch (Throwable t) {
            logger.warn("Failed to load provider's executor factory [{}], cause: {}, [ThreadPoolExecutorFactory] will be used as default.", (Object)factoryName, (Object)StackTraceUtil.stackTrace((Throwable)t));
            factory = new ThreadPoolExecutorFactory();
        }
        executor = factory.newExecutor(ExecutorFactory.Target.PROVIDER, "jupiter-provider-processor");
    }
}

