/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.rpc;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import org.jupiter.common.util.JConstants;
import org.jupiter.common.util.JServiceLoader;
import org.jupiter.common.util.Lists;
import org.jupiter.common.util.Maps;
import org.jupiter.common.util.Pair;
import org.jupiter.common.util.Requires;
import org.jupiter.common.util.StackTraceUtil;
import org.jupiter.common.util.Strings;
import org.jupiter.common.util.internal.logging.InternalLogger;
import org.jupiter.common.util.internal.logging.InternalLoggerFactory;
import org.jupiter.registry.RegisterMeta;
import org.jupiter.registry.RegistryService;
import org.jupiter.rpc.JRequest;
import org.jupiter.rpc.JServer;
import org.jupiter.rpc.ServiceProvider;
import org.jupiter.rpc.ServiceProviderImpl;
import org.jupiter.rpc.flow.control.ControlResult;
import org.jupiter.rpc.flow.control.FlowController;
import org.jupiter.rpc.model.metadata.ServiceMetadata;
import org.jupiter.rpc.model.metadata.ServiceWrapper;
import org.jupiter.rpc.provider.ProviderInterceptor;
import org.jupiter.rpc.provider.processor.DefaultProviderProcessor;
import org.jupiter.transport.Directory;
import org.jupiter.transport.JAcceptor;
import org.jupiter.transport.processor.ProviderProcessor;

public class DefaultServer
implements JServer {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultServer.class);
    private final ServiceProviderContainer providerContainer = new DefaultServiceProviderContainer();
    private final RegistryService registryService;
    private ProviderInterceptor[] globalInterceptors;
    private FlowController<JRequest> globalFlowController;
    private JAcceptor acceptor;

    public DefaultServer() {
        this(RegistryService.RegistryType.DEFAULT);
    }

    public DefaultServer(RegistryService.RegistryType registryType) {
        registryType = registryType == null ? RegistryService.RegistryType.DEFAULT : registryType;
        this.registryService = (RegistryService)JServiceLoader.load(RegistryService.class).find(registryType.getValue());
    }

    @Override
    public JAcceptor acceptor() {
        return this.acceptor;
    }

    @Override
    public JServer withAcceptor(JAcceptor acceptor) {
        if (acceptor.processor() == null) {
            acceptor.withProcessor((ProviderProcessor)new DefaultProviderProcessor(){

                @Override
                public ServiceWrapper lookupService(Directory directory) {
                    return DefaultServer.this.providerContainer.lookupService(directory.directoryString());
                }

                @Override
                public ControlResult flowControl(JRequest request) {
                    if (DefaultServer.this.globalFlowController == null) {
                        return ControlResult.ALLOWED;
                    }
                    return DefaultServer.this.globalFlowController.flowControl(request);
                }
            });
        }
        this.acceptor = acceptor;
        return this;
    }

    @Override
    public RegistryService registryService() {
        return this.registryService;
    }

    public void connectToRegistryServer(String connectString) {
        this.registryService.connectToRegistryServer(connectString);
    }

    @Override
    public void withGlobalInterceptors(ProviderInterceptor ... globalInterceptors) {
        this.globalInterceptors = globalInterceptors;
    }

    @Override
    public FlowController<JRequest> globalFlowController() {
        return this.globalFlowController;
    }

    @Override
    public void withGlobalFlowController(FlowController<JRequest> globalFlowController) {
        this.globalFlowController = globalFlowController;
    }

    @Override
    public JServer.ServiceRegistry serviceRegistry() {
        return new DefaultServiceRegistry();
    }

    @Override
    public ServiceWrapper lookupService(Directory directory) {
        return this.providerContainer.lookupService(directory.directoryString());
    }

    @Override
    public ServiceWrapper removeService(Directory directory) {
        return this.providerContainer.removeService(directory.directoryString());
    }

    @Override
    public List<ServiceWrapper> allRegisteredServices() {
        return this.providerContainer.getAllServices();
    }

    @Override
    public void publish(ServiceWrapper serviceWrapper) {
        ServiceMetadata metadata = serviceWrapper.getMetadata();
        RegisterMeta meta = new RegisterMeta();
        meta.setPort(this.acceptor.boundPort());
        meta.setGroup(metadata.getGroup());
        meta.setServiceProviderName(metadata.getServiceProviderName());
        meta.setVersion(metadata.getVersion());
        meta.setWeight(serviceWrapper.getWeight());
        meta.setConnCount(JConstants.SUGGESTED_CONNECTION_COUNT);
        this.registryService.register(meta);
    }

    @Override
    public void publish(ServiceWrapper ... serviceWrappers) {
        for (ServiceWrapper wrapper : serviceWrappers) {
            this.publish(wrapper);
        }
    }

    @Override
    public <T> void publishWithInitializer(ServiceWrapper serviceWrapper, JServer.ProviderInitializer<T> initializer, Executor executor) {
        Runnable task = () -> {
            try {
                initializer.init(serviceWrapper.getServiceProvider());
                this.publish(serviceWrapper);
            }
            catch (Exception e) {
                logger.error("Error on {} #publishWithInitializer: {}.", (Object)serviceWrapper.getMetadata(), (Object)StackTraceUtil.stackTrace((Throwable)e));
            }
        };
        if (executor == null) {
            task.run();
        } else {
            executor.execute(task);
        }
    }

    @Override
    public void publishAll() {
        for (ServiceWrapper wrapper : this.providerContainer.getAllServices()) {
            this.publish(wrapper);
        }
    }

    @Override
    public void unpublish(ServiceWrapper serviceWrapper) {
        ServiceMetadata metadata = serviceWrapper.getMetadata();
        RegisterMeta meta = new RegisterMeta();
        meta.setPort(this.acceptor.boundPort());
        meta.setGroup(metadata.getGroup());
        meta.setVersion(metadata.getVersion());
        meta.setServiceProviderName(metadata.getServiceProviderName());
        meta.setWeight(serviceWrapper.getWeight());
        meta.setConnCount(JConstants.SUGGESTED_CONNECTION_COUNT);
        this.registryService.unregister(meta);
    }

    @Override
    public void unpublishAll() {
        for (ServiceWrapper wrapper : this.providerContainer.getAllServices()) {
            this.unpublish(wrapper);
        }
    }

    @Override
    public void start() throws InterruptedException {
        this.acceptor.start();
    }

    @Override
    public void start(boolean sync) throws InterruptedException {
        this.acceptor.start(sync);
    }

    @Override
    public void shutdownGracefully() {
        this.registryService.shutdownGracefully();
        this.acceptor.shutdownGracefully();
    }

    public void setAcceptor(JAcceptor acceptor) {
        this.withAcceptor(acceptor);
    }

    ServiceWrapper registerService(String group, String providerName, String version, Object serviceProvider, ProviderInterceptor[] interceptors, Map<String, List<Pair<Class<?>[], Class<?>[]>>> extensions, int weight, Executor executor, FlowController<JRequest> flowController) {
        ProviderInterceptor[] allInterceptors = null;
        ArrayList tempList = Lists.newArrayList();
        if (this.globalInterceptors != null) {
            Collections.addAll(tempList, this.globalInterceptors);
        }
        if (interceptors != null) {
            Collections.addAll(tempList, interceptors);
        }
        if (!tempList.isEmpty()) {
            allInterceptors = tempList.toArray(new ProviderInterceptor[0]);
        }
        ServiceWrapper wrapper = new ServiceWrapper(group, providerName, version, serviceProvider, allInterceptors, extensions);
        wrapper.setWeight(weight);
        wrapper.setExecutor(executor);
        wrapper.setFlowController(flowController);
        this.providerContainer.registerService(wrapper.getMetadata().directoryString(), wrapper);
        return wrapper;
    }

    private static final class DefaultServiceProviderContainer
    implements ServiceProviderContainer {
        private final ConcurrentMap<String, ServiceWrapper> serviceProviders = Maps.newConcurrentMap();

        private DefaultServiceProviderContainer() {
        }

        @Override
        public void registerService(String uniqueKey, ServiceWrapper serviceWrapper) {
            this.serviceProviders.put(uniqueKey, serviceWrapper);
            logger.info("ServiceProvider [{}, {}] is registered.", (Object)uniqueKey, (Object)serviceWrapper);
        }

        @Override
        public ServiceWrapper lookupService(String uniqueKey) {
            return (ServiceWrapper)this.serviceProviders.get(uniqueKey);
        }

        @Override
        public ServiceWrapper removeService(String uniqueKey) {
            ServiceWrapper serviceWrapper = (ServiceWrapper)this.serviceProviders.remove(uniqueKey);
            if (serviceWrapper == null) {
                logger.warn("ServiceProvider [{}] not found.", (Object)uniqueKey);
            } else {
                logger.info("ServiceProvider [{}, {}] is removed.", (Object)uniqueKey, (Object)serviceWrapper);
            }
            return serviceWrapper;
        }

        @Override
        public List<ServiceWrapper> getAllServices() {
            return Lists.newArrayList(this.serviceProviders.values());
        }
    }

    static interface ServiceProviderContainer {
        public void registerService(String var1, ServiceWrapper var2);

        public ServiceWrapper lookupService(String var1);

        public ServiceWrapper removeService(String var1);

        public List<ServiceWrapper> getAllServices();
    }

    class DefaultServiceRegistry
    implements JServer.ServiceRegistry {
        private Object serviceProvider;
        private ProviderInterceptor[] interceptors;
        private Class<?> interfaceClass;
        private String group;
        private String providerName;
        private String version;
        private int weight;
        private Executor executor;
        private FlowController<JRequest> flowController;

        DefaultServiceRegistry() {
        }

        @Override
        public JServer.ServiceRegistry provider(Object serviceProvider, ProviderInterceptor ... interceptors) {
            this.serviceProvider = serviceProvider;
            this.interceptors = interceptors;
            return this;
        }

        @Override
        public JServer.ServiceRegistry interfaceClass(Class<?> interfaceClass) {
            this.interfaceClass = interfaceClass;
            return this;
        }

        @Override
        public JServer.ServiceRegistry group(String group) {
            this.group = group;
            return this;
        }

        @Override
        public JServer.ServiceRegistry providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        @Override
        public JServer.ServiceRegistry version(String version) {
            this.version = version;
            return this;
        }

        @Override
        public JServer.ServiceRegistry weight(int weight) {
            this.weight = weight;
            return this;
        }

        @Override
        public JServer.ServiceRegistry executor(Executor executor) {
            this.executor = executor;
            return this;
        }

        @Override
        public JServer.ServiceRegistry flowController(FlowController<JRequest> flowController) {
            this.flowController = flowController;
            return this;
        }

        @Override
        public ServiceWrapper register() {
            Requires.requireNotNull((Object)this.serviceProvider, (Object)"serviceProvider");
            Class<?> providerClass = this.serviceProvider.getClass();
            ServiceProviderImpl implAnnotation = null;
            ServiceProvider ifAnnotation = null;
            for (Class<?> cls = providerClass; cls != Object.class; cls = cls.getSuperclass()) {
                Class<?>[] interfaces;
                if (implAnnotation == null) {
                    implAnnotation = cls.getAnnotation(ServiceProviderImpl.class);
                }
                if ((interfaces = cls.getInterfaces()) != null) {
                    Class<?>[] classArray = interfaces;
                    int n = classArray.length;
                    for (int i = 0; i < n; ++i) {
                        Class<?> i2 = classArray[i];
                        ifAnnotation = i2.getAnnotation(ServiceProvider.class);
                        if (ifAnnotation == null) continue;
                        Requires.requireTrue((this.interfaceClass == null ? 1 : 0) != 0, (Object)(i2.getName() + " has a @ServiceProvider annotation, can't set [interfaceClass] again"));
                        this.interfaceClass = i2;
                        break;
                    }
                }
                if (implAnnotation != null && ifAnnotation != null) break;
            }
            if (ifAnnotation != null) {
                Requires.requireTrue((this.group == null ? 1 : 0) != 0, (Object)(this.interfaceClass.getName() + " has a @ServiceProvider annotation, can't set [group] again"));
                Requires.requireTrue((this.providerName == null ? 1 : 0) != 0, (Object)(this.interfaceClass.getName() + " has a @ServiceProvider annotation, can't set [providerName] again"));
                this.group = ifAnnotation.group();
                String name = ifAnnotation.name();
                String string = this.providerName = Strings.isNotBlank((String)name) ? name : this.interfaceClass.getName();
            }
            if (implAnnotation != null) {
                Requires.requireTrue((this.version == null ? 1 : 0) != 0, (Object)(providerClass.getName() + " has a @ServiceProviderImpl annotation, can't set [version] again"));
                this.version = implAnnotation.version();
            }
            Requires.requireNotNull(this.interfaceClass, (Object)"interfaceClass");
            Requires.requireTrue((boolean)Strings.isNotBlank((String)this.group), (Object)"group");
            Requires.requireTrue((boolean)Strings.isNotBlank((String)this.providerName), (Object)"providerName");
            Requires.requireTrue((boolean)Strings.isNotBlank((String)this.version), (Object)"version");
            HashMap extensions = Maps.newHashMap();
            for (Method method : this.interfaceClass.getMethods()) {
                String methodName = method.getName();
                List list = extensions.computeIfAbsent(methodName, k -> Lists.newArrayList());
                list.add(Pair.of(method.getParameterTypes(), method.getExceptionTypes()));
            }
            return DefaultServer.this.registerService(this.group, this.providerName, this.version, this.serviceProvider, this.interceptors, extensions, this.weight, this.executor, this.flowController);
        }
    }
}

