/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.rpc.consumer.cluster;

import org.jupiter.common.util.Reflects;
import org.jupiter.common.util.Requires;
import org.jupiter.common.util.StackTraceUtil;
import org.jupiter.common.util.internal.logging.InternalLogger;
import org.jupiter.common.util.internal.logging.InternalLoggerFactory;
import org.jupiter.rpc.JRequest;
import org.jupiter.rpc.consumer.cluster.ClusterInvoker;
import org.jupiter.rpc.consumer.dispatcher.DefaultRoundDispatcher;
import org.jupiter.rpc.consumer.dispatcher.Dispatcher;
import org.jupiter.rpc.consumer.future.DefaultInvokeFuture;
import org.jupiter.rpc.consumer.future.FailoverInvokeFuture;
import org.jupiter.rpc.consumer.future.InvokeFuture;
import org.jupiter.rpc.model.metadata.MessageWrapper;
import org.jupiter.transport.channel.JChannel;

public class FailoverClusterInvoker
implements ClusterInvoker {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(FailoverClusterInvoker.class);
    private final Dispatcher dispatcher;
    private final int retries;

    public FailoverClusterInvoker(Dispatcher dispatcher, int retries) {
        Requires.requireTrue((boolean)(dispatcher instanceof DefaultRoundDispatcher), (Object)(Reflects.simpleClassName((Object)dispatcher) + " is unsupported [FailoverClusterInvoker]"));
        this.dispatcher = dispatcher;
        this.retries = retries >= 0 ? retries : 2;
    }

    @Override
    public ClusterInvoker.Strategy strategy() {
        return ClusterInvoker.Strategy.FAIL_OVER;
    }

    @Override
    public <T> InvokeFuture<T> invoke(JRequest request, Class<T> returnType) throws Exception {
        FailoverInvokeFuture<T> future = FailoverInvokeFuture.with(returnType);
        int tryCount = this.retries + 1;
        this.invoke0(request, returnType, tryCount, future, null);
        return future;
    }

    private <T> void invoke0(JRequest request, Class<T> returnType, int tryCount, FailoverInvokeFuture<T> failOverFuture, Throwable lastCause) {
        if (tryCount > 0) {
            InvokeFuture<Object> future = this.dispatcher.dispatch(request, returnType);
            future.whenComplete((result, throwable) -> {
                if (throwable == null) {
                    failOverFuture.complete(result);
                } else {
                    if (logger.isWarnEnabled()) {
                        MessageWrapper message = request.message();
                        JChannel channel = future instanceof DefaultInvokeFuture ? ((DefaultInvokeFuture)future).channel() : null;
                        logger.warn("[{}]: [Fail-over] retry, [{}] attempts left, [method: {}], [metadata: {}], {}.", new Object[]{channel, tryCount - 1, message.getMethodName(), message.getMetadata(), StackTraceUtil.stackTrace((Throwable)throwable)});
                    }
                    this.invoke0(request, returnType, tryCount - 1, failOverFuture, (Throwable)throwable);
                }
            });
        } else {
            failOverFuture.completeExceptionally(lastCause);
        }
    }
}

