/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.rpc.executor;

import java.lang.reflect.Constructor;
import java.util.AbstractQueue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jupiter.common.concurrent.RejectedTaskPolicyWithReport;
import org.jupiter.common.util.SpiMetadata;
import org.jupiter.common.util.StackTraceUtil;
import org.jupiter.common.util.Strings;
import org.jupiter.common.util.SystemPropertyUtil;
import org.jupiter.common.util.internal.logging.InternalLogger;
import org.jupiter.common.util.internal.logging.InternalLoggerFactory;
import org.jupiter.rpc.executor.AbstractExecutorFactory;
import org.jupiter.rpc.executor.CloseableExecutor;
import org.jupiter.rpc.executor.ExecutorFactory;

@SpiMetadata(name="threadPool", priority=1)
public class ThreadPoolExecutorFactory
extends AbstractExecutorFactory {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ThreadPoolExecutorFactory.class);

    @Override
    public CloseableExecutor newExecutor(ExecutorFactory.Target target, String name) {
        final ThreadPoolExecutor executor = new ThreadPoolExecutor(this.coreWorkers(target), this.maxWorkers(target), 120L, TimeUnit.SECONDS, this.workQueue(target), this.threadFactory(name), this.createRejectedPolicy(target, name, (RejectedExecutionHandler)new RejectedTaskPolicyWithReport(name, "jupiter")));
        return new CloseableExecutor(){

            @Override
            public void execute(Runnable task) {
                executor.execute(task);
            }

            @Override
            public void shutdown() {
                logger.warn("ThreadPoolExecutorFactory#{} shutdown.", (Object)executor);
                executor.shutdownNow();
            }
        };
    }

    private BlockingQueue<Runnable> workQueue(ExecutorFactory.Target target) {
        AbstractQueue workQueue = null;
        WorkQueueType queueType = this.queueType(target, WorkQueueType.ARRAY_BLOCKING_QUEUE);
        int queueCapacity = this.queueCapacity(target);
        switch (queueType) {
            case LINKED_BLOCKING_QUEUE: {
                workQueue = new LinkedBlockingQueue(queueCapacity);
                break;
            }
            case ARRAY_BLOCKING_QUEUE: {
                workQueue = new ArrayBlockingQueue(queueCapacity);
            }
        }
        return workQueue;
    }

    private WorkQueueType queueType(ExecutorFactory.Target target, WorkQueueType defaultType) {
        WorkQueueType queueType = null;
        switch (target) {
            case CONSUMER: {
                queueType = WorkQueueType.parse(SystemPropertyUtil.get((String)"jupiter.executor.factory.consumer.queue.type"));
                break;
            }
            case PROVIDER: {
                queueType = WorkQueueType.parse(SystemPropertyUtil.get((String)"jupiter.executor.factory.provider.queue.type"));
            }
        }
        return queueType == null ? defaultType : queueType;
    }

    private RejectedExecutionHandler createRejectedPolicy(ExecutorFactory.Target target, String name, RejectedExecutionHandler defaultHandler) {
        RejectedExecutionHandler handler;
        block9: {
            handler = null;
            String handlerClass = null;
            switch (target) {
                case CONSUMER: {
                    handlerClass = SystemPropertyUtil.get((String)"jupiter.executor.factory.consumer.thread.pool.rejected.handler");
                    break;
                }
                case PROVIDER: {
                    handlerClass = SystemPropertyUtil.get((String)"jupiter.executor.factory.provider.thread.pool.rejected.handler");
                }
            }
            if (Strings.isNotBlank(handlerClass)) {
                try {
                    Class<?> cls = Class.forName(handlerClass);
                    try {
                        Constructor<?> constructor = cls.getConstructor(String.class, String.class);
                        handler = (RejectedExecutionHandler)constructor.newInstance(name, "jupiter");
                    }
                    catch (NoSuchMethodException e) {
                        handler = (RejectedExecutionHandler)cls.newInstance();
                    }
                }
                catch (Exception e) {
                    if (!logger.isWarnEnabled()) break block9;
                    logger.warn("Construct {} failed, {}.", (Object)handlerClass, (Object)StackTraceUtil.stackTrace((Throwable)e));
                }
            }
        }
        return handler == null ? defaultHandler : handler;
    }

    static enum WorkQueueType {
        LINKED_BLOCKING_QUEUE,
        ARRAY_BLOCKING_QUEUE;


        static WorkQueueType parse(String name) {
            for (WorkQueueType type : WorkQueueType.values()) {
                if (!type.name().equalsIgnoreCase(name)) continue;
                return type;
            }
            return null;
        }
    }
}

