/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.rpc.model.metadata;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import org.jupiter.common.util.Maps;
import org.jupiter.common.util.SystemPropertyUtil;
import org.jupiter.rpc.model.metadata.ServiceMetadata;
import org.jupiter.serialization.ArrayElement;

public class MessageWrapper
implements Serializable {
    private static final long serialVersionUID = 1009813828866652852L;
    public static final boolean ALLOW_NULL_ARRAY_ARG = SystemPropertyUtil.getBoolean((String)"jupiter.message.args.allow_null_array_arg", (boolean)false);
    private String appName;
    private final ServiceMetadata metadata;
    private String methodName;
    private Object[] args;
    private Map<String, String> attachments;

    public MessageWrapper(ServiceMetadata metadata) {
        this.metadata = metadata;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public ServiceMetadata getMetadata() {
        return this.metadata;
    }

    public String getGroup() {
        return this.metadata.getGroup();
    }

    public String getServiceProviderName() {
        return this.metadata.getServiceProviderName();
    }

    public String getVersion() {
        return this.metadata.getVersion();
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public Object[] getArgs() {
        if (ALLOW_NULL_ARRAY_ARG && this.args != null) {
            for (int i = 0; i < this.args.length - 1; ++i) {
                if (this.args[i] != ArrayElement.NULL) continue;
                this.args[i] = null;
            }
        }
        return this.args;
    }

    public void setArgs(Object[] args) {
        if (ALLOW_NULL_ARRAY_ARG && args != null) {
            for (int i = 0; i < args.length - 1; ++i) {
                if (args[i] != null) continue;
                args[i] = ArrayElement.NULL;
            }
        }
        this.args = args;
    }

    public Map<String, String> getAttachments() {
        return this.attachments;
    }

    public void putAttachment(String key, String value) {
        if (this.attachments == null) {
            this.attachments = Maps.newHashMap();
        }
        this.attachments.put(key, value);
    }

    public String getOperationName() {
        return this.metadata.directoryString() + "." + this.methodName;
    }

    public String toString() {
        return "MessageWrapper{appName='" + this.appName + '\'' + ", metadata=" + this.metadata + ", methodName='" + this.methodName + '\'' + ", args=" + Arrays.toString(this.args) + ", attachments=" + this.attachments + '}';
    }
}

