/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.rpc.provider.processor;

import org.jupiter.common.util.StackTraceUtil;
import org.jupiter.common.util.ThrowUtil;
import org.jupiter.common.util.internal.logging.InternalLogger;
import org.jupiter.common.util.internal.logging.InternalLoggerFactory;
import org.jupiter.rpc.JRequest;
import org.jupiter.rpc.executor.CloseableExecutor;
import org.jupiter.rpc.flow.control.FlowController;
import org.jupiter.rpc.model.metadata.ResultWrapper;
import org.jupiter.rpc.provider.LookupService;
import org.jupiter.rpc.provider.processor.ProviderExecutors;
import org.jupiter.rpc.provider.processor.task.MessageTask;
import org.jupiter.serialization.Serializer;
import org.jupiter.serialization.SerializerFactory;
import org.jupiter.serialization.io.OutputBuf;
import org.jupiter.transport.CodecConfig;
import org.jupiter.transport.Status;
import org.jupiter.transport.channel.JChannel;
import org.jupiter.transport.channel.JFutureListener;
import org.jupiter.transport.payload.JRequestPayload;
import org.jupiter.transport.payload.JResponsePayload;
import org.jupiter.transport.processor.ProviderProcessor;

public abstract class DefaultProviderProcessor
implements ProviderProcessor,
LookupService,
FlowController<JRequest> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultProviderProcessor.class);
    private final CloseableExecutor executor;

    public DefaultProviderProcessor() {
        this(ProviderExecutors.executor());
    }

    public DefaultProviderProcessor(CloseableExecutor executor) {
        this.executor = executor;
    }

    public void handleRequest(JChannel channel, JRequestPayload requestPayload) throws Exception {
        MessageTask task = new MessageTask(this, channel, new JRequest(requestPayload));
        if (this.executor == null) {
            channel.addTask((Runnable)((Object)task));
        } else {
            this.executor.execute((Runnable)((Object)task));
        }
    }

    public void handleException(JChannel channel, JRequestPayload request, Status status, Throwable cause) {
        logger.error("An exception was caught while processing request: {}, {}.", (Object)channel.remoteAddress(), (Object)StackTraceUtil.stackTrace((Throwable)cause));
        this.doHandleException(channel, request.invokeId(), request.serializerCode(), status.value(), cause, false);
    }

    public void shutdown() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    public void handleException(JChannel channel, JRequest request, Status status, Throwable cause) {
        logger.error("An exception was caught while processing request: {}, {}.", (Object)channel.remoteAddress(), (Object)StackTraceUtil.stackTrace((Throwable)cause));
        this.doHandleException(channel, request.invokeId(), request.serializerCode(), status.value(), cause, false);
    }

    public void handleRejected(JChannel channel, JRequest request, Status status, Throwable cause) {
        if (logger.isWarnEnabled()) {
            logger.warn("Service rejected: {}, {}.", (Object)channel.remoteAddress(), (Object)StackTraceUtil.stackTrace((Throwable)cause));
        }
        this.doHandleException(channel, request.invokeId(), request.serializerCode(), status.value(), cause, true);
    }

    private void doHandleException(JChannel channel, long invokeId, byte s_code, byte status, Throwable cause, boolean closeChannel) {
        ResultWrapper result = new ResultWrapper();
        result.setError(ThrowUtil.cutCause((Throwable)cause));
        Serializer serializer = SerializerFactory.getSerializer((byte)s_code);
        JResponsePayload response = new JResponsePayload(invokeId);
        response.status(status);
        if (CodecConfig.isCodecLowCopy()) {
            OutputBuf outputBuf = serializer.writeObject(channel.allocOutputBuf(), (Object)result);
            response.outputBuf(s_code, outputBuf);
        } else {
            byte[] bytes = serializer.writeObject((Object)result);
            response.bytes(s_code, bytes);
        }
        if (closeChannel) {
            channel.write((Object)response, JChannel.CLOSE);
        } else {
            channel.write((Object)response, (JFutureListener)new JFutureListener<JChannel>(){

                public void operationSuccess(JChannel channel) throws Exception {
                    logger.debug("Service error message sent out: {}.", (Object)channel);
                }

                public void operationFailure(JChannel channel, Throwable cause) throws Exception {
                    if (logger.isWarnEnabled()) {
                        logger.warn("Service error message sent failed: {}, {}.", (Object)channel, (Object)StackTraceUtil.stackTrace((Throwable)cause));
                    }
                }
            });
        }
    }
}

