/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.rpc.consumer.future;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jupiter.common.concurrent.NamedThreadFactory;
import org.jupiter.common.util.JConstants;
import org.jupiter.common.util.Maps;
import org.jupiter.common.util.SystemPropertyUtil;
import org.jupiter.common.util.internal.logging.InternalLogger;
import org.jupiter.common.util.internal.logging.InternalLoggerFactory;
import org.jupiter.common.util.timer.HashedWheelTimer;
import org.jupiter.common.util.timer.Timeout;
import org.jupiter.common.util.timer.TimerTask;
import org.jupiter.rpc.DispatchType;
import org.jupiter.rpc.JResponse;
import org.jupiter.rpc.consumer.ConsumerInterceptor;
import org.jupiter.rpc.consumer.future.InvokeFuture;
import org.jupiter.rpc.exception.JupiterBizException;
import org.jupiter.rpc.exception.JupiterRemoteException;
import org.jupiter.rpc.exception.JupiterSerializationException;
import org.jupiter.rpc.exception.JupiterTimeoutException;
import org.jupiter.rpc.model.metadata.ResultWrapper;
import org.jupiter.transport.Status;
import org.jupiter.transport.channel.JChannel;

public class DefaultInvokeFuture<V>
extends CompletableFuture<V>
implements InvokeFuture<V> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultInvokeFuture.class);
    private static final long DEFAULT_TIMEOUT_NANOSECONDS = TimeUnit.MILLISECONDS.toNanos(JConstants.DEFAULT_TIMEOUT);
    private static final int FUTURES_CONTAINER_INITIAL_CAPACITY = SystemPropertyUtil.getInt((String)"jupiter.rpc.invoke.futures_container_initial_capacity", (int)1024);
    private static final long TIMEOUT_SCANNER_INTERVAL_MILLIS = SystemPropertyUtil.getLong((String)"jupiter.rpc.invoke.timeout_scanner_interval_millis", (long)50L);
    private static final ConcurrentMap<Long, DefaultInvokeFuture<?>> roundFutures = Maps.newConcurrentMapLong((int)FUTURES_CONTAINER_INITIAL_CAPACITY);
    private static final ConcurrentMap<String, DefaultInvokeFuture<?>> broadcastFutures = Maps.newConcurrentMap((int)FUTURES_CONTAINER_INITIAL_CAPACITY);
    private static final HashedWheelTimer timeoutScanner = new HashedWheelTimer((ThreadFactory)new NamedThreadFactory("futures.timeout.scanner", true), TIMEOUT_SCANNER_INTERVAL_MILLIS, TimeUnit.MILLISECONDS, 4096);
    private final long invokeId;
    private final JChannel channel;
    private final Class<V> returnType;
    private final long timeout;
    private final long startTime = System.nanoTime();
    private volatile boolean sent = false;
    private ConsumerInterceptor[] interceptors;

    public static <T> DefaultInvokeFuture<T> with(long invokeId, JChannel channel, long timeoutMillis, Class<T> returnType, DispatchType dispatchType) {
        return new DefaultInvokeFuture<T>(invokeId, channel, timeoutMillis, returnType, dispatchType);
    }

    private DefaultInvokeFuture(long invokeId, JChannel channel, long timeoutMillis, Class<V> returnType, DispatchType dispatchType) {
        TimeoutTask timeoutTask;
        this.invokeId = invokeId;
        this.channel = channel;
        this.timeout = timeoutMillis > 0L ? TimeUnit.MILLISECONDS.toNanos(timeoutMillis) : DEFAULT_TIMEOUT_NANOSECONDS;
        this.returnType = returnType;
        switch (dispatchType) {
            case ROUND: {
                roundFutures.put(invokeId, this);
                timeoutTask = new TimeoutTask(invokeId);
                break;
            }
            case BROADCAST: {
                String channelId = channel.id();
                broadcastFutures.put(DefaultInvokeFuture.subInvokeId(channelId, invokeId), this);
                timeoutTask = new TimeoutTask(channelId, invokeId);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported " + (Object)((Object)dispatchType));
            }
        }
        timeoutScanner.newTimeout((TimerTask)timeoutTask, this.timeout, TimeUnit.NANOSECONDS);
    }

    public JChannel channel() {
        return this.channel;
    }

    @Override
    public Class<V> returnType() {
        return this.returnType;
    }

    @Override
    public V getResult() throws Throwable {
        try {
            return (V)this.get(this.timeout, TimeUnit.NANOSECONDS);
        }
        catch (TimeoutException e) {
            throw new JupiterTimeoutException(e, this.channel.remoteAddress(), this.sent ? Status.SERVER_TIMEOUT : Status.CLIENT_TIMEOUT);
        }
    }

    public void markSent() {
        this.sent = true;
    }

    public ConsumerInterceptor[] interceptors() {
        return this.interceptors;
    }

    public DefaultInvokeFuture<V> interceptors(ConsumerInterceptor[] interceptors) {
        this.interceptors = interceptors;
        return this;
    }

    private void doReceived(JResponse response) {
        byte status = response.status();
        if (status == Status.OK.value()) {
            ResultWrapper wrapper = response.result();
            this.complete(wrapper.getResult());
        } else {
            this.setException(status, response);
        }
        ConsumerInterceptor[] interceptors = this.interceptors;
        if (interceptors != null) {
            for (int i = interceptors.length - 1; i >= 0; --i) {
                interceptors[i].afterInvoke(response, this.channel);
            }
        }
    }

    private void setException(byte status, JResponse response) {
        Throwable cause;
        if (status == Status.SERVER_TIMEOUT.value()) {
            cause = new JupiterTimeoutException(this.channel.remoteAddress(), Status.SERVER_TIMEOUT);
        } else if (status == Status.CLIENT_TIMEOUT.value()) {
            cause = new JupiterTimeoutException(this.channel.remoteAddress(), Status.CLIENT_TIMEOUT);
        } else if (status == Status.DESERIALIZATION_FAIL.value()) {
            ResultWrapper wrapper = response.result();
            cause = (JupiterSerializationException)wrapper.getResult();
        } else if (status == Status.SERVICE_EXPECTED_ERROR.value()) {
            ResultWrapper wrapper = response.result();
            cause = (Throwable)wrapper.getResult();
        } else if (status == Status.SERVICE_UNEXPECTED_ERROR.value()) {
            ResultWrapper wrapper = response.result();
            String message = String.valueOf(wrapper.getResult());
            cause = new JupiterBizException(message, this.channel.remoteAddress());
        } else {
            ResultWrapper wrapper = response.result();
            Object result = wrapper.getResult();
            cause = result instanceof JupiterRemoteException ? (JupiterRemoteException)result : new JupiterRemoteException(response.toString(), this.channel.remoteAddress());
        }
        this.completeExceptionally(cause);
    }

    public static void received(JChannel channel, JResponse response) {
        long invokeId = response.id();
        DefaultInvokeFuture future = (DefaultInvokeFuture)roundFutures.remove(invokeId);
        if (future == null) {
            future = (DefaultInvokeFuture)broadcastFutures.remove(DefaultInvokeFuture.subInvokeId(channel.id(), invokeId));
        }
        if (future == null) {
            logger.warn("A timeout response [{}] finally returned on {}.", (Object)response, (Object)channel);
            return;
        }
        future.doReceived(response);
    }

    public static void fakeReceived(JChannel channel, JResponse response, DispatchType dispatchType) {
        long invokeId = response.id();
        DefaultInvokeFuture future = null;
        if (dispatchType == DispatchType.ROUND) {
            future = (DefaultInvokeFuture)roundFutures.remove(invokeId);
        } else if (dispatchType == DispatchType.BROADCAST) {
            future = (DefaultInvokeFuture)broadcastFutures.remove(DefaultInvokeFuture.subInvokeId(channel.id(), invokeId));
        }
        if (future == null) {
            return;
        }
        future.doReceived(response);
    }

    private static String subInvokeId(String channelId, long invokeId) {
        return channelId + invokeId;
    }

    static final class TimeoutTask
    implements TimerTask {
        private final String channelId;
        private final long invokeId;

        public TimeoutTask(long invokeId) {
            this.channelId = null;
            this.invokeId = invokeId;
        }

        public TimeoutTask(String channelId, long invokeId) {
            this.channelId = channelId;
            this.invokeId = invokeId;
        }

        public void run(Timeout timeout) throws Exception {
            DefaultInvokeFuture future = this.channelId == null ? (DefaultInvokeFuture)roundFutures.remove(this.invokeId) : (DefaultInvokeFuture)broadcastFutures.remove(DefaultInvokeFuture.subInvokeId(this.channelId, this.invokeId));
            if (future != null) {
                this.processTimeout(future);
            }
        }

        private void processTimeout(DefaultInvokeFuture<?> future) {
            if (System.nanoTime() - ((DefaultInvokeFuture)future).startTime > ((DefaultInvokeFuture)future).timeout) {
                JResponse response = new JResponse(((DefaultInvokeFuture)future).invokeId);
                response.status(((DefaultInvokeFuture)future).sent ? Status.SERVER_TIMEOUT : Status.CLIENT_TIMEOUT);
                ((DefaultInvokeFuture)future).doReceived(response);
            }
        }
    }
}

