/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.rpc.consumer.future;

import java.util.concurrent.CompletableFuture;
import org.jupiter.common.util.Requires;
import org.jupiter.rpc.consumer.future.FailsafeInvokeFuture;
import org.jupiter.rpc.consumer.future.InvokeFuture;
import org.jupiter.rpc.consumer.future.InvokeFutureGroup;

public class InvokeFutureContext {
    private static final ThreadLocal<InvokeFuture<?>> futureThreadLocal = new ThreadLocal();

    public static InvokeFuture<?> future() {
        InvokeFuture future = (InvokeFuture)Requires.requireNotNull(futureThreadLocal.get(), (Object)"future");
        futureThreadLocal.remove();
        return future;
    }

    public static <V> InvokeFuture<V> future(Class<V> expectReturnType) {
        InvokeFuture<?> f = InvokeFutureContext.future();
        InvokeFutureContext.checkReturnType(f.returnType(), expectReturnType);
        return f;
    }

    public static CompletableFuture<?> completableFuture() {
        return (CompletableFuture)((Object)InvokeFutureContext.future());
    }

    public static <V> CompletableFuture<V> completableFuture(Class<V> expectReturnType) {
        return (CompletableFuture)((Object)InvokeFutureContext.future(expectReturnType));
    }

    public static <V> InvokeFutureGroup<V> futureBroadcast(Class<V> expectReturnType) {
        InvokeFuture real_f;
        InvokeFuture<?> f = InvokeFutureContext.future();
        InvokeFutureContext.checkReturnType(f.returnType(), expectReturnType);
        if (f instanceof InvokeFutureGroup) {
            return (InvokeFutureGroup)f;
        }
        if (f instanceof FailsafeInvokeFuture && (real_f = ((FailsafeInvokeFuture)f).future()) instanceof InvokeFutureGroup) {
            return (InvokeFutureGroup)real_f;
        }
        throw new UnsupportedOperationException("broadcast");
    }

    public static void set(InvokeFuture<?> future) {
        futureThreadLocal.set(future);
    }

    private static void checkReturnType(Class<?> realType, Class<?> expectType) {
        if (!expectType.isAssignableFrom(realType)) {
            throw new IllegalArgumentException("illegal returnType, expect type is [" + expectType.getName() + "], but real type is [" + realType.getName() + "]");
        }
    }
}

