/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.rpc.consumer.invoker;

import java.util.List;
import org.jupiter.rpc.DefaultFilterChain;
import org.jupiter.rpc.JFilter;
import org.jupiter.rpc.JFilterChain;
import org.jupiter.rpc.JFilterContext;
import org.jupiter.rpc.JFilterLoader;
import org.jupiter.rpc.JRequest;
import org.jupiter.rpc.consumer.cluster.ClusterInvoker;
import org.jupiter.rpc.consumer.dispatcher.Dispatcher;
import org.jupiter.rpc.consumer.future.InvokeFuture;
import org.jupiter.rpc.consumer.invoker.ClusterStrategyBridging;
import org.jupiter.rpc.model.metadata.ClusterStrategyConfig;
import org.jupiter.rpc.model.metadata.MessageWrapper;
import org.jupiter.rpc.model.metadata.MethodSpecialConfig;
import org.jupiter.rpc.model.metadata.ServiceMetadata;

public abstract class AbstractInvoker {
    private final String appName;
    private final ServiceMetadata metadata;
    private final ClusterStrategyBridging clusterStrategyBridging;

    public AbstractInvoker(String appName, ServiceMetadata metadata, Dispatcher dispatcher, ClusterStrategyConfig defaultStrategy, List<MethodSpecialConfig> methodSpecialConfigs) {
        this.appName = appName;
        this.metadata = metadata;
        this.clusterStrategyBridging = new ClusterStrategyBridging(dispatcher, defaultStrategy, methodSpecialConfigs);
    }

    protected Object doInvoke(String methodName, Object[] args, Class<?> returnType, boolean sync) throws Throwable {
        JRequest request = this.createRequest(methodName, args);
        ClusterInvoker invoker = this.clusterStrategyBridging.findClusterInvoker(methodName);
        Context invokeCtx = new Context(invoker, returnType, sync);
        Chains.invoke(request, invokeCtx);
        return invokeCtx.getResult();
    }

    private JRequest createRequest(String methodName, Object[] args) {
        MessageWrapper message = new MessageWrapper(this.metadata);
        message.setAppName(this.appName);
        message.setMethodName(methodName);
        message.setArgs(args);
        JRequest request = new JRequest();
        request.message(message);
        return request;
    }

    static class Chains {
        private static final JFilterChain headChain;

        Chains() {
        }

        static <T extends JFilterContext> T invoke(JRequest request, T invokeCtx) throws Throwable {
            headChain.doFilter(request, invokeCtx);
            return invokeCtx;
        }

        static {
            DefaultFilterChain invokeChain = new DefaultFilterChain(new ClusterInvokeFilter(), null);
            headChain = JFilterLoader.loadExtFilters(invokeChain, JFilter.Type.CONSUMER);
        }
    }

    static class ClusterInvokeFilter
    implements JFilter {
        ClusterInvokeFilter() {
        }

        @Override
        public JFilter.Type getType() {
            return JFilter.Type.CONSUMER;
        }

        @Override
        public <T extends JFilterContext> void doFilter(JRequest request, T filterCtx, JFilterChain next) throws Throwable {
            Context invokeCtx = (Context)filterCtx;
            ClusterInvoker invoker = invokeCtx.getInvoker();
            Class<?> returnType = invokeCtx.getReturnType();
            InvokeFuture<?> future = invoker.invoke(request, returnType);
            if (invokeCtx.isSync()) {
                invokeCtx.setResult(future.getResult());
            } else {
                invokeCtx.setResult(future);
            }
        }
    }

    static class Context
    implements JFilterContext {
        private final ClusterInvoker invoker;
        private final Class<?> returnType;
        private final boolean sync;
        private Object result;

        Context(ClusterInvoker invoker, Class<?> returnType, boolean sync) {
            this.invoker = invoker;
            this.returnType = returnType;
            this.sync = sync;
        }

        @Override
        public JFilter.Type getType() {
            return JFilter.Type.CONSUMER;
        }

        public ClusterInvoker getInvoker() {
            return this.invoker;
        }

        public Class<?> getReturnType() {
            return this.returnType;
        }

        public boolean isSync() {
            return this.sync;
        }

        public Object getResult() {
            return this.result;
        }

        public void setResult(Object result) {
            this.result = result;
        }
    }
}

