/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.rpc.consumer.invoker;

import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import org.jupiter.rpc.consumer.dispatcher.Dispatcher;
import org.jupiter.rpc.consumer.future.InvokeFuture;
import org.jupiter.rpc.consumer.invoker.AbstractInvoker;
import org.jupiter.rpc.model.metadata.ClusterStrategyConfig;
import org.jupiter.rpc.model.metadata.MethodSpecialConfig;
import org.jupiter.rpc.model.metadata.ServiceMetadata;

public class AutoInvoker
extends AbstractInvoker {
    public AutoInvoker(String appName, ServiceMetadata metadata, Dispatcher dispatcher, ClusterStrategyConfig defaultStrategy, List<MethodSpecialConfig> methodSpecialConfigs) {
        super(appName, metadata, dispatcher, defaultStrategy, methodSpecialConfigs);
    }

    @RuntimeType
    public Object invoke(@Origin Method method, @AllArguments @RuntimeType Object[] args) throws Throwable {
        Class<CompletableFuture> returnType = method.getReturnType();
        if (!CompletableFuture.class.isAssignableFrom(returnType)) {
            return this.doInvoke(method.getName(), args, returnType, true);
        }
        CompletableFuture<Object> cf = AutoInvoker.createCompletableFuture(returnType);
        InvokeFuture inf = (InvokeFuture)this.doInvoke(method.getName(), args, returnType, false);
        inf.whenComplete((result, throwable) -> {
            if (throwable == null) {
                try {
                    cf.complete(result);
                }
                catch (Throwable t) {
                    cf.completeExceptionally(t);
                }
            } else {
                cf.completeExceptionally((Throwable)throwable);
            }
        });
        return cf;
    }

    private static CompletableFuture<Object> createCompletableFuture(Class<CompletableFuture> cls) {
        if (cls == CompletableFuture.class) {
            return new CompletableFuture<Object>();
        }
        try {
            return cls.newInstance();
        }
        catch (Throwable t) {
            throw new UnsupportedOperationException("fail to create instance with default constructor", t);
        }
    }
}

