/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.rpc.consumer.processor;

import org.jupiter.common.util.JServiceLoader;
import org.jupiter.common.util.StackTraceUtil;
import org.jupiter.common.util.SystemPropertyUtil;
import org.jupiter.common.util.internal.logging.InternalLogger;
import org.jupiter.common.util.internal.logging.InternalLoggerFactory;
import org.jupiter.rpc.consumer.processor.ConsumerExecutorFactory;
import org.jupiter.rpc.executor.CallerRunsExecutorFactory;
import org.jupiter.rpc.executor.CloseableExecutor;
import org.jupiter.rpc.executor.ExecutorFactory;

public class ConsumerExecutors {
    private static final InternalLogger logger;
    private static final CloseableExecutor executor;

    public static CloseableExecutor executor() {
        return executor;
    }

    static {
        ExecutorFactory factory;
        logger = InternalLoggerFactory.getInstance(ConsumerExecutors.class);
        String factoryName = SystemPropertyUtil.get((String)"jupiter.executor.factory.consumer.factory_name", (String)"callerRuns");
        try {
            factory = (ExecutorFactory)JServiceLoader.load(ConsumerExecutorFactory.class).find(factoryName);
        }
        catch (Throwable t) {
            logger.warn("Failed to load consumer's executor factory [{}], cause: {}, [CallerRunsExecutorFactory] will be used as default.", (Object)factoryName, (Object)StackTraceUtil.stackTrace((Throwable)t));
            factory = new CallerRunsExecutorFactory();
        }
        executor = factory.newExecutor(ExecutorFactory.Target.CONSUMER, "jupiter-consumer-processor");
    }
}

