/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.rpc.executor;

import org.jupiter.common.concurrent.disruptor.TaskDispatcher;
import org.jupiter.common.concurrent.disruptor.WaitStrategyType;
import org.jupiter.common.util.SpiMetadata;
import org.jupiter.common.util.SystemPropertyUtil;
import org.jupiter.common.util.internal.logging.InternalLogger;
import org.jupiter.common.util.internal.logging.InternalLoggerFactory;
import org.jupiter.rpc.executor.AbstractExecutorFactory;
import org.jupiter.rpc.executor.CloseableExecutor;
import org.jupiter.rpc.executor.ExecutorFactory;

@SpiMetadata(name="disruptor")
public class DisruptorExecutorFactory
extends AbstractExecutorFactory {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DisruptorExecutorFactory.class);

    @Override
    public CloseableExecutor newExecutor(ExecutorFactory.Target target, String name) {
        final TaskDispatcher executor = new TaskDispatcher(this.coreWorkers(target), this.threadFactory(name), this.queueCapacity(target), this.maxWorkers(target), this.waitStrategyType(target, WaitStrategyType.LITE_BLOCKING_WAIT), "jupiter");
        return new CloseableExecutor(){

            @Override
            public void execute(Runnable task) {
                executor.execute(task);
            }

            @Override
            public void shutdown() {
                logger.warn("DisruptorExecutorFactory#{} shutdown.", (Object)executor);
                executor.shutdown();
            }
        };
    }

    private WaitStrategyType waitStrategyType(ExecutorFactory.Target target, WaitStrategyType defaultType) {
        WaitStrategyType strategyType = null;
        switch (target) {
            case CONSUMER: {
                strategyType = WaitStrategyType.parse((String)SystemPropertyUtil.get((String)"jupiter.executor.factory.consumer.disruptor.wait.strategy.type"));
                break;
            }
            case PROVIDER: {
                strategyType = WaitStrategyType.parse((String)SystemPropertyUtil.get((String)"jupiter.executor.factory.provider.disruptor.wait.strategy.type"));
            }
        }
        return strategyType == null ? defaultType : strategyType;
    }
}

