/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.rpc.executor;

import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.atomic.AtomicInteger;
import org.jupiter.common.util.SpiMetadata;
import org.jupiter.common.util.StackTraceUtil;
import org.jupiter.common.util.internal.InternalForkJoinWorkerThread;
import org.jupiter.common.util.internal.logging.InternalLogger;
import org.jupiter.common.util.internal.logging.InternalLoggerFactory;
import org.jupiter.rpc.executor.AbstractExecutorFactory;
import org.jupiter.rpc.executor.CloseableExecutor;
import org.jupiter.rpc.executor.ExecutorFactory;

@SpiMetadata(name="forkJoin")
public class ForkJoinPoolExecutorFactory
extends AbstractExecutorFactory {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ForkJoinPoolExecutorFactory.class);

    @Override
    public CloseableExecutor newExecutor(ExecutorFactory.Target target, String name) {
        final ForkJoinPool executor = new ForkJoinPool(this.coreWorkers(target), new DefaultForkJoinWorkerThreadFactory(name), new DefaultUncaughtExceptionHandler(), true);
        return new CloseableExecutor(){

            @Override
            public void execute(Runnable task) {
                executor.execute(task);
            }

            @Override
            public void shutdown() {
                logger.warn("ForkJoinPoolExecutorFactory#{} shutdown.", (Object)executor);
                executor.shutdownNow();
            }
        };
    }

    private static final class DefaultUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private DefaultUncaughtExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            logger.error("Uncaught exception in thread[{}], {}.", (Object)t.getName(), (Object)StackTraceUtil.stackTrace((Throwable)e));
        }
    }

    private static final class DefaultForkJoinWorkerThreadFactory
    implements ForkJoinPool.ForkJoinWorkerThreadFactory {
        private final AtomicInteger idx = new AtomicInteger();
        private final String namePrefix;

        public DefaultForkJoinWorkerThreadFactory(String namePrefix) {
            this.namePrefix = namePrefix;
        }

        @Override
        public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
            InternalForkJoinWorkerThread thread = new InternalForkJoinWorkerThread(pool);
            thread.setName(this.namePrefix + '-' + this.idx.getAndIncrement());
            return thread;
        }
    }
}

