/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.rpc.load.balance;

import org.jupiter.common.util.JServiceLoader;
import org.jupiter.rpc.load.balance.ExtSpiLoadBalancerFactory;
import org.jupiter.rpc.load.balance.LoadBalancer;
import org.jupiter.rpc.load.balance.LoadBalancerType;
import org.jupiter.rpc.load.balance.RandomLoadBalancer;
import org.jupiter.rpc.load.balance.RoundRobinLoadBalancer;

public final class LoadBalancerFactory {
    public static LoadBalancer getInstance(LoadBalancerType type, String name) {
        if (type == LoadBalancerType.RANDOM) {
            return RandomLoadBalancer.instance();
        }
        if (type == LoadBalancerType.ROUND_ROBIN) {
            return RoundRobinLoadBalancer.instance();
        }
        if (type == LoadBalancerType.EXT_SPI) {
            return ExtSpiFactoryHolder.factory.getInstance(name);
        }
        return RandomLoadBalancer.instance();
    }

    private LoadBalancerFactory() {
    }

    static class ExtSpiFactoryHolder {
        static final ExtSpiLoadBalancerFactory factory = (ExtSpiLoadBalancerFactory)JServiceLoader.load(ExtSpiLoadBalancerFactory.class).first();

        ExtSpiFactoryHolder() {
        }
    }
}

