/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.rpc.model.metadata;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.jupiter.common.util.JConstants;
import org.jupiter.common.util.Pair;
import org.jupiter.common.util.Requires;
import org.jupiter.rpc.JRequest;
import org.jupiter.rpc.flow.control.FlowController;
import org.jupiter.rpc.model.metadata.ServiceMetadata;
import org.jupiter.rpc.provider.ProviderInterceptor;

public class ServiceWrapper
implements Serializable {
    private static final long serialVersionUID = 6690575889849847348L;
    private final ServiceMetadata metadata;
    private final Object serviceProvider;
    private final ProviderInterceptor[] interceptors;
    private final Map<String, List<Pair<Class<?>[], Class<?>[]>>> extensions;
    private int weight = JConstants.DEFAULT_WEIGHT;
    private Executor executor;
    private FlowController<JRequest> flowController;

    public ServiceWrapper(String group, String providerName, String version, Object serviceProvider, ProviderInterceptor[] interceptors, Map<String, List<Pair<Class<?>[], Class<?>[]>>> extensions) {
        this.metadata = new ServiceMetadata(group, providerName, version);
        this.interceptors = interceptors;
        this.extensions = (Map)Requires.requireNotNull(extensions, (Object)"extensions");
        this.serviceProvider = Requires.requireNotNull((Object)serviceProvider, (Object)"serviceProvider");
    }

    public ServiceMetadata getMetadata() {
        return this.metadata;
    }

    public Object getServiceProvider() {
        return this.serviceProvider;
    }

    public ProviderInterceptor[] getInterceptors() {
        return this.interceptors;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public FlowController<JRequest> getFlowController() {
        return this.flowController;
    }

    public void setFlowController(FlowController<JRequest> flowController) {
        this.flowController = flowController;
    }

    public List<Pair<Class<?>[], Class<?>[]>> getMethodExtension(String methodName) {
        return this.extensions.get(methodName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceWrapper wrapper = (ServiceWrapper)o;
        return this.metadata.equals(wrapper.metadata);
    }

    public int hashCode() {
        return this.metadata.hashCode();
    }

    public String toString() {
        return "ServiceWrapper{metadata=" + this.metadata + ", serviceProvider=" + this.serviceProvider + ", interceptors=" + Arrays.toString(this.interceptors) + ", extensions=" + this.extensions + ", weight=" + this.weight + ", executor=" + this.executor + ", flowController=" + this.flowController + '}';
    }
}

