/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.maven;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.FileSet;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.project.artifact.MavenMetadataSource;
import org.apache.maven.settings.Settings;
import org.jvnet.jaxb.maven.DependencyResource;
import org.jvnet.jaxb.maven.DependencyResourceResolver;
import org.jvnet.jaxb.maven.IOptionsFactory;
import org.jvnet.jaxb.maven.ResourceEntry;
import org.jvnet.jaxb.maven.util.ArtifactUtils;
import org.jvnet.jaxb.maven.util.IOUtils;
import org.sonatype.plexus.build.incremental.BuildContext;
import org.sonatype.plexus.build.incremental.DefaultBuildContext;

public abstract class AbstractXJC2Mojo<O>
extends AbstractMojo
implements DependencyResourceResolver {
    @Parameter(defaultValue="${settings}", readonly=true)
    private Settings settings;
    @Parameter(property="maven.xjc2.useActiveProxyAsHttpproxy", defaultValue="false")
    private boolean useActiveProxyAsHttpproxy = false;
    @Parameter(property="maven.xjc2.proxyHost")
    private String proxyHost;
    @Parameter(property="maven.xjc2.proxyPort")
    private int proxyPort;
    @Parameter(property="maven.xjc2.proxyUsername")
    private String proxyUsername;
    @Parameter(property="maven.xjc2.proxyPassword")
    private String proxyPassword;
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Parameter(property="locale")
    private String locale;
    @Parameter(property="maven.xjc2.schemaLanguage")
    private String schemaLanguage;
    @Parameter(defaultValue="src/main/resources", property="maven.xjc2.schemaDirectory", required=true)
    private File schemaDirectory;
    @Parameter
    private String[] schemaIncludes = new String[]{"*.xsd"};
    @Parameter
    private String[] schemaExcludes;
    @Parameter
    private ResourceEntry[] schemas = new ResourceEntry[0];
    @Parameter(property="maven.xjc2.bindingDirectory")
    private File bindingDirectory;
    @Parameter(property="maven.xjc2.catalogDirectory")
    private File catalogDirectory;
    @Parameter
    private String[] bindingIncludes = new String[]{"*.xjb"};
    @Parameter
    private String[] bindingExcludes;
    @Parameter
    private ResourceEntry[] bindings = new ResourceEntry[0];
    @Parameter(defaultValue="false", property="maven.xjc2.disableDefaultExcludes")
    private boolean disableDefaultExcludes;
    @Parameter(property="maven.xjc2.catalog")
    private File catalog;
    @Parameter
    private String[] catalogIncludes = new String[]{"*.cat"};
    @Parameter
    private String[] catalogExcludes;
    @Parameter
    private ResourceEntry[] catalogs = new ResourceEntry[0];
    @Parameter(property="maven.xjc2.catalogResolver")
    protected String catalogResolver = null;
    @Parameter(defaultValue="false", property="maven.xjc2.disableSystemIdResolution")
    private boolean disableSystemIdResolution;
    @Parameter(defaultValue="false", property="maven.xjc2.relativeCatalogResolution")
    private boolean relativeCatalogResolution;
    @Parameter(property="maven.xjc2.generatePackage")
    private String generatePackage;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/xjc", property="maven.xjc2.generateDirectory", required=true)
    private File generateDirectory;
    @Parameter(defaultValue="true", property="maven.xjc2.addCompileSourceRoot", required=false)
    private boolean addCompileSourceRoot = true;
    @Parameter(defaultValue="false", property="maven.xjc2.addTestCompileSourceRoot", required=false)
    private boolean addTestCompileSourceRoot = false;
    @Parameter(defaultValue="false", property="maven.xjc2.readOnly")
    private boolean readOnly;
    @Parameter(defaultValue="true", property="maven.xjc2.packageLevelAnnotations")
    private boolean packageLevelAnnotations = true;
    @Parameter(defaultValue="false", property="maven.xjc2.noFileHeader")
    private boolean noFileHeader = false;
    @Parameter(defaultValue="false", property="maven.xjc2.enableIntrospection")
    private boolean enableIntrospection = false;
    @Parameter(defaultValue="true", property="maven.xjc2.disableXmlSecurity")
    private boolean disableXmlSecurity = true;
    @Parameter(defaultValue="all", property="maven.xjc2.accessExternalSchema")
    private String accessExternalSchema = "all";
    @Parameter(defaultValue="all", property="maven.xjc2.accessExternalDTD")
    private String accessExternalDTD = "all";
    @Parameter(defaultValue="true", property="maven.xjc2.enableExternalEntityProcessing")
    private boolean enableExternalEntityProcessing;
    @Parameter(defaultValue="false")
    private boolean contentForWildcard;
    @Parameter(defaultValue="true", property="maven.xjc2.extension")
    private boolean extension;
    @Parameter(defaultValue="true", property="maven.xjc2.strict")
    private boolean strict = true;
    @Parameter(defaultValue="true", property="maven.xjc2.writeCode")
    private boolean writeCode = true;
    @Parameter(defaultValue="false", property="maven.xjc2.verbose")
    private boolean verbose;
    @Parameter(defaultValue="false", property="maven.xjc2.debug")
    private boolean debug;
    @Parameter
    private List<String> args = new LinkedList<String>();
    @Parameter(defaultValue="false", property="maven.xjc2.forceRegenerate")
    private boolean forceRegenerate;
    @Parameter(defaultValue="false", property="maven.xjc2.removeOldOutput")
    private boolean removeOldOutput;
    @Parameter(defaultValue="true", property="maven.xjc2.removeOldPackages")
    private boolean cleanPackageDirectories = true;
    @Parameter
    private String[] produces = new String[]{"**/*.*", "**/*.java", "**/bgm.ser", "**/jaxb.properties"};
    @Deprecated
    @Parameter
    private File[] otherDepends;
    @Parameter
    private String[] otherDependsIncludes;
    @Parameter
    private String[] otherDependsExcludes;
    @Parameter(property="maven.xjc2.episodeFile")
    private File episodeFile;
    @Parameter(property="maven.xjc2.episode", defaultValue="true")
    private boolean episode = true;
    @Parameter(property="maven.xjc2.addIfExistsToEpisodeSchemaBindings", defaultValue="true")
    private boolean addIfExistsToEpisodeSchemaBindings = true;
    @Parameter(property="maven.xjc2.markGenerated", defaultValue="false")
    private boolean markGenerated = false;
    @Parameter
    protected Dependency[] plugins;
    @Component
    private ArtifactResolver artifactResolver;
    @Component
    private ArtifactMetadataSource artifactMetadataSource;
    @Component
    private ArtifactFactory artifactFactory;
    @Parameter(defaultValue="${localRepository}", required=true)
    private ArtifactRepository localRepository;
    @Component(role=MavenProjectBuilder.class)
    private MavenProjectBuilder mavenProjectBuilder;
    @Component
    private BuildContext buildContext = new DefaultBuildContext();
    @Parameter(defaultValue="${plugin.artifacts}", required=true)
    private List<Artifact> pluginArtifacts;
    @Parameter
    private Dependency[] episodes;
    @Parameter
    private boolean useDependenciesAsEpisodes = false;
    @Parameter(defaultValue="false")
    private boolean scanDependenciesForBindings = false;
    @Parameter(defaultValue="2.2")
    private String specVersion = "2.2";
    private static final String XML_SCHEMA_CLASS_NAME = "XmlSchema";
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    private static final String XML_SCHEMA_CLASS_QNAME = "javax.xml.bind.annotation.XmlSchema";
    private static final String XML_SCHEMA_RESOURCE_NAME = "XmlSchema.class";
    private static final String XML_SCHEMA_RESOURCE_QNAME = "/javax/xml/bind/annotation/XmlSchema.class";
    private static final String XML_ELEMENT_REF_CLASS_NAME = "XmlElementRef";
    private static final String XML_ELEMENT_REF_CLASS_QNAME = "javax.xml.bind.annotation.XmlElementRef";

    public Settings getSettings() {
        return this.settings;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public boolean isUseActiveProxyAsHttpproxy() {
        return this.useActiveProxyAsHttpproxy;
    }

    public void setUseActiveProxyAsHttpproxy(boolean useActiveProxyAsHttpproxy) {
        this.useActiveProxyAsHttpproxy = useActiveProxyAsHttpproxy;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getSchemaLanguage() {
        return this.schemaLanguage;
    }

    public void setSchemaLanguage(String schemaLanguage) {
        this.schemaLanguage = schemaLanguage;
    }

    public File getSchemaDirectory() {
        return this.schemaDirectory;
    }

    public void setSchemaDirectory(File schemaDirectory) {
        this.schemaDirectory = schemaDirectory;
    }

    public String[] getSchemaIncludes() {
        return this.schemaIncludes;
    }

    public void setSchemaIncludes(String[] schemaIncludes) {
        this.schemaIncludes = schemaIncludes;
    }

    public String[] getSchemaExcludes() {
        return this.schemaExcludes;
    }

    public void setSchemaExcludes(String[] schemaExcludes) {
        this.schemaExcludes = schemaExcludes;
    }

    public ResourceEntry[] getSchemas() {
        return this.schemas;
    }

    public void setSchemas(ResourceEntry[] schemas) {
        this.schemas = schemas;
    }

    public void setBindingDirectory(File bindingDirectory) {
        this.bindingDirectory = bindingDirectory;
    }

    public File getBindingDirectory() {
        return this.bindingDirectory != null ? this.bindingDirectory : this.getSchemaDirectory();
    }

    public void setCatalogDirectory(File catalogDirectory) {
        this.catalogDirectory = catalogDirectory;
    }

    public File getCatalogDirectory() {
        return this.catalogDirectory != null ? this.catalogDirectory : this.getSchemaDirectory();
    }

    public String[] getBindingIncludes() {
        return this.bindingIncludes;
    }

    public void setBindingIncludes(String[] bindingIncludes) {
        this.bindingIncludes = bindingIncludes;
    }

    public String[] getBindingExcludes() {
        return this.bindingExcludes;
    }

    public void setBindingExcludes(String[] bindingExcludes) {
        this.bindingExcludes = bindingExcludes;
    }

    public ResourceEntry[] getBindings() {
        return this.bindings;
    }

    public void setBindings(ResourceEntry[] bindings) {
        this.bindings = bindings;
    }

    public boolean getDisableDefaultExcludes() {
        return this.disableDefaultExcludes;
    }

    public void setDisableDefaultExcludes(boolean disableDefaultExcludes) {
        this.disableDefaultExcludes = disableDefaultExcludes;
    }

    public File getCatalog() {
        return this.catalog;
    }

    public void setCatalog(File catalog) {
        this.catalog = catalog;
    }

    public String[] getCatalogIncludes() {
        return this.catalogIncludes;
    }

    public void setCatalogIncludes(String[] catalogIncludes) {
        this.catalogIncludes = catalogIncludes;
    }

    public String[] getCatalogExcludes() {
        return this.catalogExcludes;
    }

    public void setCatalogExcludes(String[] catalogExcludes) {
        this.catalogExcludes = catalogExcludes;
    }

    public ResourceEntry[] getCatalogs() {
        return this.catalogs;
    }

    public void setCatalogs(ResourceEntry[] catalogs) {
        this.catalogs = catalogs;
    }

    protected List<URI> createCatalogURIs() throws MojoExecutionException {
        File catalog = this.getCatalog();
        ResourceEntry[] catalogs = this.getCatalogs();
        ArrayList<URI> catalogUris = new ArrayList<URI>((catalog == null ? 0 : 1) + catalogs.length);
        if (catalog != null) {
            catalogUris.add(this.getCatalog().toURI());
        }
        for (ResourceEntry resourceEntry : catalogs) {
            catalogUris.addAll(this.createResourceEntryUris(resourceEntry, this.getCatalogDirectory().getAbsolutePath(), this.getCatalogIncludes(), this.getCatalogExcludes()));
        }
        return catalogUris;
    }

    public String getCatalogResolver() {
        return this.catalogResolver;
    }

    public void setCatalogResolver(String catalogResolver) {
        this.catalogResolver = catalogResolver;
    }

    public boolean getDisableSystemIdResolution() {
        return this.disableSystemIdResolution;
    }

    public void setDisableSystemIdResolution(boolean disableSystemIdResolution) {
        this.disableSystemIdResolution = disableSystemIdResolution;
    }

    public boolean getRelativeCatalogResolution() {
        return this.relativeCatalogResolution;
    }

    public void setRelativeCatalogResolution(boolean relativeCatalogResolution) {
        this.relativeCatalogResolution = relativeCatalogResolution;
    }

    public String getGeneratePackage() {
        return this.generatePackage;
    }

    public void setGeneratePackage(String generatePackage) {
        this.generatePackage = generatePackage;
    }

    public File getGenerateDirectory() {
        return this.generateDirectory;
    }

    public void setGenerateDirectory(File generateDirectory) {
        this.generateDirectory = generateDirectory;
        if (this.getEpisodeFile() == null) {
            File episodeFile = new File(this.getGenerateDirectory(), "META-INF" + File.separator + "sun-jaxb.episode");
            this.setEpisodeFile(episodeFile);
        }
    }

    public boolean getAddCompileSourceRoot() {
        return this.addCompileSourceRoot;
    }

    public void setAddCompileSourceRoot(boolean addCompileSourceRoot) {
        this.addCompileSourceRoot = addCompileSourceRoot;
    }

    public boolean getAddTestCompileSourceRoot() {
        return this.addTestCompileSourceRoot;
    }

    public void setAddTestCompileSourceRoot(boolean addTestCompileSourceRoot) {
        this.addTestCompileSourceRoot = addTestCompileSourceRoot;
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean getPackageLevelAnnotations() {
        return this.packageLevelAnnotations;
    }

    public void setPackageLevelAnnotations(boolean packageLevelAnnotations) {
        this.packageLevelAnnotations = packageLevelAnnotations;
    }

    public boolean getNoFileHeader() {
        return this.noFileHeader;
    }

    public void setNoFileHeader(boolean noFileHeader) {
        this.noFileHeader = noFileHeader;
    }

    public boolean getEnableIntrospection() {
        return this.enableIntrospection;
    }

    public void setEnableIntrospection(boolean enableIntrospection) {
        this.enableIntrospection = enableIntrospection;
    }

    public boolean getDisableXmlSecurity() {
        return this.disableXmlSecurity;
    }

    public void setDisableXmlSecurity(boolean disableXmlSecurity) {
        this.disableXmlSecurity = disableXmlSecurity;
    }

    public String getAccessExternalSchema() {
        return this.accessExternalSchema;
    }

    public void setAccessExternalSchema(String accessExternalSchema) {
        this.accessExternalSchema = accessExternalSchema;
    }

    public String getAccessExternalDTD() {
        return this.accessExternalDTD;
    }

    public void setAccessExternalDTD(String accessExternalDTD) {
        this.accessExternalDTD = accessExternalDTD;
    }

    public boolean isEnableExternalEntityProcessing() {
        return this.enableExternalEntityProcessing;
    }

    public void setEnableExternalEntityProcessing(boolean enableExternalEntityProcessing) {
        this.enableExternalEntityProcessing = enableExternalEntityProcessing;
    }

    public boolean getContentForWildcard() {
        return this.contentForWildcard;
    }

    public void setContentForWildcard(boolean contentForWildcard) {
        this.contentForWildcard = contentForWildcard;
    }

    public boolean getExtension() {
        return this.extension;
    }

    public void setExtension(boolean extension) {
        this.extension = extension;
    }

    public boolean getStrict() {
        return this.strict;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public boolean getWriteCode() {
        return this.writeCode;
    }

    public void setWriteCode(boolean writeCode) {
        this.writeCode = writeCode;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public List<String> getArgs() {
        return this.args;
    }

    public void setArgs(List<String> args) {
        this.args.addAll(args);
    }

    public boolean getForceRegenerate() {
        return this.forceRegenerate;
    }

    public void setForceRegenerate(boolean forceRegenerate) {
        this.forceRegenerate = forceRegenerate;
    }

    public boolean getRemoveOldOutput() {
        return this.removeOldOutput;
    }

    public void setRemoveOldOutput(boolean removeOldOutput) {
        this.removeOldOutput = removeOldOutput;
    }

    public boolean getCleanPackageDirectories() {
        return this.cleanPackageDirectories;
    }

    public void setCleanPackageDirectories(boolean removeOldPackages) {
        this.cleanPackageDirectories = removeOldPackages;
    }

    public String[] getProduces() {
        return this.produces;
    }

    public void setProduces(String[] produces) {
        this.produces = produces;
    }

    @Deprecated
    public File[] getOtherDepends() {
        return this.otherDepends;
    }

    @Deprecated
    public void setOtherDepends(File[] otherDepends) {
        this.otherDepends = otherDepends;
    }

    public String[] getOtherDependsIncludes() {
        return this.otherDependsIncludes;
    }

    public void setOtherDependsIncludes(String[] otherDependsIncludes) {
        this.otherDependsIncludes = otherDependsIncludes;
    }

    public String[] getOtherDependsExcludes() {
        return this.otherDependsExcludes;
    }

    public void setOtherDependsExcludes(String[] otherDependsExcludes) {
        this.otherDependsExcludes = otherDependsExcludes;
    }

    public File getEpisodeFile() {
        return this.episodeFile;
    }

    public void setEpisodeFile(File episodeFile) {
        this.episodeFile = episodeFile;
    }

    public boolean getEpisode() {
        return this.episode;
    }

    public void setEpisode(boolean episode) {
        this.episode = episode;
    }

    public boolean isAddIfExistsToEpisodeSchemaBindings() {
        return this.addIfExistsToEpisodeSchemaBindings;
    }

    public void setAddIfExistsToEpisodeSchemaBindings(boolean addIfExistsToEpisodeSchemaBindings) {
        this.addIfExistsToEpisodeSchemaBindings = addIfExistsToEpisodeSchemaBindings;
    }

    public boolean getMarkGenerated() {
        return this.markGenerated;
    }

    public void setMarkGenerated(boolean markGenerated) {
        this.markGenerated = markGenerated;
    }

    public Dependency[] getPlugins() {
        return this.plugins;
    }

    public void setPlugins(Dependency[] plugins) {
        this.plugins = plugins;
    }

    public Dependency[] getEpisodes() {
        return this.episodes;
    }

    public void setEpisodes(Dependency[] episodes) {
        this.episodes = episodes;
    }

    public boolean getUseDependenciesAsEpisodes() {
        return this.useDependenciesAsEpisodes;
    }

    public void setUseDependenciesAsEpisodes(boolean useDependenciesAsEpisodes) {
        this.useDependenciesAsEpisodes = useDependenciesAsEpisodes;
    }

    public boolean getScanDependenciesForBindings() {
        return this.scanDependenciesForBindings;
    }

    public void setScanDependenciesForBindings(boolean scanDependenciesForBindings) {
        this.scanDependenciesForBindings = scanDependenciesForBindings;
    }

    public String getSpecVersion() {
        return this.specVersion;
    }

    public void setSpecVersion(String specVersion) {
        this.specVersion = specVersion;
    }

    protected void logConfiguration() throws MojoExecutionException {
        this.logApiConfiguration();
        this.getLog().info((CharSequence)("pluginArtifacts:" + this.getPluginArtifacts()));
        this.getLog().info((CharSequence)("specVersion:" + this.getSpecVersion()));
        this.getLog().info((CharSequence)("encoding:" + this.getEncoding()));
        this.getLog().info((CharSequence)("locale:" + this.getLocale()));
        this.getLog().info((CharSequence)("schemaLanguage:" + this.getSchemaLanguage()));
        this.getLog().info((CharSequence)("schemaDirectory:" + this.getSchemaDirectory()));
        this.getLog().info((CharSequence)("schemaIncludes:" + Arrays.toString(this.getSchemaIncludes())));
        this.getLog().info((CharSequence)("schemaExcludes:" + Arrays.toString(this.getSchemaExcludes())));
        this.getLog().info((CharSequence)("schemas:" + Arrays.toString(this.getSchemas())));
        this.getLog().info((CharSequence)("bindingDirectory:" + this.getBindingDirectory()));
        this.getLog().info((CharSequence)("bindingIncludes:" + Arrays.toString(this.getBindingIncludes())));
        this.getLog().info((CharSequence)("bindingExcludes:" + Arrays.toString(this.getBindingExcludes())));
        this.getLog().info((CharSequence)("bindings:" + Arrays.toString(this.getBindings())));
        this.getLog().info((CharSequence)("disableDefaultExcludes:" + this.getDisableDefaultExcludes()));
        this.getLog().info((CharSequence)("catalog:" + this.getCatalog()));
        this.getLog().info((CharSequence)("catalogResolver:" + this.getCatalogResolver()));
        this.getLog().info((CharSequence)("generatePackage:" + this.getGeneratePackage()));
        this.getLog().info((CharSequence)("generateDirectory:" + this.getGenerateDirectory()));
        this.getLog().info((CharSequence)("readOnly:" + this.getReadOnly()));
        this.getLog().info((CharSequence)("extension:" + this.getExtension()));
        this.getLog().info((CharSequence)("strict:" + this.getStrict()));
        this.getLog().info((CharSequence)("writeCode:" + this.getWriteCode()));
        this.getLog().info((CharSequence)("verbose:" + this.getVerbose()));
        this.getLog().info((CharSequence)("debug:" + this.getDebug()));
        this.getLog().info((CharSequence)("args:" + this.getArgs()));
        this.getLog().info((CharSequence)("forceRegenerate:" + this.getForceRegenerate()));
        this.getLog().info((CharSequence)("removeOldOutput:" + this.getRemoveOldOutput()));
        this.getLog().info((CharSequence)("produces:" + Arrays.toString(this.getProduces())));
        this.getLog().info((CharSequence)("otherDepends:" + this.getOtherDepends()));
        this.getLog().info((CharSequence)("otherDependIncludes:" + this.getOtherDependsIncludes()));
        this.getLog().info((CharSequence)("otherDependExcludes:" + this.getOtherDependsExcludes()));
        this.getLog().info((CharSequence)("episodeFile:" + this.getEpisodeFile()));
        this.getLog().info((CharSequence)("episode:" + this.getEpisode()));
        this.getLog().info((CharSequence)("plugins:" + Arrays.toString(this.getPlugins())));
        this.getLog().info((CharSequence)("episodes:" + Arrays.toString(this.getEpisodes())));
        this.getLog().info((CharSequence)("useDependenciesAsEpisodes:" + this.getUseDependenciesAsEpisodes()));
        this.getLog().info((CharSequence)("scanDependenciesForBindings:" + this.getScanDependenciesForBindings()));
        this.getLog().info((CharSequence)("xjcPlugins:" + Arrays.toString(this.getPlugins())));
        this.getLog().info((CharSequence)("episodes:" + Arrays.toString(this.getEpisodes())));
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public ArtifactResolver getArtifactResolver() {
        return this.artifactResolver;
    }

    public void setArtifactResolver(ArtifactResolver artifactResolver) {
        this.artifactResolver = artifactResolver;
    }

    public ArtifactMetadataSource getArtifactMetadataSource() {
        return this.artifactMetadataSource;
    }

    public void setArtifactMetadataSource(ArtifactMetadataSource artifactMetadataSource) {
        this.artifactMetadataSource = artifactMetadataSource;
    }

    public ArtifactFactory getArtifactFactory() {
        return this.artifactFactory;
    }

    public void setArtifactFactory(ArtifactFactory artifactFactory) {
        this.artifactFactory = artifactFactory;
    }

    public ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    public void setLocalRepository(ArtifactRepository localRepository) {
        this.localRepository = localRepository;
    }

    public MavenProjectBuilder getMavenProjectBuilder() {
        return this.mavenProjectBuilder;
    }

    public void setMavenProjectBuilder(MavenProjectBuilder mavenProjectBuilder) {
        this.mavenProjectBuilder = mavenProjectBuilder;
    }

    public BuildContext getBuildContext() {
        return this.buildContext;
    }

    public void setBuildContext(BuildContext buildContext) {
        this.buildContext = buildContext;
    }

    protected void logApiConfiguration() {
        try {
            Class<?> xmlSchemaClass = Class.forName(XML_SCHEMA_CLASS_QNAME);
            URL resource = xmlSchemaClass.getResource(XML_SCHEMA_RESOURCE_NAME);
            String draftLocation = resource.toExternalForm();
            String location = draftLocation.endsWith(XML_SCHEMA_RESOURCE_QNAME) ? draftLocation.substring(0, draftLocation.length() - XML_SCHEMA_RESOURCE_QNAME.length()) : draftLocation;
            this.getLog().info((CharSequence)("JAXB API is loaded from the [" + location + "]."));
            try {
                xmlSchemaClass.getMethod("location", new Class[0]);
                Class<?> xmlElementRefClass = Class.forName(XML_ELEMENT_REF_CLASS_QNAME);
                try {
                    xmlElementRefClass.getMethod("required", new Class[0]);
                    this.getLog().info((CharSequence)"Detected JAXB API version [2.2].");
                }
                catch (NoSuchMethodException nsmex2) {
                    this.getLog().info((CharSequence)"Detected JAXB API version [2.1].");
                }
            }
            catch (NoSuchMethodException nsmex1) {
                this.getLog().info((CharSequence)"Detected JAXB API version [2.0].");
            }
        }
        catch (ClassNotFoundException cnfex) {
            this.getLog().error((CharSequence)"Could not find JAXB 2.x API classes. Make sure JAXB 2.x API is on the classpath.");
        }
    }

    public List<Artifact> getPluginArtifacts() {
        return this.pluginArtifacts;
    }

    public void setPluginArtifacts(List<Artifact> plugingArtifacts) {
        this.pluginArtifacts = plugingArtifacts;
    }

    public List<Dependency> getProjectDependencies() {
        Set artifacts = this.getProject().getArtifacts();
        if (artifacts == null) {
            return Collections.emptyList();
        }
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>(artifacts.size());
        for (Artifact artifact : artifacts) {
            Dependency dependency = new Dependency();
            dependency.setGroupId(artifact.getGroupId());
            dependency.setArtifactId(artifact.getArtifactId());
            dependency.setVersion(artifact.getVersion());
            dependency.setClassifier(artifact.getClassifier());
            dependency.setScope(artifact.getScope());
            dependency.setType(artifact.getType());
            dependencies.add(dependency);
        }
        return dependencies;
    }

    protected List<URI> createResourceEntryUris(ResourceEntry resourceEntry, String defaultDirectory, String[] defaultIncludes, String[] defaultExcludes) throws MojoExecutionException {
        if (resourceEntry == null) {
            return Collections.emptyList();
        }
        LinkedList<URI> uris = new LinkedList<URI>();
        if (resourceEntry.getFileset() != null) {
            FileSet fileset = resourceEntry.getFileset();
            uris.addAll(this.createFileSetUris(fileset, defaultDirectory, defaultIncludes, defaultExcludes));
        }
        if (resourceEntry.getUrl() != null) {
            String urlDraft = resourceEntry.getUrl();
            uris.add(this.createUri(urlDraft));
        }
        if (resourceEntry.getDependencyResource() != null) {
            String systemId = resourceEntry.getDependencyResource().getSystemId();
            try {
                URI uri = new URI(systemId);
                uris.add(uri);
            }
            catch (URISyntaxException e) {
                throw new MojoExecutionException(MessageFormat.format("Could not create the resource entry URI from the following system id: [{0}].", systemId), (Exception)e);
            }
        }
        return uris;
    }

    @Override
    public URL resolveDependencyResource(DependencyResource dependencyResource) throws MojoExecutionException {
        List dependencies;
        if (dependencyResource.getGroupId() == null) {
            throw new MojoExecutionException(MessageFormat.format("Dependency resource [{0}] does define the groupId.", new Object[]{dependencyResource}));
        }
        if (dependencyResource.getArtifactId() == null) {
            throw new MojoExecutionException(MessageFormat.format("Dependency resource [{0}] does not define the artifactId.", new Object[]{dependencyResource}));
        }
        if (dependencyResource.getType() == null) {
            throw new MojoExecutionException(MessageFormat.format("Dependency resource [{0}] does not define the type.", new Object[]{dependencyResource}));
        }
        if (this.getProject().getDependencyManagement() != null) {
            dependencies = this.getProject().getDependencyManagement().getDependencies();
            this.merge(dependencyResource, dependencies);
        }
        if ((dependencies = this.getProjectDependencies()) != null) {
            this.merge(dependencyResource, dependencies);
        }
        if (dependencyResource.getVersion() == null) {
            throw new MojoExecutionException(MessageFormat.format("Dependency resource [{0}] does not define the version.", new Object[]{dependencyResource}));
        }
        try {
            Set artifacts = MavenMetadataSource.createArtifacts((ArtifactFactory)this.getArtifactFactory(), Arrays.asList(new Dependency[]{dependencyResource}), (String)"runtime", null, (MavenProject)this.getProject());
            if (artifacts.size() != 1) {
                this.getLog().error((CharSequence)MessageFormat.format("Resolved dependency resource [{0}] to artifacts [{1}].", new Object[]{dependencyResource, artifacts}));
                throw new MojoExecutionException(MessageFormat.format("Could not create artifact for dependency [{0}].", new Object[]{dependencyResource}));
            }
            Artifact artifact = (Artifact)artifacts.iterator().next();
            this.getArtifactResolver().resolve(artifact, this.getProject().getRemoteArtifactRepositories(), this.getLocalRepository());
            String resource = dependencyResource.getResource();
            if (resource == null) {
                throw new MojoExecutionException(MessageFormat.format("Dependency resource [{0}] does not define the resource.", new Object[]{dependencyResource}));
            }
            URL resourceURL = this.createArtifactResourceUrl(artifact, resource);
            this.getLog().debug((CharSequence)MessageFormat.format("Resolved dependency resource [{0}] to resource URL [{1}].", new Object[]{dependencyResource, resourceURL}));
            return resourceURL;
        }
        catch (ArtifactNotFoundException anfex) {
            throw new MojoExecutionException(MessageFormat.format("Could not find artifact for dependency [{0}].", new Object[]{dependencyResource}));
        }
        catch (InvalidDependencyVersionException e) {
            throw new MojoExecutionException(MessageFormat.format("Invalid version of dependency [{0}].", new Object[]{dependencyResource}));
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException(MessageFormat.format("Could not resolver artifact for dependency [{0}].", new Object[]{dependencyResource}));
        }
    }

    private URL createArtifactResourceUrl(Artifact artifact, String resource) throws MojoExecutionException {
        File artifactFile = artifact.getFile();
        if (artifactFile.isDirectory()) {
            File resourceFile = new File(artifactFile, resource);
            try {
                return resourceFile.toURI().toURL();
            }
            catch (MalformedURLException murlex) {
                throw new MojoExecutionException(MessageFormat.format("Could not create an URL for dependency directory [{0}] and resource [{1}].", artifactFile, resource));
            }
        }
        try {
            return new URL("jar:" + artifactFile.toURI().toURL().toExternalForm() + "!/" + resource);
        }
        catch (MalformedURLException murlex) {
            throw new MojoExecutionException(MessageFormat.format("Could not create an URL for dependency file [{0}] and resource [{1}].", artifactFile, resource));
        }
    }

    private URI createUri(String uriString) throws MojoExecutionException {
        try {
            URI uri = new URI(uriString);
            return uri;
        }
        catch (URISyntaxException urisex) {
            throw new MojoExecutionException(MessageFormat.format("Could not create the URI from string [{0}].", uriString), (Exception)urisex);
        }
    }

    private List<URI> createFileSetUris(FileSet fileset, String defaultDirectory, String[] defaultIncludes, String[] defaultExcludes) throws MojoExecutionException {
        String draftDirectory = fileset.getDirectory();
        String directory = draftDirectory == null ? defaultDirectory : draftDirectory;
        List<Object> draftIncludes = fileset.getIncludes();
        List<Object> includes = draftIncludes == null || draftIncludes.isEmpty() ? (defaultIncludes == null ? Collections.emptyList() : Arrays.asList(defaultIncludes)) : draftIncludes;
        List<Object> draftExcludes = fileset.getExcludes();
        List<Object> excludes = draftExcludes == null || draftExcludes.isEmpty() ? (defaultExcludes == null ? Collections.emptyList() : Arrays.asList(defaultExcludes)) : draftExcludes;
        String[] includesArray = includes.toArray(new String[includes.size()]);
        String[] excludesArray = excludes.toArray(new String[excludes.size()]);
        try {
            List<File> files = IOUtils.scanDirectoryForFiles(this.getBuildContext(), new File(directory), includesArray, excludesArray, !this.getDisableDefaultExcludes());
            ArrayList<URI> uris = new ArrayList<URI>(files.size());
            for (File file : files) {
                URI uri = file.toURI();
                uris.add(uri);
            }
            return uris;
        }
        catch (IOException ioex) {
            throw new MojoExecutionException(MessageFormat.format("Could not scan directory [{0}] for files with inclusion [{1}]  and exclusion [{2}].", directory, includes, excludes));
        }
    }

    private void merge(Dependency dependency, List<Dependency> managedDependencies) {
        for (Dependency managedDependency : managedDependencies) {
            if (!dependency.getManagementKey().equals(managedDependency.getManagementKey())) continue;
            ArtifactUtils.mergeDependencyWithDefaults(dependency, managedDependency);
        }
    }

    protected abstract IOptionsFactory<O> getOptionsFactory();

    protected void cleanPackageDirectory(File packageDirectory) {
        File[] files = packageDirectory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile();
            }
        });
        if (files != null) {
            for (File file : files) {
                file.delete();
            }
        }
    }
}

