/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.maven.resolver.tools;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Optional;
import org.apache.maven.plugin.logging.Log;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ReResolvingInputSourceWrapper
extends InputSource {
    private final EntityResolver entityResolver;
    private final boolean disableSystemIdResolution;
    private final Log log;
    private final InputSource inputSource;

    public ReResolvingInputSourceWrapper(EntityResolver entityResolver, boolean disableSystemIdResolution, Log log, InputSource inputSource, String publicId, String systemId) {
        this.entityResolver = entityResolver;
        this.disableSystemIdResolution = disableSystemIdResolution;
        this.log = log;
        this.inputSource = inputSource;
        this.setPublicId(publicId);
        this.setSystemId(systemId);
    }

    @Override
    public String getSystemId() {
        String callerClassName;
        String systemId = super.getSystemId();
        if (!this.disableSystemIdResolution && (callerClassName = ReResolvingInputSourceWrapper.getCallerClassName()).endsWith("domforest")) {
            this.log.debug((CharSequence)"ReResolvingInputSourceWrapper : Handling DOMForest xjc 2.3.4+ change");
            try {
                URI uri = new URI(systemId);
                if ("file".equals(uri.getScheme()) && !Files.exists(Paths.get(uri), new LinkOption[0])) {
                    this.log.debug((CharSequence)("ReResolvingInputSourceWrapper : Initial systemId " + systemId + " is file, and does not exist, returning inputSource.getSystemId() as systemId (" + this.inputSource.getSystemId() + ")"));
                    systemId = this.inputSource.getSystemId();
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return systemId;
    }

    private static String getCallerClassName() {
        StackTraceElement[] trace = new Exception().getStackTrace();
        return Optional.ofNullable(trace[2].getClassName()).map(c -> c.toLowerCase()).orElse("");
    }

    @Override
    public Reader getCharacterStream() {
        Reader originalReader = this.inputSource.getCharacterStream();
        if (originalReader == null) {
            return null;
        }
        Reader resolvedEntityReader = this.getResolvedEntity();
        if (resolvedEntityReader != null) {
            return resolvedEntityReader;
        }
        return originalReader;
    }

    private Reader getResolvedEntity() {
        try {
            InputSource resolvedEntity = this.entityResolver.resolveEntity(this.getPublicId(), super.getSystemId());
            if (resolvedEntity == null) {
                return null;
            }
            return resolvedEntity.getCharacterStream();
        }
        catch (IOException ioex) {
            return null;
        }
        catch (SAXException saxex) {
            return null;
        }
    }

    @Override
    public void setCharacterStream(Reader characterStream) {
    }

    @Override
    public InputStream getByteStream() {
        InputStream originalInputStream = this.inputSource.getByteStream();
        if (originalInputStream == null) {
            return null;
        }
        try {
            InputSource resolvedEntity = this.entityResolver.resolveEntity(this.getPublicId(), super.getSystemId());
            if (resolvedEntity != null) {
                return resolvedEntity.getByteStream();
            }
            return originalInputStream;
        }
        catch (IOException ioex) {
            return originalInputStream;
        }
        catch (SAXException saxex) {
            return originalInputStream;
        }
    }

    @Override
    public void setByteStream(InputStream byteStream) {
    }
}

