/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.maven.util;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.project.artifact.MavenMetadataSource;
import org.jvnet.jaxb.maven.util.CollectionUtils;

public class ArtifactUtils {
    public static final CollectionUtils.Function<Artifact, File> GET_FILE = new CollectionUtils.Function<Artifact, File>(){

        @Override
        public File eval(Artifact argument) {
            return argument.getFile();
        }
    };

    private ArtifactUtils() {
    }

    public static Collection<Artifact> resolveTransitively(ArtifactFactory artifactFactory, ArtifactResolver artifactResolver, ArtifactRepository localRepository, ArtifactMetadataSource artifactMetadataSource, Dependency[] dependencies, MavenProject project) throws InvalidDependencyVersionException, ArtifactResolutionException, ArtifactNotFoundException {
        if (dependencies == null) {
            return Collections.emptyList();
        }
        Set artifacts = MavenMetadataSource.createArtifacts((ArtifactFactory)artifactFactory, Arrays.asList(dependencies), (String)"runtime", null, (MavenProject)project);
        ArtifactResolutionResult artifactResolutionResult = artifactResolver.resolveTransitively(artifacts, project.getArtifact(), project.getRemoteArtifactRepositories(), localRepository, artifactMetadataSource);
        Set resolvedArtifacts = artifactResolutionResult.getArtifacts();
        return resolvedArtifacts;
    }

    public static Collection<Artifact> resolve(ArtifactFactory artifactFactory, ArtifactResolver artifactResolver, ArtifactRepository localRepository, ArtifactMetadataSource artifactMetadataSource, Dependency[] dependencies, MavenProject project) throws InvalidDependencyVersionException, ArtifactResolutionException, ArtifactNotFoundException {
        if (dependencies == null) {
            return Collections.emptyList();
        }
        Set artifacts = MavenMetadataSource.createArtifacts((ArtifactFactory)artifactFactory, Arrays.asList(dependencies), (String)"runtime", null, (MavenProject)project);
        for (Artifact artifact : artifacts) {
            artifactResolver.resolve(artifact, project.getRemoteArtifactRepositories(), localRepository);
        }
        Set resolvedArtifacts = artifacts;
        return resolvedArtifacts;
    }

    public static final Collection<File> getFiles(Collection<Artifact> artifacts) {
        return CollectionUtils.apply(artifacts, GET_FILE);
    }

    public static void mergeDependencyWithDefaults(Dependency dep, Dependency def) {
        List exclusions;
        if (dep.getScope() == null && def.getScope() != null) {
            dep.setScope(def.getScope());
            dep.setSystemPath(def.getSystemPath());
        }
        if (dep.getVersion() == null && def.getVersion() != null) {
            dep.setVersion(def.getVersion());
        }
        if (dep.getClassifier() == null && def.getClassifier() != null) {
            dep.setClassifier(def.getClassifier());
        }
        if (dep.getType() == null && def.getType() != null) {
            dep.setType(def.getType());
        }
        if ((exclusions = dep.getExclusions()) == null || exclusions.isEmpty()) {
            dep.setExclusions(def.getExclusions());
        }
    }
}

