/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.maven.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.MatchPatterns;
import org.codehaus.plexus.util.Scanner;
import org.jvnet.jaxb.maven.util.CollectionUtils;
import org.jvnet.jaxb.maven.util.StringUtils;
import org.sonatype.plexus.build.incremental.BuildContext;
import org.xml.sax.InputSource;

public class IOUtils {
    public static final CollectionUtils.Function<File, URL> GET_URL = new CollectionUtils.Function<File, URL>(){

        @Override
        public URL eval(File file) {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException muex) {
                throw new RuntimeException(muex);
            }
        }
    };

    public static InputSource getInputSource(File file) {
        try {
            URL url = file.toURI().toURL();
            return IOUtils.getInputSource(url);
        }
        catch (MalformedURLException e) {
            return new InputSource(file.getPath());
        }
    }

    public static InputSource getInputSource(URL url) {
        return new InputSource(StringUtils.escapeSpace(url.toExternalForm()));
    }

    public static InputSource getInputSource(URI uri) {
        return new InputSource(StringUtils.escapeSpace(uri.toString()));
    }

    public static List<File> scanDirectoryForFiles(BuildContext buildContext, File directory, String[] includes, String[] excludes, boolean defaultExcludes) throws IOException {
        Scanner scanner;
        if (!directory.exists()) {
            return Collections.emptyList();
        }
        if (buildContext != null) {
            scanner = buildContext.newScanner(directory, true);
        } else {
            DirectoryScanner directoryScanner = new DirectoryScanner();
            directoryScanner.setBasedir(directory.getAbsoluteFile());
            scanner = directoryScanner;
        }
        scanner.setIncludes(includes);
        scanner.setExcludes(excludes);
        if (defaultExcludes) {
            scanner.addDefaultExcludes();
        }
        scanner.scan();
        List<String> orderedIncludedFiles = IOUtils.reorderFiles(scanner.getIncludedFiles(), includes);
        ArrayList<File> files = new ArrayList<File>();
        for (String name : orderedIncludedFiles) {
            files.add(new File(directory, name).getCanonicalFile());
        }
        return files;
    }

    private static boolean isWildcard(String s) {
        return s.indexOf(42) >= 0 || s.indexOf(63) >= 0;
    }

    protected static List<String> reorderFiles(String[] resolvedFiles, String[] includes) {
        if (includes == null || includes.length == 0) {
            return Arrays.asList(resolvedFiles);
        }
        ArrayList<String> resolvedFilesList = new ArrayList<String>(Arrays.asList(resolvedFiles));
        ArrayList<String> ret = new ArrayList<String>(resolvedFilesList.size());
        for (String include : includes) {
            MatchPatterns inc = MatchPatterns.from((String[])new String[]{IOUtils.normalizePattern(include)});
            ArrayList<String> matches = new ArrayList<String>();
            for (String resFile : resolvedFilesList) {
                if (!inc.matches(resFile, false)) continue;
                matches.add(resFile);
            }
            ret.addAll(matches);
            resolvedFilesList.removeAll(matches);
        }
        ret.addAll(resolvedFilesList);
        return ret;
    }

    private static String normalizePattern(String pattern) {
        if ((pattern = pattern.trim()).startsWith("%regex[")) {
            pattern = File.separatorChar == '\\' ? org.codehaus.plexus.util.StringUtils.replace((String)pattern, (String)"/", (String)"\\\\") : org.codehaus.plexus.util.StringUtils.replace((String)pattern, (String)"\\\\", (String)"/");
        } else if ((pattern = pattern.replace(File.separatorChar == '/' ? (char)'\\' : '/', File.separatorChar)).endsWith(File.separator)) {
            pattern = pattern + "**";
        }
        return pattern;
    }
}

