/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.maven.resolver.tools;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import org.apache.maven.plugin.logging.Log;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.jvnet.jaxb.maven.plugin.logging.NullLog;
import org.jvnet.jaxb.maven.resolver.tools.LoggingCatalogResolver;

public class ClasspathCatalogResolver
extends CatalogResolver
implements LoggingCatalogResolver {
    public static final String URI_SCHEME_CLASSPATH = "classpath";
    private Log log = NullLog.INSTANCE;

    public String getResolvedEntity(String publicId, String systemId) {
        this.log.debug((CharSequence)("ClasspathCatalogResolver : Resolving [" + publicId + "], [" + systemId + "]."));
        String result = super.getResolvedEntity(publicId, systemId);
        this.log.debug((CharSequence)("ClasspathCatalogResolver : Resolved to [" + result + "]."));
        if (result == null) {
            this.log.info((CharSequence)MessageFormat.format("ClasspathCatalogResolver : Could not resolve publicId [{0}], systemId [{1}]", publicId, systemId));
            return null;
        }
        try {
            URI uri = new URI(result);
            if (URI_SCHEME_CLASSPATH.equals(uri.getScheme())) {
                String schemeSpecificPart = uri.getSchemeSpecificPart();
                this.log.debug((CharSequence)("ClasspathCatalogResolver : Resolve [" + schemeSpecificPart + "]."));
                URL resource = Thread.currentThread().getContextClassLoader().getResource(schemeSpecificPart);
                if (resource == null) {
                    this.log.debug((CharSequence)("ClasspathCatalogResolver : Returning [" + null + "]."));
                    return null;
                }
                this.log.debug((CharSequence)("ClasspathCatalogResolver : Returning to [" + resource.toString() + "]."));
                return resource.toString();
            }
            this.log.debug((CharSequence)("ClasspathCatalogResolver : Returning to [" + result + "]."));
            return result;
        }
        catch (URISyntaxException urisex) {
            this.log.debug((CharSequence)("ClasspathCatalogResolver : Returning to [" + result + "]."));
            return result;
        }
    }

    @Override
    public void setLog(Log log) {
        this.log = log;
    }
}

