/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.maven;

import com.sun.xml.txw2.annotation.XmlNamespace;
import jakarta.xml.bind.annotation.XmlSchema;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.artifact.resolver.filter.TypeArtifactFilter;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.jvnet.jaxb.maven.AbstractXJCMojo;
import org.jvnet.jaxb.maven.OptionsConfiguration;
import org.jvnet.jaxb.maven.ParentFirstClassLoader;
import org.jvnet.jaxb.maven.ResourceEntry;
import org.jvnet.jaxb.maven.net.CompositeURILastModifiedResolver;
import org.jvnet.jaxb.maven.net.URILastModifiedResolver;
import org.jvnet.jaxb.maven.resolver.tools.LoggingCatalogResolver;
import org.jvnet.jaxb.maven.resolver.tools.MavenCatalogResolver;
import org.jvnet.jaxb.maven.resolver.tools.ReResolvingEntityResolverWrapper;
import org.jvnet.jaxb.maven.resolver.tools.RelativeCatalog;
import org.jvnet.jaxb.maven.util.ArtifactUtils;
import org.jvnet.jaxb.maven.util.CollectionUtils;
import org.jvnet.jaxb.maven.util.IOUtils;
import org.jvnet.jaxb.maven.util.LocaleUtils;
import org.sonatype.plexus.build.incremental.BuildContext;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class RawXJCMojo<O>
extends AbstractXJCMojo<O> {
    private static final String JAXB_NSURI = "https://jakarta.ee/xml/ns/jaxb";
    public static final String ADD_IF_EXISTS_TO_EPISODE_SCHEMA_BINDINGS_TRANSFORMATION_RESOURCE_NAME = "/" + RawXJCMojo.class.getPackage().getName().replace('.', '/') + "/addIfExistsToEpisodeSchemaBindings.xslt";
    private Collection<Artifact> xjcPluginArtifacts;
    private Collection<File> xjcPluginFiles;
    private List<URL> xjcPluginURLs;
    private Collection<Artifact> episodeArtifacts;
    private Collection<File> episodeFiles;
    private List<File> schemaFiles;
    private List<URI> schemaURIs;
    private List<URI> resolvedSchemaURIs;
    private List<InputSource> grammars;
    private List<File> bindingFiles;
    private List<URI> bindingURIs;
    private List<URI> resolvedBindingURIs;
    private List<InputSource> bindFiles;
    private List<URI> dependsURIs;
    private List<URI> producesURIs;
    private static final Object lock = new Object();
    private URILastModifiedResolver uriLastModifiedResolver;
    private CatalogResolver catalogResolverInstance;
    private List<URI> catalogURIs;
    private List<URI> resolvedCatalogURIs;
    private EntityResolver entityResolver;

    public Collection<Artifact> getXjcPluginArtifacts() {
        return this.xjcPluginArtifacts;
    }

    public Collection<File> getXjcPluginFiles() {
        return this.xjcPluginFiles;
    }

    public List<URL> getXjcPluginURLs() {
        return this.xjcPluginURLs;
    }

    public Collection<Artifact> getEpisodeArtifacts() {
        return this.episodeArtifacts;
    }

    public Collection<File> getEpisodeFiles() {
        return this.episodeFiles;
    }

    public List<File> getSchemaFiles() {
        return this.schemaFiles;
    }

    protected List<URI> getSchemaURIs() {
        if (this.schemaURIs == null) {
            throw new IllegalStateException("Schema URIs were not set up yet.");
        }
        return this.schemaURIs;
    }

    protected List<URI> getResolvedSchemaURIs() {
        if (this.resolvedSchemaURIs == null) {
            throw new IllegalStateException("Resolved schema URIs were not set up yet.");
        }
        return this.resolvedSchemaURIs;
    }

    protected List<InputSource> getGrammars() {
        if (this.grammars == null) {
            throw new IllegalArgumentException("Grammars were not set up yet.");
        }
        return this.grammars;
    }

    private void setupSchemas() throws MojoExecutionException {
        this.schemaURIs = this.createSchemaURIs();
        this.resolvedSchemaURIs = this.resolveURIs(this.getSchemaURIs());
        this.grammars = this.createGrammars();
    }

    private List<URI> createSchemaURIs() throws MojoExecutionException {
        List<File> schemaFiles = this.getSchemaFiles();
        ArrayList<URI> schemaURIs = new ArrayList<URI>(schemaFiles.size());
        for (File schemaFile : schemaFiles) {
            URI schema = schemaFile.toURI();
            schemaURIs.add(schema);
        }
        ResourceEntry[] schemas = this.getSchemas();
        if (schemas != null) {
            for (ResourceEntry resourceEntry : schemas) {
                schemaURIs.addAll(this.createResourceEntryUris(resourceEntry, this.getSchemaDirectory().getAbsolutePath(), this.getSchemaIncludes(), this.getSchemaExcludes()));
            }
        }
        return schemaURIs;
    }

    private List<InputSource> createGrammars() throws MojoExecutionException {
        try {
            List<URI> schemaURIs = this.getSchemaURIs();
            return this.getInputSources(schemaURIs);
        }
        catch (IOException ioex) {
            throw new MojoExecutionException("Could not resolve grammars.", (Exception)ioex);
        }
        catch (SAXException ioex) {
            throw new MojoExecutionException("Could not resolve grammars.", (Exception)ioex);
        }
    }

    public List<File> getBindingFiles() {
        return this.bindingFiles;
    }

    protected List<URI> getBindingURIs() {
        if (this.bindingURIs == null) {
            throw new IllegalStateException("Binding URIs were not set up yet.");
        }
        return this.bindingURIs;
    }

    protected List<URI> getResolvedBindingURIs() {
        if (this.resolvedBindingURIs == null) {
            throw new IllegalStateException("Resolved binding URIs were not set up yet.");
        }
        return this.resolvedBindingURIs;
    }

    protected List<InputSource> getBindFiles() {
        if (this.bindFiles == null) {
            throw new IllegalStateException("BindFiles were not set up yet.");
        }
        return this.bindFiles;
    }

    private void setupBindings() throws MojoExecutionException {
        this.bindingURIs = this.createBindingURIs();
        this.resolvedBindingURIs = this.resolveURIs(this.getBindingURIs());
        this.bindFiles = this.createBindFiles();
    }

    protected List<URI> createBindingURIs() throws MojoExecutionException {
        LinkedList<File> bindingFiles = new LinkedList<File>();
        bindingFiles.addAll(this.getBindingFiles());
        for (File episodeFile : this.getEpisodeFiles()) {
            File episodeBindingsFile;
            File episodeMetaInfFile;
            this.getLog().debug((CharSequence)MessageFormat.format("Checking episode file [{0}].", episodeFile.getAbsolutePath()));
            if (!episodeFile.isDirectory() || !(episodeMetaInfFile = new File(episodeFile, "META-INF")).isDirectory() || !(episodeBindingsFile = new File(episodeMetaInfFile, "sun-jaxb.episode")).isFile()) continue;
            bindingFiles.add(episodeBindingsFile);
        }
        ArrayList<URI> bindingUris = new ArrayList<URI>(bindingFiles.size());
        for (File bindingFile : bindingFiles) {
            URI uri = bindingFile.toURI();
            bindingUris.add(uri);
        }
        if (this.getBindings() != null) {
            for (ResourceEntry resourceEntry : this.getBindings()) {
                bindingUris.addAll(this.createResourceEntryUris(resourceEntry, this.getBindingDirectory().getAbsolutePath(), this.getBindingIncludes(), this.getBindingExcludes()));
            }
        }
        if (this.getScanDependenciesForBindings()) {
            this.collectBindingUrisFromDependencies(bindingUris);
        }
        return bindingUris;
    }

    private List<InputSource> createBindFiles() throws MojoExecutionException {
        try {
            List<URI> bindingURIs = this.getBindingURIs();
            return this.getInputSources(bindingURIs);
        }
        catch (IOException ioex) {
            throw new MojoExecutionException("Could not resolve binding files.", (Exception)ioex);
        }
        catch (SAXException ioex) {
            throw new MojoExecutionException("Could not resolve binding files.", (Exception)ioex);
        }
    }

    public List<URI> getDependsURIs() {
        return this.dependsURIs;
    }

    public List<URI> getProducesURIs() {
        return this.producesURIs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        Object object = lock;
        synchronized (object) {
            this.injectDependencyDefaults();
            this.resolveArtifacts();
            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
            Locale currentDefaultLocale = Locale.getDefault();
            try (URLClassLoader classLoader = this.createClassLoader(currentClassLoader);){
                Thread.currentThread().setContextClassLoader(classLoader);
                Locale locale = LocaleUtils.valueOf(this.getLocale());
                Locale.setDefault(locale);
                this.doExecute();
            }
            catch (IOException e) {
                throw new MojoExecutionException("IOException while executing with URLClassloader", (Exception)e);
            }
            finally {
                Locale.setDefault(currentDefaultLocale);
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
        }
    }

    protected void injectDependencyDefaults() {
        this.injectDependencyDefaults(this.getPlugins());
        this.injectDependencyDefaults(this.getEpisodes());
    }

    protected void injectDependencyDefaults(Dependency[] dependencies) {
        if (dependencies != null) {
            TreeMap<String, Dependency> dependencyMap = new TreeMap<String, Dependency>();
            for (Dependency dependency : dependencies) {
                if (dependency.getScope() == null) {
                    dependency.setScope("runtime");
                }
                dependencyMap.put(dependency.getManagementKey(), dependency);
            }
            DependencyManagement dependencyManagement = this.getProject().getDependencyManagement();
            if (dependencyManagement != null) {
                this.merge(dependencyMap, dependencyManagement.getDependencies());
            }
            this.merge(dependencyMap, this.getProjectDependencies());
        }
    }

    private void merge(Map<String, Dependency> dependencyMap, List<Dependency> managedDependencies) {
        for (Dependency managedDependency : managedDependencies) {
            String key = managedDependency.getManagementKey();
            Dependency dependency = dependencyMap.get(key);
            if (dependency == null) continue;
            ArtifactUtils.mergeDependencyWithDefaults(dependency, managedDependency);
        }
    }

    protected void resolveArtifacts() throws MojoExecutionException {
        try {
            this.resolveXJCPluginArtifacts();
            this.resolveEpisodeArtifacts();
        }
        catch (ArtifactResolutionException arex) {
            throw new MojoExecutionException("Could not resolve the artifact.", (Exception)((Object)arex));
        }
        catch (ArtifactNotFoundException anfex) {
            throw new MojoExecutionException("Artifact not found.", (Exception)((Object)anfex));
        }
        catch (InvalidDependencyVersionException idvex) {
            throw new MojoExecutionException("Invalid dependency version.", (Exception)((Object)idvex));
        }
    }

    protected void resolveXJCPluginArtifacts() throws ArtifactResolutionException, ArtifactNotFoundException, InvalidDependencyVersionException {
        this.xjcPluginArtifacts = ArtifactUtils.resolveTransitively(this.getArtifactFactory(), this.getArtifactResolver(), this.getLocalRepository(), this.getArtifactMetadataSource(), this.getPlugins(), this.getProject());
        this.xjcPluginFiles = ArtifactUtils.getFiles(this.xjcPluginArtifacts);
        this.xjcPluginURLs = CollectionUtils.apply(this.xjcPluginFiles, IOUtils.GET_URL);
    }

    protected void resolveEpisodeArtifacts() throws ArtifactResolutionException, ArtifactNotFoundException, InvalidDependencyVersionException {
        this.episodeArtifacts = new LinkedHashSet<Artifact>();
        Collection<Artifact> episodeArtifacts = ArtifactUtils.resolve(this.getArtifactFactory(), this.getArtifactResolver(), this.getLocalRepository(), this.getArtifactMetadataSource(), this.getEpisodes(), this.getProject());
        this.episodeArtifacts.addAll(episodeArtifacts);
        if (this.getUseDependenciesAsEpisodes()) {
            Set projectArtifacts = this.getProject().getArtifacts();
            AndArtifactFilter filter = new AndArtifactFilter();
            filter.add((ArtifactFilter)new ScopeArtifactFilter("compile"));
            filter.add((ArtifactFilter)new TypeArtifactFilter("jar"));
            for (Artifact artifact : projectArtifacts) {
                if (!filter.include(artifact)) continue;
                this.episodeArtifacts.add(artifact);
            }
        }
        this.episodeFiles = ArtifactUtils.getFiles(this.episodeArtifacts);
    }

    protected URLClassLoader createClassLoader(ClassLoader parent) {
        List<URL> xjcPluginURLs = this.getXjcPluginURLs();
        return new ParentFirstClassLoader(xjcPluginURLs.toArray(new URL[xjcPluginURLs.size()]), parent);
    }

    protected void doExecute() throws MojoExecutionException {
        this.setupLogging();
        if (this.getVerbose()) {
            this.getLog().info((CharSequence)"Started execution.");
        }
        this.setupBindInfoPackage();
        this.setupEpisodePackage();
        this.setupMavenPaths();
        this.setupCatalogResolver();
        this.setupEntityResolver();
        this.setupSchemaFiles();
        this.setupBindingFiles();
        this.setupSchemas();
        this.setupBindings();
        this.setupDependsURIs();
        this.setupProducesURIs();
        this.setupURILastModifiedResolver();
        if (this.getVerbose()) {
            this.logConfiguration();
        }
        OptionsConfiguration optionsConfiguration = this.createOptionsConfiguration();
        if (this.getVerbose()) {
            this.getLog().info((CharSequence)("optionsConfiguration:" + optionsConfiguration));
        }
        this.checkCatalogsInStrictMode();
        if (this.getGrammars().isEmpty()) {
            this.getLog().warn((CharSequence)"No schemas to compile. Skipping XJC execution. ");
        } else {
            Object options = this.getOptionsFactory().createOptions(optionsConfiguration);
            if (this.getForceRegenerate()) {
                this.getLog().warn((CharSequence)"You are using forceRegenerate=true in your configuration.\nThis configuration setting is deprecated and not recommended as it causes problems with incremental builds in IDEs.\nPlease refer to the following link for more information:\nhttps://github.com/highsource/jaxb-tools/wiki/Do-Not-Use-forceRegenerate\nConsider removing this setting from your plugin configuration.\n");
                this.getLog().info((CharSequence)"The [forceRegenerate] switch is turned on, XJC will be executed.");
            } else {
                boolean isUpToDate = this.isUpToDate();
                if (!isUpToDate) {
                    this.getLog().info((CharSequence)"Sources are not up-to-date, XJC will be executed.");
                } else {
                    this.getLog().info((CharSequence)"Sources are up-to-date, XJC will be skipped.");
                    return;
                }
            }
            this.setupDirectories();
            this.doExecute(options);
            this.addIfExistsToEpisodeSchemaBindings();
            BuildContext buildContext = this.getBuildContext();
            this.getLog().debug((CharSequence)MessageFormat.format("Refreshing the generated directory [{0}].", this.getGenerateDirectory().getAbsolutePath()));
            buildContext.refresh(this.getGenerateDirectory());
        }
        if (this.getVerbose()) {
            this.getLog().info((CharSequence)"Finished execution.");
        }
    }

    private void setupBindInfoPackage() {
        String packageInfoClassName = "com.sun.tools.xjc.reader.xmlschema.bindinfo.package-info";
        try {
            Class<?> packageInfoClass = Class.forName(packageInfoClassName);
            XmlSchema xmlSchema = packageInfoClass.getAnnotation(XmlSchema.class);
            if (xmlSchema == null) {
                this.getLog().warn((CharSequence)MessageFormat.format("Class [{0}] is missing the [{1}] annotation. Processing bindings will probably fail.", packageInfoClassName, XmlSchema.class.getName()));
            } else {
                String namespace = xmlSchema.namespace();
                if (!JAXB_NSURI.equals(namespace)) {
                    this.getLog().warn((CharSequence)MessageFormat.format("Namespace of the [{0}] annotation is [{1}] and does not match [{2}]. Processing bindings will probably fail.", namespace, XmlSchema.class.getName(), JAXB_NSURI));
                }
            }
        }
        catch (ClassNotFoundException cnfex) {
            this.getLog().warn((CharSequence)MessageFormat.format("Class [{0}] could not be found. Processing bindings will probably fail.", packageInfoClassName), (Throwable)cnfex);
        }
    }

    private void setupEpisodePackage() {
        String packageInfoClassName = "org.glassfish.jaxb.core.v2.schemagen.episode.package-info";
        try {
            Class<?> packageInfoClass = Class.forName(packageInfoClassName);
            XmlNamespace xmlNamespace = packageInfoClass.getAnnotation(XmlNamespace.class);
            if (xmlNamespace == null) {
                this.getLog().warn((CharSequence)MessageFormat.format("Class [{0}] is missing the [{1}] annotation. Processing bindings will probably fail.", packageInfoClassName, XmlNamespace.class.getName()));
            } else {
                String namespace = xmlNamespace.value();
                if (!JAXB_NSURI.equals(namespace)) {
                    this.getLog().warn((CharSequence)MessageFormat.format("Namespace of the [{0}] annotation is [{1}] and does not match [{2}]. Processing bindings will probably fail.", XmlNamespace.class.getName(), namespace, JAXB_NSURI));
                }
            }
        }
        catch (ClassNotFoundException cnfex) {
            this.getLog().warn((CharSequence)MessageFormat.format("Class [{0}] could not be found. Processing bindings will probably fail.", packageInfoClassName), (Throwable)cnfex);
        }
    }

    private void addIfExistsToEpisodeSchemaBindings() throws MojoExecutionException {
        if (!this.getEpisode() || !this.isAddIfExistsToEpisodeSchemaBindings()) {
            return;
        }
        File episodeFile = this.getEpisodeFile();
        if (!episodeFile.canWrite()) {
            this.getLog().warn((CharSequence)MessageFormat.format("Episode file [{0}] is not writable, could not add if-exists attributes.", episodeFile));
            return;
        }
        InputStream is = null;
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            is = this.getClass().getResourceAsStream(ADD_IF_EXISTS_TO_EPISODE_SCHEMA_BINDINGS_TRANSFORMATION_RESOURCE_NAME);
            Transformer addIfExistsToEpisodeSchemaBindingsTransformer = transformerFactory.newTransformer(new StreamSource(is));
            DOMResult result = new DOMResult();
            addIfExistsToEpisodeSchemaBindingsTransformer.transform(new StreamSource(episodeFile), result);
            DOMSource source = new DOMSource(result.getNode());
            Transformer identityTransformer = transformerFactory.newTransformer();
            identityTransformer.setOutputProperty("indent", "yes");
            identityTransformer.transform(source, new StreamResult(episodeFile));
            this.getLog().info((CharSequence)MessageFormat.format("Episode file [{0}] was augmented with if-exists=\"true\" attributes.", episodeFile));
        }
        catch (TransformerException e) {
            try {
                throw new MojoExecutionException(MessageFormat.format("Error augmenting the episode file [{0}] with if-exists=\"true\" attributes. Transformation failed with an unexpected error.", episodeFile), (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(is);
                throw throwable;
            }
        }
        IOUtil.close((InputStream)is);
    }

    private void setupURILastModifiedResolver() {
        this.uriLastModifiedResolver = new CompositeURILastModifiedResolver(this.getLog());
    }

    protected URILastModifiedResolver getURILastModifiedResolver() {
        if (this.uriLastModifiedResolver == null) {
            throw new IllegalStateException("URILastModifiedResolver was not set up yet.");
        }
        return this.uriLastModifiedResolver;
    }

    private void checkCatalogsInStrictMode() {
        if (this.getStrict() && !this.getCatalogURIs().isEmpty()) {
            this.getLog().warn((CharSequence)"The plugin is configured to use catalogs and strict mode at the same time.\nUsing catalogs to resolve schema URIs in strict mode is known to be problematic and may fail.\nPlease refer to the following link for more information:\nhttps://github.com/highsource/jaxb-tools/wiki/Catalogs-in-Strict-Mode\nConsider setting <strict>false</strict> in your plugin configuration.\n");
        }
    }

    public abstract void doExecute(O var1) throws MojoExecutionException;

    protected void setupLogging() {
        this.setVerbose(this.getVerbose() || this.getLog().isDebugEnabled());
        if (this.getVerbose()) {
            System.setProperty("com.sun.tools.xjc.Options.findServices", "true");
        }
    }

    protected void setupMavenPaths() {
        String generatedDirectoryPath;
        String episodeFilePath;
        if (this.getAddCompileSourceRoot()) {
            this.getProject().addCompileSourceRoot(this.getGenerateDirectory().getPath());
        }
        if (this.getAddTestCompileSourceRoot()) {
            this.getProject().addTestCompileSourceRoot(this.getGenerateDirectory().getPath());
        }
        if (this.getEpisode() && this.getEpisodeFile() != null && (episodeFilePath = this.getEpisodeFile().getAbsolutePath()).startsWith((generatedDirectoryPath = this.getGenerateDirectory().getAbsolutePath()) + File.separator)) {
            String path = episodeFilePath.substring(generatedDirectoryPath.length() + 1);
            Resource resource = new Resource();
            resource.setDirectory(generatedDirectoryPath);
            resource.addInclude(path);
            if (this.getAddCompileSourceRoot()) {
                this.getProject().addResource(resource);
            }
            if (this.getAddTestCompileSourceRoot()) {
                this.getProject().addTestResource(resource);
            }
        }
    }

    protected void setupDirectories() {
        File generateDirectory = this.getGenerateDirectory();
        if (this.getRemoveOldOutput() && generateDirectory.exists()) {
            try {
                FileUtils.deleteDirectory((File)this.getGenerateDirectory());
            }
            catch (IOException ex) {
                this.getLog().warn((CharSequence)("Failed to remove old generateDirectory [" + generateDirectory + "]."), (Throwable)ex);
            }
        }
        if (generateDirectory != null && !generateDirectory.exists()) {
            generateDirectory.mkdirs();
        }
        File episodeFile = this.getEpisodeFile();
        if (this.getEpisode() && episodeFile != null) {
            File parentFile = episodeFile.getParentFile();
            parentFile.mkdirs();
        }
    }

    protected void setupSchemaFiles() throws MojoExecutionException {
        try {
            File schemaDirectory = this.getSchemaDirectory();
            if (schemaDirectory == null || !schemaDirectory.exists()) {
                this.schemaFiles = Collections.emptyList();
            } else if (schemaDirectory.isDirectory()) {
                this.schemaFiles = IOUtils.scanDirectoryForFiles(this.getBuildContext(), schemaDirectory, this.getSchemaIncludes(), this.getSchemaExcludes(), !this.getDisableDefaultExcludes());
            } else {
                this.schemaFiles = Collections.emptyList();
                this.getLog().warn((CharSequence)MessageFormat.format("Schema directory [{0}] is not a directory.", schemaDirectory.getPath()));
            }
        }
        catch (IOException ioex) {
            throw new MojoExecutionException("Could not set up schema files.", (Exception)ioex);
        }
    }

    protected void setupBindingFiles() throws MojoExecutionException {
        try {
            File bindingDirectory = this.getBindingDirectory();
            if (bindingDirectory == null || !bindingDirectory.exists()) {
                this.bindingFiles = Collections.emptyList();
            } else if (bindingDirectory.isDirectory()) {
                this.bindingFiles = IOUtils.scanDirectoryForFiles(this.getBuildContext(), bindingDirectory, this.getBindingIncludes(), this.getBindingExcludes(), !this.getDisableDefaultExcludes());
            } else {
                this.bindingFiles = Collections.emptyList();
                this.getLog().warn((CharSequence)MessageFormat.format("Binding directory [{0}] is not a directory.", bindingDirectory.getPath()));
            }
        }
        catch (IOException ioex) {
            throw new MojoExecutionException("Could not set up binding files.", (Exception)ioex);
        }
    }

    protected void setupDependsURIs() throws MojoExecutionException {
        LinkedList<URI> dependsURIs = new LinkedList<URI>();
        dependsURIs.addAll(this.getResolvedCatalogURIs());
        dependsURIs.addAll(this.getResolvedSchemaURIs());
        dependsURIs.addAll(this.getResolvedBindingURIs());
        File projectFile = this.getProject().getFile();
        if (projectFile != null) {
            dependsURIs.add(projectFile.toURI());
        }
        if (this.getOtherDependsIncludes() != null) {
            try {
                List<File> otherDependsFiles = IOUtils.scanDirectoryForFiles(this.getBuildContext(), this.getProject().getBasedir(), this.getOtherDependsIncludes(), this.getOtherDependsExcludes(), !this.getDisableDefaultExcludes());
                for (File file : otherDependsFiles) {
                    if (file == null) continue;
                    dependsURIs.add(file.toURI());
                }
            }
            catch (IOException ioex) {
                throw new MojoExecutionException("Could not set up [otherDepends] files.", (Exception)ioex);
            }
        }
        this.dependsURIs = dependsURIs;
    }

    private void setupProducesURIs() throws MojoExecutionException {
        this.producesURIs = this.createProducesURIs();
    }

    protected List<URI> createProducesURIs() throws MojoExecutionException {
        LinkedList<URI> producesURIs = new LinkedList<URI>();
        try {
            List<File> producesFiles = IOUtils.scanDirectoryForFiles(this.getBuildContext(), this.getGenerateDirectory(), this.getProduces(), new String[]{}, !this.getDisableDefaultExcludes());
            if (producesFiles != null) {
                for (File producesFile : producesFiles) {
                    if (producesFile == null) continue;
                    producesURIs.add(producesFile.toURI());
                }
            }
            return producesURIs;
        }
        catch (IOException ioex) {
            throw new MojoExecutionException("Could not set up produced files.", (Exception)ioex);
        }
    }

    @Override
    protected void logConfiguration() throws MojoExecutionException {
        super.logConfiguration();
        this.getLog().info((CharSequence)("catalogURIs (calculated):" + this.getCatalogURIs()));
        this.getLog().info((CharSequence)("resolvedCatalogURIs (calculated):" + this.getResolvedCatalogURIs()));
        this.getLog().info((CharSequence)("schemaFiles (calculated):" + this.getSchemaFiles()));
        this.getLog().info((CharSequence)("schemaURIs (calculated):" + this.getSchemaURIs()));
        this.getLog().info((CharSequence)("resolvedSchemaURIs (calculated):" + this.getResolvedSchemaURIs()));
        this.getLog().info((CharSequence)("bindingFiles (calculated):" + this.getBindingFiles()));
        this.getLog().info((CharSequence)("bindingURIs (calculated):" + this.getBindingURIs()));
        this.getLog().info((CharSequence)("resolvedBindingURIs (calculated):" + this.getResolvedBindingURIs()));
        this.getLog().info((CharSequence)("xjcPluginArtifacts (resolved):" + this.getXjcPluginArtifacts()));
        this.getLog().info((CharSequence)("xjcPluginFiles (resolved):" + this.getXjcPluginFiles()));
        this.getLog().info((CharSequence)("xjcPluginURLs (resolved):" + this.getXjcPluginURLs()));
        this.getLog().info((CharSequence)("episodeArtifacts (resolved):" + this.getEpisodeArtifacts()));
        this.getLog().info((CharSequence)("episodeFiles (resolved):" + this.getEpisodeFiles()));
        this.getLog().info((CharSequence)("dependsURIs (resolved):" + this.getDependsURIs()));
    }

    void collectBindingUrisFromDependencies(List<URI> bindingUris) throws MojoExecutionException {
        Set projectArtifacts = this.getProject().getArtifacts();
        ArrayList<Artifact> compileScopeArtifacts = new ArrayList<Artifact>(projectArtifacts.size());
        ScopeArtifactFilter scopeFilter = new ScopeArtifactFilter("compile");
        TypeArtifactFilter typeFilter = new TypeArtifactFilter("pom");
        for (Artifact artifact : projectArtifacts) {
            if (!scopeFilter.include(artifact) || typeFilter.include(artifact)) continue;
            compileScopeArtifacts.add(artifact);
        }
        for (Artifact artifact : compileScopeArtifacts) {
            this.getLog().debug((CharSequence)MessageFormat.format("Scanning artifact [{0}] for JAXB binding files.", artifact));
            this.collectBindingUrisFromArtifact(artifact.getFile(), bindingUris);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void collectBindingUrisFromArtifact(File file, List<URI> bindingUris) throws MojoExecutionException {
        if (file.isDirectory()) {
            try {
                List<File> files = IOUtils.scanDirectoryForFiles(null, file, new String[]{"**/*.xjb"}, null, false);
                for (File bindingFile : files) {
                    bindingUris.add(bindingFile.toURI());
                }
                return;
            }
            catch (IOException ioex) {
                throw new MojoExecutionException("Unable to read the artifact directory [" + file.getAbsolutePath() + "].", (Exception)ioex);
            }
        }
        try (JarFile jarFile = new JarFile(file);){
            Enumeration<JarEntry> jarFileEntries = jarFile.entries();
            while (jarFileEntries.hasMoreElements()) {
                JarEntry entry = jarFileEntries.nextElement();
                if (!entry.getName().endsWith(".xjb")) continue;
                try {
                    bindingUris.add(new URI("jar:" + file.toURI() + "!/" + entry.getName()));
                }
                catch (URISyntaxException urisex) {
                    throw new MojoExecutionException(MessageFormat.format("Could not create the URI of the binding file from [{0}]", entry.getName()), (Exception)urisex);
                    return;
                }
            }
        }
        catch (IOException ioex) {
            throw new MojoExecutionException("Unable to read the artifact JAR file [" + file.getAbsolutePath() + "].", (Exception)ioex);
        }
    }

    protected List<URI> getCatalogURIs() {
        if (this.catalogURIs == null) {
            throw new IllegalStateException("Catalog URIs were not set up yet.");
        }
        return this.catalogURIs;
    }

    protected List<URI> getResolvedCatalogURIs() {
        if (this.resolvedCatalogURIs == null) {
            throw new IllegalStateException("Resolved catalog URIs were not set up yet.");
        }
        return this.resolvedCatalogURIs;
    }

    protected CatalogResolver getCatalogResolverInstance() {
        if (this.catalogResolverInstance == null) {
            throw new IllegalStateException("Catalog resolver was not set up yet.");
        }
        return this.catalogResolverInstance;
    }

    private void setupCatalogResolver() throws MojoExecutionException {
        this.catalogResolverInstance = this.createCatalogResolver();
        this.catalogURIs = this.createCatalogURIs();
        this.resolvedCatalogURIs = this.resolveURIs(this.getCatalogURIs());
        this.parseResolvedCatalogURIs();
    }

    protected EntityResolver getEntityResolver() {
        if (this.entityResolver == null) {
            throw new IllegalStateException("Entity resolver was not set up yet.");
        }
        return this.entityResolver;
    }

    private void setupEntityResolver() {
        this.entityResolver = this.createEntityResolver(this.getCatalogResolverInstance());
    }

    protected EntityResolver createEntityResolver(CatalogResolver catalogResolver) {
        ReResolvingEntityResolverWrapper entityResolver = new ReResolvingEntityResolverWrapper((EntityResolver)catalogResolver, this.getLog(), this.getDisableSystemIdResolution());
        return entityResolver;
    }

    protected CatalogResolver createCatalogResolver() throws MojoExecutionException {
        CatalogManager catalogManager = new CatalogManager();
        catalogManager.setIgnoreMissingProperties(true);
        catalogManager.setUseStaticCatalog(false);
        if (this.getRelativeCatalogResolution()) {
            this.getLog().info((CharSequence)"Using RelativeCatalogResolution as CatalogManager (enable resolution of '../' path for REWRITE_SYSTEM in catalog files)");
            catalogManager.setCatalogClassName(RelativeCatalog.class.getName());
        }
        if (this.getLog().isDebugEnabled()) {
            catalogManager.setVerbosity(Integer.MAX_VALUE);
        }
        if (this.getCatalogResolver() == null) {
            return new MavenCatalogResolver(catalogManager, this, this.getLog());
        }
        String catalogResolverClassName = this.getCatalogResolver().trim();
        return this.createCatalogResolverByClassName(catalogResolverClassName);
    }

    private CatalogResolver createCatalogResolverByClassName(String catalogResolverClassName) throws MojoExecutionException {
        try {
            Class<?> draftCatalogResolverClass = Thread.currentThread().getContextClassLoader().loadClass(catalogResolverClassName);
            if (!CatalogResolver.class.isAssignableFrom(draftCatalogResolverClass)) {
                throw new MojoExecutionException(MessageFormat.format("Specified catalog resolver class [{0}] could not be casted to [{1}].", this.catalogResolver, CatalogResolver.class));
            }
            Class<?> catalogResolverClass = draftCatalogResolverClass;
            CatalogResolver catalogResolverInstance = (CatalogResolver)catalogResolverClass.newInstance();
            if (catalogResolverInstance instanceof LoggingCatalogResolver) {
                ((LoggingCatalogResolver)catalogResolverInstance).setLog(this.getLog());
            }
            return catalogResolverInstance;
        }
        catch (ClassNotFoundException cnfex) {
            throw new MojoExecutionException(MessageFormat.format("Could not find specified catalog resolver class [{0}].", this.catalogResolver), (Exception)cnfex);
        }
        catch (InstantiationException iex) {
            throw new MojoExecutionException(MessageFormat.format("Could not instantiate catalog resolver class [{0}].", this.catalogResolver), (Exception)iex);
        }
        catch (IllegalAccessException iaex) {
            throw new MojoExecutionException(MessageFormat.format("Could not instantiate catalog resolver class [{0}].", this.catalogResolver), (Exception)iaex);
        }
    }

    protected boolean isUpToDate() {
        List<URI> dependsURIs = this.getDependsURIs();
        List<URI> producesURIs = this.getProducesURIs();
        this.getLog().debug((CharSequence)MessageFormat.format("Up-to-date check for source resources [{0}] and target resources [{1}].", dependsURIs, producesURIs));
        boolean itIsKnownThatNoDependsURIsWereChanged = true;
        for (URI dependsURI : dependsURIs) {
            if ("file".equalsIgnoreCase(dependsURI.getScheme())) {
                File dependsFile = new File(dependsURI);
                if (!this.getBuildContext().hasDelta(dependsFile)) continue;
                if (this.getVerbose()) {
                    this.getLog().debug((CharSequence)MessageFormat.format("File [{0}] might have been changed since the last build.", dependsFile.getAbsolutePath()));
                }
                itIsKnownThatNoDependsURIsWereChanged = false;
                continue;
            }
            itIsKnownThatNoDependsURIsWereChanged = false;
        }
        if (itIsKnownThatNoDependsURIsWereChanged) {
            this.getLog().info((CharSequence)"According to the build context, all of the [dependURIs] are up-to-date.");
            return true;
        }
        CollectionUtils.Function<URI, Long> LAST_MODIFIED = new CollectionUtils.Function<URI, Long>(){

            @Override
            public Long eval(URI uri) {
                return RawXJCMojo.this.getURILastModifiedResolver().getLastModified(uri);
            }
        };
        this.getLog().debug((CharSequence)MessageFormat.format("Checking the last modification timestamp of the source resources [{0}].", dependsURIs));
        Long dependsTimestamp = CollectionUtils.bestValue(dependsURIs, LAST_MODIFIED, CollectionUtils.gtWithNullAsGreatest());
        this.getLog().debug((CharSequence)MessageFormat.format("Checking the last modification timestamp of the target resources [{0}].", producesURIs));
        Long producesTimestamp = CollectionUtils.bestValue(producesURIs, LAST_MODIFIED, CollectionUtils.ltWithNullAsSmallest());
        if (dependsTimestamp == null) {
            this.getLog().debug((CharSequence)"Latest timestamp of the source resources is unknown. Assuming that something was changed.");
            return false;
        }
        if (producesTimestamp == null) {
            this.getLog().debug((CharSequence)MessageFormat.format("Latest Timestamp of the source resources is [{0,date,yyyy-MM-dd HH:mm:ss.SSS}], however the earliest timestamp of the target resources is unknown. Assuming that something was changed.", dependsTimestamp));
            return false;
        }
        this.getLog().info((CharSequence)MessageFormat.format("Latest timestamp of the source resources is [{0,date,yyyy-MM-dd HH:mm:ss.SSS}], earliest timestamp of the target resources is [{1,date,yyyy-MM-dd HH:mm:ss.SSS}].", dependsTimestamp, producesTimestamp));
        boolean upToDate = dependsTimestamp < producesTimestamp;
        return upToDate;
    }

    protected String getCustomHttpproxy() {
        String proxyHost = this.getProxyHost();
        int proxyPort = this.getProxyPort();
        String proxyUsername = this.getProxyUsername();
        String proxyPassword = this.getProxyPassword();
        return proxyHost != null ? this.createXJCProxyArgument(proxyHost, proxyPort, proxyUsername, proxyPassword) : null;
    }

    protected String getActiveProxyAsHttpproxy() {
        if (this.getSettings() == null) {
            return null;
        }
        Settings settings = this.getSettings();
        Proxy activeProxy = settings.getActiveProxy();
        if (activeProxy == null || activeProxy.getHost() == null) {
            return null;
        }
        return this.createXJCProxyArgument(activeProxy.getHost(), activeProxy.getPort(), activeProxy.getUsername(), activeProxy.getPassword());
    }

    private String createXJCProxyArgument(String host, int port, String username, String password) {
        if (host == null) {
            if (port != -1) {
                this.getLog().warn((CharSequence)MessageFormat.format("Proxy port is configured to [{0,number,#}] but proxy host is missing. Proxy port will be ignored.", port));
            }
            if (username != null) {
                this.getLog().warn((CharSequence)MessageFormat.format("Proxy username is configured to [{0}] but proxy host is missing. Proxy username will be ignored.", username));
            }
            if (password != null) {
                this.getLog().warn((CharSequence)MessageFormat.format("Proxy password is set but proxy host is missing. Proxy password will be ignored.", password));
            }
            return null;
        }
        StringBuilder proxyStringBuilder = new StringBuilder();
        if (username != null) {
            proxyStringBuilder.append(username);
            if (password != null) {
                proxyStringBuilder.append(":").append(password);
            }
            proxyStringBuilder.append("@");
        } else if (password != null) {
            this.getLog().warn((CharSequence)MessageFormat.format("Proxy password is set but proxy username is missing. Proxy password will be ignored.", password));
        }
        proxyStringBuilder.append(host);
        if (port != -1) {
            proxyStringBuilder.append(":").append(port);
        }
        return proxyStringBuilder.toString();
    }

    protected List<String> getArguments() {
        ArrayList<String> arguments = new ArrayList<String>(this.getArgs());
        String httpproxy = this.getHttpproxy();
        if (httpproxy != null) {
            arguments.add("-httpproxy");
            arguments.add(httpproxy);
        }
        if (this.getEpisode() && this.getEpisodeFile() != null) {
            arguments.add("-episode");
            arguments.add(this.getEpisodeFile().getAbsolutePath());
        }
        if (this.getMarkGenerated()) {
            arguments.add("-mark-generated");
        }
        for (File episodeFile : this.getEpisodeFiles()) {
            if (!episodeFile.isFile()) continue;
            arguments.add(episodeFile.getAbsolutePath());
        }
        return arguments;
    }

    protected String getHttpproxy() {
        String httpproxy;
        String activeHttpproxy = this.getActiveProxyAsHttpproxy();
        String customHttpproxy = this.getCustomHttpproxy();
        if (this.isUseActiveProxyAsHttpproxy()) {
            if (customHttpproxy != null) {
                this.getLog().warn((CharSequence)MessageFormat.format("Both [useActiveProxyAsHttpproxy=true] as well as custom proxy [{0}] are configured. Please remove either [useActiveProxyAsHttpproxy=true] or custom proxy configuration.", customHttpproxy));
                this.getLog().debug((CharSequence)MessageFormat.format("Using custom proxy [{0}].", customHttpproxy));
                httpproxy = customHttpproxy;
            } else if (activeHttpproxy != null) {
                this.getLog().debug((CharSequence)MessageFormat.format("Using active proxy [{0}] from Maven settings.", activeHttpproxy));
                httpproxy = activeHttpproxy;
            } else {
                this.getLog().warn((CharSequence)MessageFormat.format("Configured [useActiveProxyAsHttpproxy=true] but no active proxy is configured in Maven settings. Please configure an active proxy in Maven settings or remove [useActiveProxyAsHttpproxy=true].", customHttpproxy));
                httpproxy = activeHttpproxy;
            }
        } else if (customHttpproxy != null) {
            this.getLog().debug((CharSequence)MessageFormat.format("Using custom proxy [{0}].", customHttpproxy));
            httpproxy = customHttpproxy;
        } else {
            httpproxy = null;
        }
        return httpproxy;
    }

    public OptionsConfiguration createOptionsConfiguration() throws MojoExecutionException {
        OptionsConfiguration optionsConfiguration = new OptionsConfiguration(this.getEncoding(), this.getSchemaLanguage(), this.getGrammars(), this.getBindFiles(), this.getEntityResolver(), this.getGeneratePackage(), this.getGenerateDirectory(), this.getReadOnly(), this.getPackageLevelAnnotations(), this.getNoFileHeader(), this.getEnableIntrospection(), this.getDisableXmlSecurity(), this.getAccessExternalSchema(), this.getAccessExternalDTD(), this.isEnableExternalEntityProcessing(), this.getContentForWildcard(), this.getExtension(), this.getStrict(), this.getVerbose(), this.getDebug(), this.getArguments(), this.getXjcPluginURLs(), this.getSpecVersion());
        return optionsConfiguration;
    }

    private List<URI> resolveURIs(List<URI> uris) {
        ArrayList<URI> resolvedURIs = new ArrayList<URI>(uris.size());
        for (URI uri : uris) {
            String URI2 = this.getCatalogResolverInstance().getResolvedEntity(null, uri.toString());
            if (URI2 != null) {
                try {
                    uri = new URI(URI2);
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            resolvedURIs.add(uri);
        }
        return resolvedURIs;
    }

    private void parseResolvedCatalogURIs() throws MojoExecutionException {
        for (URI catalogURI : this.getResolvedCatalogURIs()) {
            if (catalogURI == null) continue;
            try {
                this.getCatalogResolverInstance().getCatalog().parseCatalog(catalogURI.toURL());
            }
            catch (IOException ioex) {
                throw new MojoExecutionException(MessageFormat.format("Error parsing catalog [{0}].", catalogURI.toString()), (Exception)ioex);
            }
        }
    }

    private List<InputSource> getInputSources(List<URI> uris) throws IOException, SAXException {
        ArrayList<InputSource> inputSources = new ArrayList<InputSource>(uris.size());
        for (URI uri : uris) {
            InputSource inputSource = IOUtils.getInputSource(uri);
            InputSource resolvedInputSource = this.getEntityResolver().resolveEntity(inputSource.getPublicId(), inputSource.getSystemId());
            if (resolvedInputSource != null) {
                inputSource = resolvedInputSource;
            }
            inputSources.add(inputSource);
        }
        return inputSources;
    }
}

