
package org.jvnet.ws.wadl.ast;

import com.sun.localization.Localizable;
import com.sun.localization.LocalizableMessageFactory;
import com.sun.localization.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class AstMessages {

    private final static LocalizableMessageFactory messageFactory = new LocalizableMessageFactory("org.jvnet.ws.wadl.ast.ast");
    private final static Localizer localizer = new Localizer();

    public static Localizable localizableMISSING_ID_RESOURCE_TYPE() {
        return messageFactory.getMessage("missing.id.resourceType");
    }

    /**
     * Missing id property on resourceType element
     * 
     */
    public static String MISSING_ID_RESOURCE_TYPE() {
        return localizer.localize(localizableMISSING_ID_RESOURCE_TYPE());
    }

    public static Localizable localizableLONELY_HREF_METHOD() {
        return messageFactory.getMessage("lonely.href.method");
    }

    /**
     * A method with a href should not have any other WADL parameters or children
     * 
     */
    public static String LONELY_HREF_METHOD() {
        return localizer.localize(localizableLONELY_HREF_METHOD());
    }

    public static Localizable localizableLONELY_HREF_PARAM() {
        return messageFactory.getMessage("lonely.href.param");
    }

    /**
     * A param with a href should not have any other WADL parameters or children
     * 
     */
    public static String LONELY_HREF_PARAM() {
        return localizer.localize(localizableLONELY_HREF_PARAM());
    }

    public static Localizable localizablePROCESSING(Object arg0) {
        return messageFactory.getMessage("processing", arg0);
    }

    /**
     * Processing: {0}
     * 
     */
    public static String PROCESSING(Object arg0) {
        return localizer.localize(localizablePROCESSING(arg0));
    }

    public static Localizable localizableSKIPPING_REFERENCE_TYPE(Object arg0) {
        return messageFactory.getMessage("skipping.reference.type", arg0);
    }

    /**
     * Reference {0} identifies the wrong kind of element
     * 
     */
    public static String SKIPPING_REFERENCE_TYPE(Object arg0) {
        return localizer.localize(localizableSKIPPING_REFERENCE_TYPE(arg0));
    }

    public static Localizable localizableTEMPLATE_VALUE_MISSING(Object arg0) {
        return messageFactory.getMessage("template.value.missing", arg0);
    }

    /**
     * No value for required template parameter: {0}
     * 
     */
    public static String TEMPLATE_VALUE_MISSING(Object arg0) {
        return localizer.localize(localizableTEMPLATE_VALUE_MISSING(arg0));
    }

    public static Localizable localizableLONELY_HREF_REPRESENTATION() {
        return messageFactory.getMessage("lonely.href.representation");
    }

    /**
     * A representation with a href should not have any other WADL parameters or children
     * 
     */
    public static String LONELY_HREF_REPRESENTATION() {
        return localizer.localize(localizableLONELY_HREF_REPRESENTATION());
    }

    public static Localizable localizableLONELY_HREF_RESOURCE_TYPE() {
        return messageFactory.getMessage("lonely.href.resourceType");
    }

    /**
     * A resourceType with a href should not have any other WADL parameters or children
     * 
     */
    public static String LONELY_HREF_RESOURCE_TYPE() {
        return localizer.localize(localizableLONELY_HREF_RESOURCE_TYPE());
    }

    public static Localizable localizableMISSING_ID_METHOD() {
        return messageFactory.getMessage("missing.id.method");
    }

    /**
     * Missing id property on method element
     * 
     */
    public static String MISSING_ID_METHOD() {
        return localizer.localize(localizableMISSING_ID_METHOD());
    }

    public static Localizable localizableMATRIX_VALUE_MISSING(Object arg0) {
        return messageFactory.getMessage("matrix.value.missing", arg0);
    }

    /**
     * No value for required matrix parameter: {0}
     * 
     */
    public static String MATRIX_VALUE_MISSING(Object arg0) {
        return localizer.localize(localizableMATRIX_VALUE_MISSING(arg0));
    }

    public static Localizable localizableMISSING_ID_PARAM() {
        return messageFactory.getMessage("missing.id.param");
    }

    /**
     * Missing id property on param element
     * 
     */
    public static String MISSING_ID_PARAM() {
        return localizer.localize(localizableMISSING_ID_PARAM());
    }

    public static Localizable localizableMISSING_METHOD_NAME() {
        return messageFactory.getMessage("missing.method.name");
    }

    /**
     * Missing method name property on method element
     * 
     */
    public static String MISSING_METHOD_NAME() {
        return localizer.localize(localizableMISSING_METHOD_NAME());
    }

    public static Localizable localizableSKIPPING_REFERENCE(Object arg0) {
        return messageFactory.getMessage("skipping.reference", arg0);
    }

    /**
     * Reference {0} not found
     * 
     */
    public static String SKIPPING_REFERENCE(Object arg0) {
        return localizer.localize(localizableSKIPPING_REFERENCE(arg0));
    }

    public static Localizable localizableMISSING_ID_REPRESENTATION() {
        return messageFactory.getMessage("missing.id.representation");
    }

    /**
     * Missing id property on representation element
     * 
     */
    public static String MISSING_ID_REPRESENTATION() {
        return localizer.localize(localizableMISSING_ID_REPRESENTATION());
    }

}
