/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.global.lime;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.kie.kogito.explainability.global.GlobalExplainer;
import org.kie.kogito.explainability.local.lime.LimeExplainer;
import org.kie.kogito.explainability.model.Prediction;
import org.kie.kogito.explainability.model.PredictionInput;
import org.kie.kogito.explainability.model.PredictionProvider;
import org.kie.kogito.explainability.model.PredictionProviderMetadata;
import org.kie.kogito.explainability.model.Saliency;
import org.kie.kogito.explainability.utils.DataUtils;

public class AggregatedLimeExplainer
implements GlobalExplainer<CompletableFuture<Map<String, Saliency>>> {
    private final LimeExplainer limeExplainer;

    public AggregatedLimeExplainer() {
        this.limeExplainer = new LimeExplainer();
    }

    public AggregatedLimeExplainer(LimeExplainer limeExplainer) {
        this.limeExplainer = limeExplainer;
    }

    @Override
    public CompletableFuture<Map<String, Saliency>> explainFromMetadata(PredictionProvider model, PredictionProviderMetadata metadata) {
        List<PredictionInput> inputs = metadata.getDataDistribution().sample(this.limeExplainer.getLimeConfig().getNoOfSamples());
        return ((CompletableFuture)model.predictAsync(inputs).thenApply(os -> DataUtils.getPredictions(inputs, os))).thenCompose(ps -> this.explainFromPredictions(model, (Collection)ps));
    }

    @Override
    public CompletableFuture<Map<String, Saliency>> explainFromPredictions(PredictionProvider model, Collection<Prediction> predictions) {
        return CompletableFuture.completedFuture(predictions).thenApply(p -> p.stream().map(prediction -> this.limeExplainer.explainAsync((Prediction)prediction, model)).map(CompletableFuture::join).reduce(Collections.emptyMap(), (m1, m2) -> Saliency.merge(List.of(m1, m2))));
    }
}

