/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.counterfactual.entities;

import java.nio.ByteBuffer;
import java.util.Set;
import org.kie.kogito.explainability.local.counterfactual.entities.AbstractCategoricalEntity;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureFactory;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.api.domain.variable.PlanningVariable;

@PlanningEntity
public class BinaryEntity
extends AbstractCategoricalEntity<ByteBuffer> {
    public BinaryEntity() {
    }

    private BinaryEntity(ByteBuffer originalValue, String featureName, Set<ByteBuffer> allowedCategories, boolean constrained) {
        super(originalValue, featureName, allowedCategories, constrained);
    }

    public static BinaryEntity from(Feature originalFeature, Set<ByteBuffer> categories, boolean constrained) {
        return new BinaryEntity((ByteBuffer)originalFeature.getValue().getUnderlyingObject(), originalFeature.getName(), categories, constrained);
    }

    public static BinaryEntity from(Feature originalFeature, Set<ByteBuffer> categories) {
        return BinaryEntity.from(originalFeature, categories, false);
    }

    @Override
    @ValueRangeProvider(id="categoricalRange")
    public Set<ByteBuffer> getValueRange() {
        return this.allowedCategories;
    }

    @Override
    public Feature asFeature() {
        return FeatureFactory.newBinaryFeature(this.featureName, (ByteBuffer)this.proposedValue);
    }

    @Override
    @PlanningVariable(valueRangeProviderRefs={"categoricalRange"})
    public ByteBuffer getProposedValue() {
        return (ByteBuffer)this.proposedValue;
    }

    @Override
    public void setProposedValue(ByteBuffer proposedValue) {
        this.proposedValue = proposedValue;
    }
}

