/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.counterfactual.entities;

import java.net.URI;
import java.util.Set;
import org.kie.kogito.explainability.local.counterfactual.entities.AbstractCategoricalEntity;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureFactory;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.api.domain.variable.PlanningVariable;

@PlanningEntity
public class URIEntity
extends AbstractCategoricalEntity<URI> {
    public URIEntity() {
    }

    private URIEntity(URI originalValue, String featureName, Set<URI> allowedCategories, boolean constrained) {
        super(originalValue, featureName, allowedCategories, constrained);
    }

    public static URIEntity from(Feature originalFeature, Set<URI> categories, boolean constrained) {
        return new URIEntity((URI)originalFeature.getValue().getUnderlyingObject(), originalFeature.getName(), categories, constrained);
    }

    public static URIEntity from(Feature originalFeature, Set<URI> categories) {
        return URIEntity.from(originalFeature, categories, false);
    }

    @Override
    @ValueRangeProvider(id="categoricalRange")
    public Set<URI> getValueRange() {
        return this.allowedCategories;
    }

    @Override
    public Feature asFeature() {
        return FeatureFactory.newURIFeature(this.featureName, (URI)this.proposedValue);
    }

    @Override
    @PlanningVariable(valueRangeProviderRefs={"categoricalRange"})
    public URI getProposedValue() {
        return (URI)this.proposedValue;
    }

    @Override
    public void setProposedValue(URI proposedValue) {
        this.proposedValue = proposedValue;
    }
}

