/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.lime.optim;

import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.kie.kogito.explainability.local.lime.LimeConfig;
import org.kie.kogito.explainability.local.lime.LimeExplainer;
import org.kie.kogito.explainability.local.lime.optim.LimeConfigOptimizationStrategy;
import org.kie.kogito.explainability.local.lime.optim.LimeOptimizationRequest;
import org.kie.kogito.explainability.local.lime.optim.LimeOptimizationService;
import org.kie.kogito.explainability.model.Prediction;
import org.kie.kogito.explainability.model.PredictionProvider;

public class CountingOptimizationStrategy
implements LimeConfigOptimizationStrategy {
    private final int epochLength;
    private final AtomicLong explanationCount = new AtomicLong();
    private final LimeOptimizationService optimizationService;

    public CountingOptimizationStrategy(int epochLength, LimeOptimizationService optimizationService) {
        this.epochLength = epochLength;
        this.optimizationService = optimizationService;
    }

    @Override
    public void maybeOptimize(List<Prediction> recordedPredictions, PredictionProvider model, LimeExplainer limeExplainer, LimeConfig executionConfig) {
        if (this.explanationCount.incrementAndGet() > (long)this.epochLength) {
            this.explanationCount.set(0L);
            this.optimizationService.submit(new LimeOptimizationRequest(executionConfig, model, recordedPredictions, limeExplainer));
        }
    }

    @Override
    public LimeConfig bestConfigFor(LimeExplainer explainer) {
        return this.optimizationService.getBestConfigFor(explainer);
    }
}

