/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.lime.optim;

import org.kie.kogito.explainability.local.lime.optim.LimeConfigSolution;
import org.kie.kogito.explainability.local.lime.optim.LimeImpactScoreCalculator;
import org.kie.kogito.explainability.local.lime.optim.LimeStabilityScoreCalculator;
import org.optaplanner.core.api.score.buildin.simplebigdecimal.SimpleBigDecimalScore;
import org.optaplanner.core.api.score.calculator.EasyScoreCalculator;

public class LimeCombinedScoreCalculator
implements EasyScoreCalculator<LimeConfigSolution, SimpleBigDecimalScore> {
    private final EasyScoreCalculator<LimeConfigSolution, SimpleBigDecimalScore> stability = new LimeStabilityScoreCalculator();
    private final EasyScoreCalculator<LimeConfigSolution, SimpleBigDecimalScore> impact = new LimeImpactScoreCalculator();
    private final double impactWeight;
    private final double stabilityWeight;

    public LimeCombinedScoreCalculator() {
        this(0.5, 0.5);
    }

    public LimeCombinedScoreCalculator(double stabilityWeight, double impactWeight) {
        this.stabilityWeight = stabilityWeight;
        this.impactWeight = impactWeight;
    }

    public SimpleBigDecimalScore calculateScore(LimeConfigSolution limeConfigSolution) {
        return ((SimpleBigDecimalScore)this.stability.calculateScore((Object)limeConfigSolution)).multiply(this.stabilityWeight).add(((SimpleBigDecimalScore)this.impact.calculateScore((Object)limeConfigSolution)).multiply(this.impactWeight));
    }
}

