/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.lime.optim;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.kie.kogito.explainability.Config;
import org.kie.kogito.explainability.local.lime.LimeConfig;
import org.kie.kogito.explainability.local.lime.LimeExplainer;
import org.kie.kogito.explainability.local.lime.optim.LimeConfigEntityFactory;
import org.kie.kogito.explainability.local.lime.optim.LimeConfigSolution;
import org.kie.kogito.explainability.model.FeatureImportance;
import org.kie.kogito.explainability.model.Prediction;
import org.kie.kogito.explainability.model.Saliency;
import org.kie.kogito.explainability.utils.ExplainabilityMetrics;
import org.optaplanner.core.api.score.buildin.simplebigdecimal.SimpleBigDecimalScore;
import org.optaplanner.core.api.score.calculator.EasyScoreCalculator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LimeImpactScoreCalculator
implements EasyScoreCalculator<LimeConfigSolution, SimpleBigDecimalScore> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LimeImpactScoreCalculator.class);
    private static final int TOP_FEATURES = 2;

    public SimpleBigDecimalScore calculateScore(LimeConfigSolution solution) {
        LimeConfig config = LimeConfigEntityFactory.toLimeConfig(solution);
        BigDecimal impactScore = BigDecimal.ZERO;
        List<Prediction> predictions = solution.getPredictions();
        if (!predictions.isEmpty()) {
            impactScore = this.getImpactScore(solution, config, predictions);
        }
        return SimpleBigDecimalScore.of((BigDecimal)impactScore);
    }

    private BigDecimal getImpactScore(LimeConfigSolution solution, LimeConfig config, List<Prediction> predictions) {
        double succeededEvaluations = 0.0;
        BigDecimal impactScore = BigDecimal.ZERO;
        LimeExplainer limeExplainer = new LimeExplainer(config);
        for (Prediction prediction : predictions) {
            try {
                Map saliencyMap = (Map)limeExplainer.explainAsync(prediction, solution.getModel()).get(5L, Config.DEFAULT_ASYNC_TIMEUNIT);
                for (Map.Entry entry : saliencyMap.entrySet()) {
                    List<FeatureImportance> topFeatures = ((Saliency)entry.getValue()).getTopFeatures(2);
                    if (topFeatures.isEmpty()) continue;
                    double v = ExplainabilityMetrics.impactScore(solution.getModel(), prediction, topFeatures);
                    impactScore = impactScore.add(BigDecimal.valueOf(v));
                    succeededEvaluations += 1.0;
                }
            }
            catch (ExecutionException e) {
                LOGGER.error("Saliency impact-score calculation returned an error {}", (Object)e.getMessage());
            }
            catch (InterruptedException e) {
                LOGGER.error("Interrupted while waiting for saliency impact-score calculation {}", (Object)e.getMessage());
                Thread.currentThread().interrupt();
            }
            catch (TimeoutException e) {
                LOGGER.error("Timed out while waiting for saliency impact-score calculation", (Throwable)e);
            }
        }
        if (succeededEvaluations > 0.0) {
            impactScore = impactScore.divide(BigDecimal.valueOf(succeededEvaluations), RoundingMode.CEILING);
        }
        return impactScore;
    }
}

