/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.lime.optim;

import org.kie.kogito.explainability.local.lime.optim.LimeConfigEntity;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.valuerange.ValueRange;
import org.optaplanner.core.api.domain.valuerange.ValueRangeFactory;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.api.domain.variable.PlanningVariable;

@PlanningEntity
public class NumericLimeConfigEntity
extends LimeConfigEntity {
    private double rangeMinimum;
    private double rangeMaximum;

    public NumericLimeConfigEntity() {
    }

    @Override
    double asDouble() {
        return (Double)this.proposedValue;
    }

    @Override
    boolean asBoolean() {
        throw new UnsupportedOperationException();
    }

    public NumericLimeConfigEntity(String name, double proposedValue, double rangeMinimum, double rangeMaximum) {
        super(name, proposedValue);
        this.rangeMinimum = rangeMinimum;
        this.rangeMaximum = rangeMaximum;
    }

    @ValueRangeProvider(id="doubleRange")
    public ValueRange<Double> getValueRange() {
        return ValueRangeFactory.createDoubleValueRange((double)this.rangeMinimum, (double)this.rangeMaximum);
    }

    @PlanningVariable(valueRangeProviderRefs={"doubleRange"})
    public Double getProposedValue() {
        return (double)((Double)this.proposedValue);
    }

    public void setProposedValue(Double proposedValue) {
        this.proposedValue = proposedValue;
    }
}

