/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.lime.optim;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.kie.kogito.explainability.local.lime.LimeConfig;
import org.kie.kogito.explainability.local.lime.LimeExplainer;
import org.kie.kogito.explainability.local.lime.optim.CountingOptimizationStrategy;
import org.kie.kogito.explainability.local.lime.optim.DefaultLimeOptimizationService;
import org.kie.kogito.explainability.local.lime.optim.LimeConfigOptimizationStrategy;
import org.kie.kogito.explainability.local.lime.optim.LimeConfigOptimizer;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.Output;
import org.kie.kogito.explainability.model.Prediction;
import org.kie.kogito.explainability.model.PredictionInput;
import org.kie.kogito.explainability.model.PredictionProvider;
import org.kie.kogito.explainability.model.Saliency;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordingLimeExplainer
extends LimeExplainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecordingLimeExplainer.class);
    private final LimeConfigOptimizationStrategy strategy;
    private final Queue<Prediction> recordedPredictions;
    private LimeConfig executionConfig;

    public RecordingLimeExplainer(int capacity) {
        this(new LimeConfig(), capacity);
    }

    public RecordingLimeExplainer(LimeConfig limeConfig, int capacity, LimeConfigOptimizationStrategy strategy) {
        super(limeConfig);
        this.recordedPredictions = new FixedSizeConcurrentLinkedDeque<Prediction>(capacity);
        this.strategy = strategy;
        this.executionConfig = limeConfig;
    }

    public RecordingLimeExplainer(LimeConfig limeConfig, int capacity) {
        this(limeConfig, capacity, new CountingOptimizationStrategy(10 * capacity, new DefaultLimeOptimizationService(new LimeConfigOptimizer().forImpactAndStabilityScore(), 1)));
    }

    @Override
    public CompletableFuture<Map<String, Saliency>> explainAsync(Prediction prediction, PredictionProvider model) {
        if (!this.recordedPredictions.offer(prediction)) {
            LOGGER.debug("Prediction {} not recorded", (Object)prediction);
        }
        this.strategy.maybeOptimize(this.getRecordedPredictions(), model, this, this.executionConfig);
        return super.explainAsync(prediction, model);
    }

    @Override
    protected CompletableFuture<Map<String, Saliency>> explainWithExecutionConfig(PredictionProvider model, PredictionInput originalInput, List<Feature> linearizedTargetInputFeatures, List<Output> actualOutputs, LimeConfig config) {
        LimeConfig optimizedConfig = this.strategy.bestConfigFor(this);
        if (optimizedConfig != null) {
            this.executionConfig = optimizedConfig;
        }
        return super.explainWithExecutionConfig(model, originalInput, linearizedTargetInputFeatures, actualOutputs, this.executionConfig);
    }

    public List<Prediction> getRecordedPredictions() {
        Prediction[] a = this.recordedPredictions.toArray(new Prediction[0]);
        return Collections.unmodifiableList(Arrays.asList(a));
    }

    public LimeConfig getExecutionConfig() {
        return this.executionConfig;
    }

    static class FixedSizeConcurrentLinkedDeque<T>
    extends ConcurrentLinkedDeque<T> {
        private final int capacity;

        FixedSizeConcurrentLinkedDeque(int capacity) {
            this.capacity = capacity;
        }

        @Override
        public boolean offer(T o) {
            return !this.contains(o) && super.offer(o) && (this.size() <= this.capacity || super.pop() != null);
        }
    }
}

