/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.shap;

import org.apache.commons.math3.linear.RealVector;

public class ShapStatistics {
    private final int numSubsetSizes;
    private int numFullSubsets;
    private final int[] numSubsetsAtSize;
    private final int largestPairedSubsetSize;
    private RealVector remainingWeights;
    private RealVector weightOfSubsetSize;
    private RealVector finalRemainingWeights;
    private int numSamplesRemaining;

    public ShapStatistics(int numSubsetSizes, int largestPairedSubsetSize, int[] numSubsetsAtSize, int numSamplesRemaining) {
        this.numSubsetSizes = numSubsetSizes;
        this.numSubsetsAtSize = numSubsetsAtSize;
        this.largestPairedSubsetSize = largestPairedSubsetSize;
        this.numSamplesRemaining = numSamplesRemaining;
        this.numFullSubsets = 0;
    }

    public int getNumSubsetSizes() {
        return this.numSubsetSizes;
    }

    public int[] getNumSubsetsAtSize() {
        return this.numSubsetsAtSize;
    }

    public int getLargestPairedSubsetSize() {
        return this.largestPairedSubsetSize;
    }

    public int getNumFullSubsets() {
        return this.numFullSubsets;
    }

    public void incrementNumFullSubsets() {
        ++this.numFullSubsets;
    }

    public RealVector getWeightOfSubsetSize() {
        return this.weightOfSubsetSize;
    }

    public void setWeightOfSubsetSize(RealVector weightOfSubsetSize) {
        this.weightOfSubsetSize = weightOfSubsetSize;
    }

    public RealVector getRemainingWeights() {
        return this.remainingWeights;
    }

    public void setRemainingWeights(RealVector remainingWeights) {
        this.remainingWeights = remainingWeights;
    }

    public RealVector getFinalRemainingWeights() {
        return this.finalRemainingWeights;
    }

    public void setFinalRemainingWeights(RealVector finalRemainingWeights) {
        this.finalRemainingWeights = finalRemainingWeights;
    }

    public int getNumSamplesRemaining() {
        return this.numSamplesRemaining;
    }

    public void decreaseNumSamplesRemainingBy(int value) {
        this.numSamplesRemaining -= value;
    }
}

