/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.model;

import java.util.Objects;
import org.kie.kogito.explainability.model.Feature;

public class FeatureImportance {
    private final Feature feature;
    private final double score;
    private final double confidence;

    public FeatureImportance(Feature feature, double score) {
        this.feature = feature;
        this.score = score;
        this.confidence = 0.0;
    }

    public FeatureImportance(Feature feature, double score, double confidence) {
        this.feature = feature;
        this.score = score;
        this.confidence = confidence;
    }

    public Feature getFeature() {
        return this.feature;
    }

    public double getScore() {
        return this.score;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public String toString() {
        return "FeatureImportance{feature=" + this.feature + ", score=" + this.score + ", confidence= +/-" + this.confidence + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureImportance other = (FeatureImportance)o;
        return this.getFeature().equals(other.getFeature()) && Math.abs(this.getScore() - other.getScore()) < 1.0E-6 && Math.abs(this.getConfidence() - other.getConfidence()) < 1.0E-6;
    }

    public int hashCode() {
        return Objects.hash(this.feature, this.score, this.confidence);
    }
}

