/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.model;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.LocalTime;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Currency;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang3.ArrayUtils;
import org.kie.kogito.explainability.model.EncodingParams;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureFactory;
import org.kie.kogito.explainability.model.PerturbationContext;
import org.kie.kogito.explainability.model.Value;
import org.kie.kogito.explainability.utils.DataUtils;

public enum Type {
    TEXT("text"){

        @Override
        public Value drop(Value value) {
            return new Value("");
        }

        @Override
        public Value perturb(Value value, PerturbationContext perturbationContext) {
            return new Value("");
        }

        @Override
        public List<double[]> encode(EncodingParams params, Value target, Value ... values) {
            return 1.encodeEquals(target, values);
        }

        @Override
        public Value randomValue(PerturbationContext perturbationContext) {
            return new Value(Type.randomString(perturbationContext.getRandom()));
        }
    }
    ,
    CATEGORICAL("categorical"){

        @Override
        public Value drop(Value value) {
            return new Value("");
        }

        @Override
        public Value perturb(Value value, PerturbationContext perturbationContext) {
            String category = value.asString();
            category = !"0".equals(category) ? "0" : "1";
            return new Value(category);
        }

        @Override
        public List<double[]> encode(EncodingParams params, Value target, Value ... values) {
            return 2.encodeEquals(target, values);
        }

        @Override
        public Value randomValue(PerturbationContext perturbationContext) {
            return new Value(String.valueOf(perturbationContext.getRandom().nextInt(4)));
        }
    }
    ,
    BINARY("binary"){

        @Override
        public Value drop(Value value) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(0);
            return new Value(byteBuffer);
        }

        @Override
        public Value perturb(Value value, PerturbationContext perturbationContext) {
            if (value.getUnderlyingObject() instanceof ByteBuffer) {
                int[] indexes;
                ByteBuffer currentBuffer = (ByteBuffer)value.getUnderlyingObject();
                byte[] copy = new byte[currentBuffer.array().length];
                int maxPerturbationSize = Math.min(copy.length, Math.max((int)((double)copy.length * 0.5), perturbationContext.getNoOfPerturbations()));
                System.arraycopy(currentBuffer.array(), 0, copy, 0, currentBuffer.array().length);
                for (int index : indexes = perturbationContext.getRandom().ints(0, copy.length).limit(maxPerturbationSize).toArray()) {
                    copy[index] = 0;
                }
                return new Value(ByteBuffer.wrap(copy));
            }
            ByteBuffer byteBuffer = ByteBuffer.allocate(0);
            return new Value(byteBuffer);
        }

        @Override
        public List<double[]> encode(EncodingParams params, Value target, Value ... values) {
            return 3.encodeEquals(target, values);
        }

        @Override
        public Value randomValue(PerturbationContext perturbationContext) {
            byte[] bytes = new byte[8];
            perturbationContext.getRandom().nextBytes(bytes);
            return new Value(ByteBuffer.wrap(bytes));
        }
    }
    ,
    NUMBER("number"){

        @Override
        public Value drop(Value value) {
            value = value.asNumber() == 0.0 ? new Value(Double.NaN) : new Value(0.0);
            return value;
        }

        @Override
        public Value perturb(Value value, PerturbationContext perturbationContext) {
            double originalFeatureValue = value.asNumber();
            boolean intValue = originalFeatureValue % 1.0 == 0.0;
            double normalDistributionSample = perturbationContext.getRandom().nextGaussian();
            if (originalFeatureValue != 0.0) {
                double stDev = originalFeatureValue * 0.01;
                normalDistributionSample = normalDistributionSample * originalFeatureValue + stDev;
            }
            if (intValue && (normalDistributionSample = (double)((int)normalDistributionSample)) == originalFeatureValue) {
                normalDistributionSample = (double)((int)normalDistributionSample) + 1.0;
            }
            return new Value(normalDistributionSample);
        }

        /*
         * Exception decompiling
         */
        @Override
        public List<double[]> encode(EncodingParams params, Value target, Value ... values) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public Value randomValue(PerturbationContext perturbationContext) {
            return new Value(perturbationContext.getRandom().nextDouble());
        }
    }
    ,
    BOOLEAN("boolean"){

        @Override
        public Value drop(Value value) {
            return new Value(null);
        }

        @Override
        public Value perturb(Value value, PerturbationContext perturbationContext) {
            return new Value(!Boolean.parseBoolean(value.asString()));
        }

        @Override
        public List<double[]> encode(EncodingParams params, Value target, Value ... values) {
            return 5.encodeEquals(target, values);
        }

        @Override
        public Value randomValue(PerturbationContext perturbationContext) {
            return new Value(perturbationContext.getRandom().nextBoolean());
        }
    }
    ,
    URI("uri"){

        @Override
        public Value drop(Value value) {
            return new Value(java.net.URI.create(""));
        }

        @Override
        public Value perturb(Value value, PerturbationContext perturbationContext) {
            URI newURI;
            String uriAsString = value.asString();
            URI uri = java.net.URI.create(uriAsString);
            String scheme = uri.getScheme();
            String host = uri.getHost();
            if (perturbationContext.getRandom().nextBoolean()) {
                host = "localhost".equalsIgnoreCase(host) ? "0.0.0.0" : "localhost";
            }
            String path = uri.getPath();
            if (perturbationContext.getRandom().nextBoolean()) {
                path = "";
            }
            String fragment = uri.getFragment();
            if (perturbationContext.getRandom().nextBoolean()) {
                fragment = fragment != null && fragment.length() > 0 ? "" : Long.toHexString(Double.doubleToLongBits(perturbationContext.getRandom().nextDouble()));
            }
            try {
                newURI = new URI(scheme, host, path, fragment);
                if (uri.equals(newURI)) {
                    newURI = java.net.URI.create("");
                }
            }
            catch (URISyntaxException e) {
                newURI = java.net.URI.create("");
            }
            return new Value(newURI);
        }

        @Override
        public List<double[]> encode(EncodingParams params, Value target, Value ... values) {
            return 6.encodeEquals(target, values);
        }

        @Override
        public Value randomValue(PerturbationContext perturbationContext) {
            String uriString = "http://" + Type.randomString(perturbationContext.getRandom()) + ".com";
            URI uri = java.net.URI.create(uriString);
            return new Value(uri);
        }
    }
    ,
    TIME("time"){

        @Override
        public Value drop(Value value) {
            return new Value(null);
        }

        @Override
        public Value perturb(Value value, PerturbationContext perturbationContext) {
            LocalTime featureValue;
            try {
                featureValue = LocalTime.parse(value.asString());
            }
            catch (DateTimeException dateTimeException) {
                featureValue = LocalTime.now();
            }
            return new Value(featureValue.minusHours(1L + (long)perturbationContext.getRandom().nextInt(23)));
        }

        @Override
        public List<double[]> encode(EncodingParams params, Value target, Value ... values) {
            return 7.encodeEquals(target, values);
        }

        @Override
        public Value randomValue(PerturbationContext perturbationContext) {
            return new Value(LocalTime.of(perturbationContext.getRandom().nextInt(23), perturbationContext.getRandom().nextInt(59)));
        }
    }
    ,
    DURATION("duration"){

        @Override
        public Value drop(Value value) {
            return new Value(null);
        }

        @Override
        public Value perturb(Value value, PerturbationContext perturbationContext) {
            Duration duration;
            try {
                duration = Duration.parse(value.asString());
            }
            catch (DateTimeParseException parseException) {
                duration = Duration.of(0L, ChronoUnit.HOURS);
            }
            duration = duration.plus(1L + (long)perturbationContext.getRandom().nextInt(23), ChronoUnit.HOURS);
            return new Value(duration);
        }

        @Override
        public List<double[]> encode(EncodingParams params, Value target, Value ... values) {
            return 8.encodeEquals(target, values);
        }

        @Override
        public Value randomValue(PerturbationContext perturbationContext) {
            return new Value(Duration.ofDays(perturbationContext.getRandom().nextInt(30)));
        }
    }
    ,
    VECTOR("vector"){

        @Override
        public Value drop(Value value) {
            double[] values = value.asVector();
            if (values.length > 0) {
                Arrays.fill(values, 0.0);
            }
            return new Value(values);
        }

        @Override
        public Value perturb(Value value, PerturbationContext perturbationContext) {
            double[] vector = value.asVector();
            double[] values = Arrays.copyOf(vector, vector.length);
            if (values.length > 1) {
                int[] indexes;
                int maxPerturbationSize = Math.min(vector.length, Math.max((int)((double)vector.length * 0.5), perturbationContext.getNoOfPerturbations()));
                for (int idx : indexes = perturbationContext.getRandom().ints(0, vector.length).limit(maxPerturbationSize).toArray()) {
                    if (values[idx] != 0.0) {
                        values[idx] = 0.0;
                        continue;
                    }
                    int n = idx;
                    values[n] = values[n] - 1.0;
                }
            }
            return new Value(values);
        }

        @Override
        public List<double[]> encode(EncodingParams params, Value target, Value ... values) {
            return 9.encodeEquals(target, values);
        }

        @Override
        public Value randomValue(PerturbationContext perturbationContext) {
            double[] vector = new double[5];
            for (int i = 0; i < vector.length; ++i) {
                vector[i] = perturbationContext.getRandom().nextDouble();
            }
            return new Value(vector);
        }
    }
    ,
    UNDEFINED("undefined"){

        @Override
        public Value drop(Value value) {
            if (value.getUnderlyingObject() instanceof Feature) {
                Feature underlyingObject = (Feature)value.getUnderlyingObject();
                value = new Value(FeatureFactory.copyOf(underlyingObject, underlyingObject.getType().drop(underlyingObject.getValue())));
            } else {
                value = new Value(null);
            }
            return value;
        }

        @Override
        public Value perturb(Value value, PerturbationContext perturbationContext) {
            if (value.getUnderlyingObject() instanceof Feature) {
                Feature underlyingObject = (Feature)value.getUnderlyingObject();
                Type type = underlyingObject.getType();
                Value perturbedValue = type.perturb(underlyingObject.getValue(), perturbationContext);
                value = new Value(FeatureFactory.copyOf(underlyingObject, perturbedValue));
            } else {
                value = new Value(null);
            }
            return value;
        }

        @Override
        public List<double[]> encode(EncodingParams params, Value target, Value ... values) {
            return 10.encodeEquals(target, values);
        }

        @Override
        public Value randomValue(PerturbationContext perturbationContext) {
            return new Value(new Object());
        }
    }
    ,
    COMPOSITE("composite"){

        @Override
        public Value drop(Value value) {
            List<Feature> composite = this.getFeatures(value);
            ArrayList<Feature> newFeatures = new ArrayList<Feature>(composite.size());
            for (Feature f : composite) {
                newFeatures.add(FeatureFactory.copyOf(f, f.getType().drop(f.getValue())));
            }
            return new Value(newFeatures);
        }

        private List<Feature> getFeatures(Value value) {
            LinkedList<Feature> features;
            try {
                features = (LinkedList<Feature>)value.getUnderlyingObject();
            }
            catch (ClassCastException cce) {
                features = new LinkedList<Feature>();
            }
            return features;
        }

        @Override
        public Value perturb(Value value, PerturbationContext perturbationContext) {
            List<Feature> composite = this.getFeatures(value);
            List<Feature> newList = DataUtils.perturbFeatures(composite, perturbationContext);
            return new Value(newList);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public List<double[]> encode(EncodingParams params, Value target, Value ... values) {
            List<Feature> composite = this.getFeatures(target);
            int i = 0;
            LinkedList<Object> multiColumns = new LinkedList<Object>();
            for (Feature f : composite) {
                int finalI = i++;
                List<double[]> subColumn = f.getType().encode(params, f.getValue(), (Value[])Arrays.stream(values).map(v -> (List)v.getUnderlyingObject()).map(l -> ((Feature)l.get(finalI)).getValue()).toArray(Value[]::new));
                multiColumns.add(subColumn);
            }
            LinkedList<double[]> result = new LinkedList<double[]>();
            for (int j = 0; j < values.length; ++j) {
                void var11_13;
                LinkedList<Double> vector = new LinkedList<Double>();
                for (List list : multiColumns) {
                    double[] doubles = (double[])list.get(j);
                    vector.addAll(Arrays.asList(ArrayUtils.toObject((double[])doubles)));
                }
                double[] doubles = new double[vector.size()];
                boolean bl = false;
                while (var11_13 < doubles.length) {
                    doubles[var11_13] = (Double)vector.get((int)var11_13);
                    ++var11_13;
                }
                result.add(doubles);
            }
            return result;
        }

        @Override
        public Value randomValue(PerturbationContext perturbationContext) {
            Type[] types = Type.values();
            LinkedList<Feature> values = new LinkedList<Feature>();
            Type nestedType = types[perturbationContext.getRandom().nextInt(types.length - 1)];
            for (int i = 0; i < 5; ++i) {
                Feature f = new Feature("f_" + i, nestedType, nestedType.randomValue(perturbationContext));
                values.add(f);
            }
            return new Value(values);
        }
    }
    ,
    CURRENCY("currency"){

        @Override
        public Value drop(Value value) {
            return new Value(null);
        }

        @Override
        public Value perturb(Value value, PerturbationContext perturbationContext) {
            ArrayList<Currency> availableCurrencies = new ArrayList<Currency>(Currency.getAvailableCurrencies());
            if (value.getUnderlyingObject() instanceof Currency) {
                Currency current = (Currency)value.getUnderlyingObject();
                availableCurrencies.removeIf(current::equals);
            }
            return new Value(availableCurrencies.get(perturbationContext.getRandom().nextInt(availableCurrencies.size())));
        }

        @Override
        public List<double[]> encode(EncodingParams params, Value target, Value ... values) {
            return 12.encodeEquals(target, values);
        }

        @Override
        public Value randomValue(PerturbationContext perturbationContext) {
            ArrayList<Currency> currencies = new ArrayList<Currency>(Currency.getAvailableCurrencies());
            return new Value(currencies.get(perturbationContext.getRandom().nextInt(currencies.size() - 1)));
        }
    };

    private final String value;

    static List<double[]> encodeEquals(Value target, Value[] values) {
        ArrayList<double[]> result = new ArrayList<double[]>(values.length);
        for (Value value : values) {
            double[] data = new double[]{target.getUnderlyingObject().equals(value.getUnderlyingObject()) ? 1.0 : 0.0};
            result.add(data);
        }
        return result;
    }

    private Type(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public abstract Value drop(Value var1);

    public abstract Value perturb(Value var1, PerturbationContext var2);

    public abstract List<double[]> encode(EncodingParams var1, Value var2, Value ... var3);

    public abstract Value randomValue(PerturbationContext var1);

    private static String randomString(Random random) {
        return Long.toHexString(Double.doubleToLongBits(random.nextDouble()));
    }
}

