/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.IntStream;
import org.apache.commons.math3.linear.CholeskyDecomposition;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;

public class LarsPathDataCarrier {
    private final int nSamples;
    private final int nFeatures;
    private final int maxIterations;
    private final int maxFeatures;
    private int cIdx;
    private int nIter;
    private int nActive;
    private Set<Integer> idx;
    private int[] indices;
    private List<Integer> active;
    private static final double EQUALITY_TOLERANCE = Math.ulp(1.0f);
    private static final double TINY = 1.0E-12;
    private double c;
    private double c_;
    private double normalizationFactor;
    private double gamma;
    private double zPos;
    private boolean drop;
    private final boolean lasso;
    private boolean degenerateRegressor;
    private final RealVector y;
    private RealVector signActive;
    private RealVector alphas;
    private RealVector cov;
    private RealVector covNotShortened;
    private RealVector leastSquares;
    private RealVector corrEqDir;
    private RealVector z;
    private RealMatrix X;
    private RealMatrix coefs;
    private final RealMatrix XT;
    CholeskyDecomposition decomp;

    public LarsPathDataCarrier(RealMatrix X, RealVector y, int maxIterations, boolean lasso) {
        this.X = X;
        this.y = y;
        this.nSamples = X.getRowDimension();
        this.nFeatures = X.getColumnDimension();
        this.maxIterations = maxIterations;
        this.lasso = lasso;
        this.XT = X.transpose();
        this.cov = this.XT.operate(y);
        this.maxFeatures = Math.min(this.nFeatures, maxIterations);
        this.signActive = MatrixUtils.createRealVector((double[])new double[this.nFeatures]);
        this.indices = IntStream.range(0, this.nFeatures).toArray();
        this.active = new ArrayList<Integer>();
        this.nIter = 0;
        this.nActive = 0;
        this.drop = false;
        this.idx = new HashSet<Integer>();
        this.coefs = MatrixUtils.createRealMatrix((int)(this.maxFeatures + 1), (int)this.nFeatures);
        this.alphas = MatrixUtils.createRealVector((double[])new double[this.maxFeatures + 1]);
    }

    public int getnSamples() {
        return this.nSamples;
    }

    public int getnFeatures() {
        return this.nFeatures;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public int getMaxFeatures() {
        return this.maxFeatures;
    }

    public int getcIdx() {
        return this.cIdx;
    }

    public void setcIdx(int cIdx) {
        this.cIdx = cIdx;
    }

    public int getnIter() {
        return this.nIter;
    }

    public void incrementnIter() {
        ++this.nIter;
    }

    public int getnActive() {
        return this.nActive;
    }

    public void setnActive(int nActive) {
        this.nActive = nActive;
    }

    public Set<Integer> getIdx() {
        return this.idx;
    }

    public void setIdx(Set<Integer> idx) {
        this.idx = idx;
    }

    public int[] getIndices() {
        return this.indices;
    }

    public List<Integer> getActive() {
        return this.active;
    }

    public void setActive(List<Integer> active) {
        this.active = active;
    }

    public double getEqualityTolerance() {
        return EQUALITY_TOLERANCE;
    }

    public double getTiny() {
        return 1.0E-12;
    }

    public double getC() {
        return this.c;
    }

    public void setC(double c) {
        this.c = c;
    }

    public double getC_() {
        return this.c_;
    }

    public void setC_(double c_) {
        this.c_ = c_;
    }

    public double getNormalizationFactor() {
        return this.normalizationFactor;
    }

    public void setNormalizationFactor(double normalizationFactor) {
        this.normalizationFactor = normalizationFactor;
    }

    public double getGamma() {
        return this.gamma;
    }

    public void setGamma(double gamma) {
        this.gamma = gamma;
    }

    public double getzPos() {
        return this.zPos;
    }

    public void setzPos(double zPos) {
        this.zPos = zPos;
    }

    public boolean isDrop() {
        return this.drop;
    }

    public void setDrop(boolean drop) {
        this.drop = drop;
    }

    public boolean isDegenerateRegressor() {
        return this.degenerateRegressor;
    }

    public void setDegenerateRegressor(boolean degenerateRegressor) {
        this.degenerateRegressor = degenerateRegressor;
    }

    public boolean isLasso() {
        return this.lasso;
    }

    public RealVector getY() {
        return this.y;
    }

    public RealVector getSignActive() {
        return this.signActive;
    }

    public void setSignActive(RealVector signActive) {
        this.signActive = signActive;
    }

    public RealVector getAlphas() {
        return this.alphas;
    }

    public void setAlphas(RealVector alphas) {
        this.alphas = alphas;
    }

    public RealVector getCov() {
        return this.cov;
    }

    public void setCov(RealVector cov) {
        this.cov = cov;
    }

    public RealVector getCovNotShortened() {
        return this.covNotShortened;
    }

    public void setCovNotShortened(RealVector covNotShortened) {
        this.covNotShortened = covNotShortened;
    }

    public RealVector getLeastSquares() {
        return this.leastSquares;
    }

    public void setLeastSquares(RealVector leastSquares) {
        this.leastSquares = leastSquares;
    }

    public RealVector getCorrEqDir() {
        return this.corrEqDir;
    }

    public void setCorrEqDir(RealVector corrEqDir) {
        this.corrEqDir = corrEqDir;
    }

    public RealVector getZ() {
        return this.z;
    }

    public void setZ(RealVector z) {
        this.z = z;
    }

    public RealMatrix getX() {
        return this.X;
    }

    public void setX(RealMatrix x) {
        this.X = x;
    }

    public RealMatrix getCoefs() {
        return this.coefs;
    }

    public void setCoefs(RealMatrix coefs) {
        this.coefs = coefs;
    }

    public RealMatrix getXT() {
        return this.XT;
    }

    public CholeskyDecomposition getDecomp() {
        return this.decomp;
    }

    public void setDecomp(CholeskyDecomposition decomp) {
        this.decomp = decomp;
    }
}

