/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.NavigableMap;
import java.util.Random;
import java.util.TreeMap;

public class RandomChoice<T> {
    NavigableMap<Double, T> sampleSet = new TreeMap<Double, T>();
    double totalWeights = 0.0;

    public RandomChoice(List<T> items, List<Double> weights) {
        if (items.size() != weights.size()) {
            throw new IllegalArgumentException(String.format("Length of weight vector does not match length of items: %d vs %d", weights.size(), items.size()));
        }
        for (int i = 0; i < items.size(); ++i) {
            if (!(weights.get(i) > 0.0)) continue;
            this.totalWeights += weights.get(i).doubleValue();
            this.sampleSet.put(this.totalWeights, items.get(i));
        }
    }

    public RandomChoice(List<T> items) {
        for (int i = 0; i < items.size(); ++i) {
            this.totalWeights += 1.0;
            this.sampleSet.put(this.totalWeights, items.get(i));
        }
    }

    public List<T> sample(int n, Random rn) {
        ArrayList<T> output = new ArrayList<T>();
        for (int i = 0; i < n; ++i) {
            double key = rn.nextDouble() * this.totalWeights;
            output.add(this.sampleSet.higherEntry(key).getValue());
        }
        return output;
    }
}

