/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.client.serialization.jaxb.impl.type;

import java.lang.reflect.Array;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.kie.services.client.serialization.jaxb.impl.type.JaxbType;

@XmlRootElement(name="array-type")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class JaxbArray
implements JaxbType<Object[]> {
    @XmlElement
    private Object[] value;

    public JaxbArray() {
    }

    public JaxbArray(Object objValue) {
        Class<?> objClass = objValue.getClass();
        if (!objClass.isArray()) {
            throw new IllegalArgumentException("This wrapper can only wrap arrays, not instances of " + objClass.getName());
        }
        int length = Array.getLength(objValue);
        this.value = new Object[length];
        for (int i = 0; i < length; ++i) {
            Array.set(this.value, i, Array.get(objValue, i));
        }
    }

    @Override
    public Object[] getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object[] value) {
        this.value = value;
    }
}

