/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.client.api;

import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import javax.jms.ConnectionFactory;
import javax.jms.Queue;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.kie.services.client.api.RemoteJmsRuntimeEngineFactoryBuilderImpl;
import org.kie.services.client.api.RemoteRuntimeEngineFactory;
import org.kie.services.client.api.builder.RemoteJmsRuntimeEngineFactoryBuilder;
import org.kie.services.client.api.command.RemoteConfiguration;
import org.kie.services.client.api.command.RemoteRuntimeEngine;
import org.kie.services.client.api.command.exception.RemoteCommunicationException;

public class RemoteJmsRuntimeEngineFactory
implements RemoteRuntimeEngineFactory {
    protected RemoteConfiguration config;

    protected RemoteJmsRuntimeEngineFactory() {
    }

    RemoteJmsRuntimeEngineFactory(RemoteConfiguration config) {
        this.config = config;
    }

    @Deprecated
    public RemoteJmsRuntimeEngineFactory(String deploymentId, URL hostUrl, String userName, String password) {
        InitialContext context = RemoteJmsRuntimeEngineFactory.getRemoteJbossInitialContext(hostUrl, userName, password);
        this.config = new RemoteConfiguration(deploymentId, context, userName, password);
    }

    @Deprecated
    public RemoteJmsRuntimeEngineFactory(String deploymentId, InitialContext context, String username, String password) {
        this.config = new RemoteConfiguration(deploymentId, context, username, password);
    }

    @Deprecated
    public RemoteJmsRuntimeEngineFactory(String deploymentId, InitialContext context, String username, String password, int qualityofServiceThresholdSeconds) {
        this.config = new RemoteConfiguration(deploymentId, context, username, password);
        this.config.setTimeout(qualityofServiceThresholdSeconds * 1000);
    }

    @Deprecated
    public RemoteJmsRuntimeEngineFactory(String deploymentId, ConnectionFactory connectionFactory, Queue ksessionQueue, Queue taskQueue, Queue responseQueue, String username, String password) {
        this.config = new RemoteConfiguration(deploymentId, connectionFactory, ksessionQueue, taskQueue, responseQueue, username, password);
    }

    @Deprecated
    public RemoteJmsRuntimeEngineFactory(String deploymentId, ConnectionFactory connectionFactory, Queue ksessionQueue, Queue taskQueue, Queue responseQueue, String username, String password, int qualityOfServiceThresholdSeconds) {
        this.config = new RemoteConfiguration(deploymentId, connectionFactory, ksessionQueue, taskQueue, responseQueue, username, password);
        this.config.setTimeout(qualityOfServiceThresholdSeconds * 1000);
    }

    public static InitialContext getRemoteJbossInitialContext(URL url, String user, String password) {
        Properties initialProps = new Properties();
        initialProps.setProperty("java.naming.factory.initial", "org.jboss.naming.remote.client.InitialContextFactory");
        String jbossServerHostName = url.getHost();
        initialProps.setProperty("java.naming.provider.url", "remote://" + jbossServerHostName + ":4447");
        initialProps.setProperty("java.naming.security.principal", user);
        initialProps.setProperty("java.naming.security.credentials", password);
        for (Object keyObj : initialProps.keySet()) {
            String key = (String)keyObj;
            System.setProperty(key, (String)initialProps.get(key));
        }
        try {
            return new InitialContext(initialProps);
        }
        catch (NamingException e) {
            throw new RemoteCommunicationException("Unable to create " + InitialContext.class.getSimpleName(), e);
        }
    }

    @Override
    public RemoteRuntimeEngine newRuntimeEngine() {
        return new RemoteRuntimeEngine(this.config);
    }

    @Override
    @Deprecated
    public void addExtraJaxbClasses(Collection<Class<?>> extraJaxbClasses) {
        this.config.addJaxbClasses(new HashSet(extraJaxbClasses));
    }

    public static RemoteJmsRuntimeEngineFactoryBuilder newBuilder() {
        return new RemoteJmsRuntimeEngineFactoryBuilderImpl();
    }
}

