/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.client.api;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import javax.jms.ConnectionFactory;
import javax.jms.Queue;
import javax.naming.InitialContext;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.core.remoting.impl.netty.NettyConnectorFactory;
import org.hornetq.jms.client.HornetQJMSConnectionFactory;
import org.kie.services.client.api.RemoteJmsRuntimeEngineFactory;
import org.kie.services.client.api.builder.RemoteJmsRuntimeEngineFactoryBuilder;
import org.kie.services.client.api.builder.exception.InsufficientInfoToBuildException;
import org.kie.services.client.api.command.RemoteConfiguration;

public class RemoteJmsRuntimeEngineFactoryBuilderImpl
implements RemoteJmsRuntimeEngineFactoryBuilder {
    private RemoteConfiguration config = new RemoteConfiguration(RemoteConfiguration.Type.JMS);
    private InitialContext remoteInitialContext = null;
    private URL jbossServerUrl = null;
    private boolean createOwnFactory = false;
    private String hostName = null;
    private Integer jmsConnectorPort = null;
    private String keystorePassword;
    private String keystoreLocation;
    private String truststorePassword;
    private String truststoreLocation;
    private boolean useKeystoreAsTruststore = false;

    RemoteJmsRuntimeEngineFactoryBuilderImpl() {
    }

    @Override
    public RemoteJmsRuntimeEngineFactoryBuilder addDeploymentId(String deploymentId) {
        this.config.setDeploymentId(deploymentId);
        return this;
    }

    @Override
    public RemoteJmsRuntimeEngineFactoryBuilder addProcessInstanceId(long processInstanceId) {
        this.config.setProcessInstanceId(processInstanceId);
        return this;
    }

    @Override
    public RemoteJmsRuntimeEngineFactoryBuilder addUserName(String userName) {
        this.config.setUserName(userName);
        return this;
    }

    @Override
    public RemoteJmsRuntimeEngineFactoryBuilder addPassword(String password) {
        this.config.setPassword(password);
        return this;
    }

    @Override
    public RemoteJmsRuntimeEngineFactoryBuilder addTimeout(int timeoutInSeconds) {
        this.config.setTimeout(timeoutInSeconds);
        return this;
    }

    @Override
    public RemoteJmsRuntimeEngineFactoryBuilder addExtraJaxbClasses(Class ... classes) {
        HashSet classSet = new HashSet();
        for (Class clazz : classes) {
            classSet.add(clazz);
        }
        this.config.addJaxbClasses(classSet);
        return this;
    }

    @Override
    public RemoteJmsRuntimeEngineFactoryBuilder clearJaxbClasses() {
        this.config.clearJaxbClasses();
        return this;
    }

    @Override
    public RemoteJmsRuntimeEngineFactoryBuilder addRemoteInitialContext(InitialContext remoteInitialContext) {
        this.remoteInitialContext = remoteInitialContext;
        return this;
    }

    @Override
    public RemoteJmsRuntimeEngineFactoryBuilder addJbossServerUrl(URL serverUrl) {
        this.jbossServerUrl = serverUrl;
        return this;
    }

    @Override
    public RemoteJmsRuntimeEngineFactoryBuilder addKieSessionQueue(Queue ksessionQueue) {
        this.config.setKsessionQueue(ksessionQueue);
        return this;
    }

    @Override
    public RemoteJmsRuntimeEngineFactoryBuilder addTaskServiceQueue(Queue taskServiceQueue) {
        this.config.setTaskQueue(taskServiceQueue);
        return this;
    }

    @Override
    public RemoteJmsRuntimeEngineFactoryBuilder addResponseQueue(Queue responseQueue) {
        this.config.setResponseQueue(responseQueue);
        return this;
    }

    @Override
    public RemoteJmsRuntimeEngineFactoryBuilder addConnectionFactory(ConnectionFactory connectionFactory) {
        this.config.setConnectionFactory(connectionFactory);
        return this;
    }

    @Override
    public RemoteJmsRuntimeEngineFactoryBuilderImpl addHostName(String hostNameOrIp) {
        this.createOwnFactory = true;
        this.hostName = hostNameOrIp;
        return this;
    }

    @Override
    public RemoteJmsRuntimeEngineFactoryBuilderImpl addJmsConnectorPort(int port) {
        this.createOwnFactory = true;
        this.jmsConnectorPort = port;
        return this;
    }

    @Override
    public RemoteJmsRuntimeEngineFactoryBuilder useSsl(boolean useSsl) {
        this.createOwnFactory = useSsl;
        this.config.setUseSsl(useSsl);
        return this;
    }

    @Override
    public RemoteJmsRuntimeEngineFactoryBuilderImpl addKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
        this.useSsl(true);
        return this;
    }

    @Override
    public RemoteJmsRuntimeEngineFactoryBuilderImpl addKeystoreLocation(String keystoreLocation) {
        this.keystoreLocation = keystoreLocation;
        this.useSsl(true);
        return this;
    }

    @Override
    public RemoteJmsRuntimeEngineFactoryBuilderImpl addTruststorePassword(String truststorePassword) {
        this.truststorePassword = truststorePassword;
        this.useSsl(true);
        return this;
    }

    @Override
    public RemoteJmsRuntimeEngineFactoryBuilderImpl addTruststoreLocation(String truststoreLocation) {
        this.truststoreLocation = truststoreLocation;
        this.useSsl(true);
        return this;
    }

    public RemoteJmsRuntimeEngineFactoryBuilderImpl useKeystoreAsTruststore() {
        this.useKeystoreAsTruststore = true;
        this.useSsl(true);
        return this;
    }

    @Override
    public RemoteJmsRuntimeEngineFactory build() throws InsufficientInfoToBuildException {
        if (this.config.getUserName() == null) {
            throw new InsufficientInfoToBuildException("A user name is required to access the JMS queues!");
        }
        if (this.config.getPassword() == null) {
            throw new InsufficientInfoToBuildException("A password is required to access the JMS queues!");
        }
        if (this.createOwnFactory) {
            HashMap<String, Object> connParams;
            HornetQJMSConnectionFactory createdConnectionFactory = null;
            if (this.hostName == null) {
                throw new InsufficientInfoToBuildException("A host name or IP address is required to create a JMS ConnectionFactory!");
            }
            if (this.jmsConnectorPort == null) {
                throw new InsufficientInfoToBuildException("A connector port is required to create a JMS ConnectionFactory!");
            }
            if (this.config.getUseUssl()) {
                connParams = new HashMap<String, Object>(7);
                connParams.put("port", this.jmsConnectorPort);
                connParams.put("host", this.hostName);
                this.checkKeyAndTruststoreInfo();
                connParams.put("ssl-enabled", true);
                connParams.put("key-store-password", this.keystorePassword);
                connParams.put("key-store-path", this.keystoreLocation);
                connParams.put("trust-store-password", this.truststorePassword);
                connParams.put("trust-store-path", this.truststoreLocation);
            } else {
                connParams = new HashMap(3);
                connParams.put("port", this.jmsConnectorPort);
                connParams.put("host", this.hostName);
                connParams.put("ssl-enabled", false);
            }
            createdConnectionFactory = new HornetQJMSConnectionFactory(false, new TransportConfiguration[]{new TransportConfiguration(NettyConnectorFactory.class.getName(), connParams)});
            this.config.setConnectionFactory((ConnectionFactory)createdConnectionFactory);
        }
        if (this.jbossServerUrl != null && this.remoteInitialContext == null) {
            this.remoteInitialContext = RemoteJmsRuntimeEngineFactory.getRemoteJbossInitialContext(this.jbossServerUrl, this.config.getUserName(), this.config.getPassword());
        }
        if (this.remoteInitialContext != null) {
            this.config.setRemoteInitialContext(this.remoteInitialContext);
        } else {
            this.config.checkValidJmsValues();
        }
        return new RemoteJmsRuntimeEngineFactory(this.config.clone());
    }

    private void checkKeyAndTruststoreInfo() {
        String[][] pathInfos;
        if (this.useKeystoreAsTruststore) {
            this.truststoreLocation = this.keystoreLocation;
            this.truststorePassword = this.keystorePassword;
        }
        if (this.keystorePassword == null) {
            throw new InsufficientInfoToBuildException("A keystore password is required to build the SSL JMS connection factory.");
        }
        if (this.truststorePassword == null) {
            throw new InsufficientInfoToBuildException("A truststore password is required to build the SSL JMS connection factory.");
        }
        for (String[] pathInfo : pathInfos = new String[][]{{this.keystoreLocation, "keystore"}, {this.truststoreLocation, "truststore"}}) {
            Serializable storeFile;
            String path = pathInfo[0];
            String name = pathInfo[1];
            if (path == null) {
                throw new InsufficientInfoToBuildException("A " + name + " location is required to build the SSL JMS connection factory.");
            }
            if (path.startsWith("/")) {
                storeFile = new File(path);
                if (storeFile.exists()) continue;
                throw new InsufficientInfoToBuildException("No " + name + " file could be found at '" + path + "'");
            }
            storeFile = this.getClass().getResource("/" + path);
            if (storeFile != null) continue;
            throw new InsufficientInfoToBuildException("No " + name + " file could be found on the classpath at '" + path + "'");
        }
    }

    public static RemoteJmsRuntimeEngineFactoryBuilderImpl newBuilder() {
        return new RemoteJmsRuntimeEngineFactoryBuilderImpl();
    }
}

