/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.client.api;

import java.net.MalformedURLException;
import java.net.URL;
import javax.ws.rs.core.MediaType;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientRequestFactory;
import org.kie.services.client.api.command.RemoteConfiguration;

public class RestRequestHelper {
    private ClientRequestFactory requestFactory;
    private URL serverPlusRestUrl = null;
    private MediaType type = null;
    private String username = null;
    private String password = null;
    private int timeout = 5;
    private boolean formBasedAuth = false;

    private URL addRestToPath(URL origUrl) {
        StringBuilder urlString = new StringBuilder(origUrl.toExternalForm());
        if (!urlString.toString().endsWith("/")) {
            urlString.append("/");
        }
        urlString.append("rest/");
        this.serverPlusRestUrl = RestRequestHelper.convertStringToUrl(urlString.toString());
        return this.serverPlusRestUrl;
    }

    private static URL convertStringToUrl(String urlString) {
        URL realUrl;
        try {
            realUrl = new URL(urlString);
        }
        catch (MalformedURLException murle) {
            throw new IllegalArgumentException("URL (" + urlString + ") is incorrectly formatted: " + murle.getMessage(), murle);
        }
        return realUrl;
    }

    private RestRequestHelper() {
    }

    public static RestRequestHelper newInstance(URL serverPortUrl, String username, String password, int timeout, MediaType mediaType, boolean formBasedAuth) {
        RestRequestHelper inst = new RestRequestHelper();
        URL serverPlusRestUrl = inst.addRestToPath(serverPortUrl);
        inst.requestFactory = formBasedAuth ? RemoteConfiguration.createFormBasedAuthenticatingRequestFactory(serverPlusRestUrl, username, password, timeout) : RemoteConfiguration.createAuthenticatingRequestFactory(serverPlusRestUrl, username, password, timeout);
        inst.type = mediaType;
        inst.username = username;
        inst.password = password;
        return inst;
    }

    public static RestRequestHelper newInstance(URL serverPortUrl, String username, String password, int timeout, MediaType mediaType) {
        return RestRequestHelper.newInstance(serverPortUrl, username, password, timeout, mediaType, false);
    }

    public static RestRequestHelper newInstance(URL serverPortUrl, String username, String password, int timeout) {
        return RestRequestHelper.newInstance(serverPortUrl, username, password, timeout, null);
    }

    public static RestRequestHelper newInstance(URL serverPortUrl, String username, String password) {
        return RestRequestHelper.newInstance(serverPortUrl, username, password, 5, null);
    }

    public RestRequestHelper setMediaType(MediaType type) {
        this.type = type;
        return this;
    }

    public MediaType getMediaType() {
        return this.type;
    }

    public RestRequestHelper setTimeout(int timeout) {
        this.timeout = timeout;
        this.requestFactory = RemoteConfiguration.createAuthenticatingRequestFactory(this.serverPlusRestUrl, this.username, this.password, timeout);
        return this;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public RestRequestHelper setFormBasedAuth(boolean useFormBasedAuth) {
        this.formBasedAuth = useFormBasedAuth;
        return this;
    }

    public boolean getFormBasedAuth() {
        return this.formBasedAuth;
    }

    public ClientRequest createRequest(String restOperationUrl) {
        if (restOperationUrl.startsWith("/")) {
            restOperationUrl = restOperationUrl.substring(1);
        }
        ClientRequest request = this.requestFactory.createRelativeRequest(restOperationUrl);
        if (this.type != null) {
            request.accept(this.type);
        }
        return request;
    }

    public static ClientRequestFactory createRequestFactory(URL restBaseUrl, String username, String password, int timeout) {
        return RemoteConfiguration.createAuthenticatingRequestFactory(restBaseUrl, username, password, timeout);
    }

    public static ClientRequestFactory createRequestFactory(URL restBaseUrl, String username, String password) {
        return RemoteConfiguration.createAuthenticatingRequestFactory(restBaseUrl, username, password, 5);
    }

    public static ClientRequestFactory createRequestFactory(URL restBaseUrl, String username, String password, boolean useFormBasedAuth) {
        if (useFormBasedAuth) {
            return RemoteConfiguration.createFormBasedAuthenticatingRequestFactory(restBaseUrl, username, password, 5);
        }
        return RemoteConfiguration.createAuthenticatingRequestFactory(restBaseUrl, username, password, 5);
    }

    public static ClientRequestFactory createRequestFactory(URL restBaseUrl, String username, String password, int timeout, boolean useFormBasedAuth) {
        if (useFormBasedAuth) {
            return RemoteConfiguration.createFormBasedAuthenticatingRequestFactory(restBaseUrl, username, password, timeout);
        }
        return RemoteConfiguration.createAuthenticatingRequestFactory(restBaseUrl, username, password, timeout);
    }
}

