/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.client.api.command;

import java.io.IOException;
import java.net.Inet6Address;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.ConnectionFactory;
import javax.jms.Queue;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientRequestFactory;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor;
import org.jboss.resteasy.spi.interception.ClientExecutionContext;
import org.jboss.resteasy.spi.interception.ClientExecutionInterceptor;
import org.kie.services.client.api.builder.exception.InsufficientInfoToBuildException;
import org.kie.services.client.api.command.exception.RemoteCommunicationException;
import org.kie.services.client.serialization.JaxbSerializationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RemoteConfiguration {
    public static final String SSL_CONNECTION_FACTORY_NAME = "jms/SslRemoteConnectionFactory";
    public static final String CONNECTION_FACTORY_NAME = "jms/RemoteConnectionFactory";
    public static final String SESSION_QUEUE_NAME = "jms/queue/KIE.SESSION";
    public static final String TASK_QUEUE_NAME = "jms/queue/KIE.TASK";
    public static final String RESPONSE_QUEUE_NAME = "jms/queue/KIE.RESPONSE";
    public static final int DEFAULT_TIMEOUT = 5;
    private long timeout = 5L;
    private final Type type;
    private String deploymentId;
    private Long processInstanceId;
    private String userName;
    private String password;
    private Set<Class<?>> extraJaxbClasses = new HashSet();
    private ClientRequestFactory requestFactory;
    private boolean useFormBasedAuth = false;
    private boolean useSsl = false;
    private ConnectionFactory connectionFactory;
    private Queue ksessionQueue;
    private Queue taskQueue;
    private Queue responseQueue;
    private int jmsSerializationType = 0;
    private static final AtomicInteger idGen = new AtomicInteger(0);

    private RemoteConfiguration() {
        this.type = Type.CONSTRUCTOR;
    }

    public RemoteConfiguration(Type type) {
        this.type = type;
    }

    public RemoteConfiguration(String deploymentId, URL url, String username, String password) {
        this(deploymentId, url, username, password, 5);
    }

    public RemoteConfiguration(String deploymentId, URL url, String username, String password, int timeout) {
        this(deploymentId, url, username, password, timeout, false);
    }

    public RemoteConfiguration(String deploymentId, URL url, String username, String password, int timeout, boolean formBasedAuth) {
        this.type = Type.REST;
        this.deploymentId = deploymentId;
        this.timeout = timeout;
        this.useFormBasedAuth = formBasedAuth;
        this.createRequestFactory(url, username, password);
    }

    public void createRequestFactory(URL url, String username, String password) {
        URL serverPlusRestUrl = this.initializeRestServicesUrl(url);
        if (username == null || username.trim().isEmpty()) {
            throw new IllegalArgumentException("The user name may not be empty or null.");
        }
        if (password == null) {
            throw new IllegalArgumentException("The password may not be null.");
        }
        this.requestFactory = this.useFormBasedAuth ? RemoteConfiguration.createFormBasedAuthenticatingRequestFactory(serverPlusRestUrl, username, password, (int)this.timeout) : RemoteConfiguration.createAuthenticatingRequestFactory(serverPlusRestUrl, username, password, (int)this.timeout);
    }

    private URL initializeRestServicesUrl(URL url) {
        URL serverPlusRestUrl;
        if (url == null) {
            throw new IllegalArgumentException("The url may not be empty or null.");
        }
        try {
            url.toURI();
        }
        catch (URISyntaxException urise) {
            throw new IllegalArgumentException("URL (" + url.toExternalForm() + ") is incorrectly formatted: " + urise.getMessage(), urise);
        }
        String urlString = url.toExternalForm();
        if (!urlString.endsWith("/")) {
            urlString = urlString + "/";
        }
        urlString = urlString + "rest";
        try {
            serverPlusRestUrl = new URL(urlString);
        }
        catch (MalformedURLException murle) {
            throw new IllegalArgumentException("URL (" + url.toExternalForm() + ") is incorrectly formatted: " + murle.getMessage(), murle);
        }
        return serverPlusRestUrl;
    }

    public static ClientRequestFactory createAuthenticatingRequestFactory(URL url, String username, String password, int timeout) {
        BasicHttpContext localContext = new BasicHttpContext();
        DefaultHttpClient preemptiveAuthClient = RemoteConfiguration.createPreemptiveAuthHttpClient(username, password, timeout, localContext);
        ApacheHttpClient4Executor clientExecutor = new ApacheHttpClient4Executor((HttpClient)preemptiveAuthClient, (HttpContext)localContext);
        try {
            return new ClientRequestFactory((ClientExecutor)clientExecutor, url.toURI());
        }
        catch (URISyntaxException urise) {
            throw new IllegalArgumentException("URL (" + url.toExternalForm() + ") is not formatted correctly.", urise);
        }
    }

    public static ClientRequestFactory createFormBasedAuthenticatingRequestFactory(URL url, String username, String password, int timeout) {
        try {
            return new FormBasedAuthenticatingClientRequestFactory(url.toURI(), username, password, timeout);
        }
        catch (URISyntaxException urise) {
            throw new RemoteCommunicationException("Invalid URL: " + url.toExternalForm(), urise);
        }
    }

    private static DefaultHttpClient createPreemptiveAuthHttpClient(String userName, String password, int timeout, BasicHttpContext localContext) {
        BasicHttpParams params = new BasicHttpParams();
        int timeoutMilliSeconds = timeout * 1000;
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)timeoutMilliSeconds);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)timeoutMilliSeconds);
        DefaultHttpClient client = new DefaultHttpClient((HttpParams)params);
        if (userName != null && !"".equals(userName)) {
            client.getCredentialsProvider().setCredentials(new AuthScope(AuthScope.ANY_HOST, -1), (Credentials)new UsernamePasswordCredentials(userName, password));
            BasicScheme basicAuth = new BasicScheme();
            String contextId = UUID.randomUUID().toString();
            localContext.setAttribute(contextId, (Object)basicAuth);
            client.addRequestInterceptor((HttpRequestInterceptor)new PreemptiveAuth(contextId), 0);
        }
        String hostname = "localhost";
        try {
            hostname = Inet6Address.getLocalHost().toString();
        }
        catch (Exception e) {
            // empty catch block
        }
        String userAgent = "org.kie.services.client (" + idGen.incrementAndGet() + " / " + hostname + ")";
        HttpProtocolParams.setUserAgent((HttpParams)client.getParams(), (String)userAgent);
        return client;
    }

    public RemoteConfiguration(String deploymentId, ConnectionFactory connectionFactory, Queue ksessionQueue, Queue taskQueue, Queue responseQueue) {
        this.deploymentId = deploymentId;
        this.type = Type.JMS;
        this.setQueuesAndConnectionFactory(connectionFactory, ksessionQueue, taskQueue, responseQueue);
    }

    public void setQueuesAndConnectionFactory(ConnectionFactory connectionFactory, Queue ksessionQueue, Queue taskQueue, Queue responseQueue) {
        this.connectionFactory = connectionFactory;
        this.ksessionQueue = ksessionQueue;
        this.taskQueue = taskQueue;
        this.responseQueue = responseQueue;
        RemoteConfiguration.checkValidValues(this.connectionFactory, this.ksessionQueue, this.taskQueue, this.responseQueue);
    }

    public void checkValidJmsValues() {
        RemoteConfiguration.checkValidValues(this.connectionFactory, this.ksessionQueue, this.taskQueue, this.responseQueue);
    }

    private static void checkValidValues(ConnectionFactory connectionFactory, Queue ksessionQueue, Queue taskQueue, Queue responseQueue) throws InsufficientInfoToBuildException {
        if (connectionFactory == null) {
            throw new InsufficientInfoToBuildException("The connection factory argument may not be null.");
        }
        if (ksessionQueue == null && taskQueue == null) {
            throw new InsufficientInfoToBuildException("At least a ksession queue or task queue is required.");
        }
        if (responseQueue == null) {
            throw new InsufficientInfoToBuildException("The response queue argument may not be null.");
        }
    }

    public RemoteConfiguration(String deploymentId, ConnectionFactory connectionFactory, Queue ksessionQueue, Queue taskQueue, Queue responseQueue, String username, String password) {
        this(deploymentId, connectionFactory, ksessionQueue, taskQueue, responseQueue);
        this.setAndCheckUserNameAndPassword(username, password);
    }

    public RemoteConfiguration(String deploymentId, InitialContext context, String username, String password) {
        this.deploymentId = deploymentId;
        this.type = Type.JMS;
        this.setAndCheckUserNameAndPassword(username, password);
        this.setRemoteInitialContext(context);
    }

    public void setRemoteInitialContext(InitialContext context) {
        String prop = CONNECTION_FACTORY_NAME;
        try {
            if (this.connectionFactory == null) {
                this.connectionFactory = (ConnectionFactory)context.lookup(prop);
            }
            prop = SESSION_QUEUE_NAME;
            this.ksessionQueue = (Queue)context.lookup(prop);
            prop = TASK_QUEUE_NAME;
            this.taskQueue = (Queue)context.lookup(prop);
            prop = RESPONSE_QUEUE_NAME;
            this.responseQueue = (Queue)context.lookup(prop);
        }
        catch (NamingException ne) {
            throw new RemoteCommunicationException("Unable to retrieve object for " + prop, ne);
        }
        RemoteConfiguration.checkValidValues(this.connectionFactory, this.ksessionQueue, this.taskQueue, this.responseQueue);
    }

    private void setAndCheckUserNameAndPassword(String username, String password) {
        if (username == null || username.trim().isEmpty()) {
            throw new IllegalArgumentException("The user name may not be empty or null.");
        }
        this.userName = username;
        if (password == null) {
            throw new IllegalArgumentException("The password may not be null.");
        }
        this.password = password;
    }

    String getDeploymentId() {
        return this.deploymentId;
    }

    int getSerializationType() {
        return this.jmsSerializationType;
    }

    boolean isJms() {
        assert (this.type != null) : "type is null!";
        return this.type == Type.JMS;
    }

    boolean isRest() {
        assert (this.type != null) : "type is null!";
        return this.type == Type.REST;
    }

    ClientRequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    ConnectionFactory getConnectionFactory() {
        assert (this.connectionFactory != null) : "connectionFactory value should not be null!";
        return this.connectionFactory;
    }

    Queue getKsessionQueue() {
        return this.ksessionQueue;
    }

    Queue getTaskQueue() {
        return this.taskQueue;
    }

    Queue getResponseQueue() {
        assert (this.responseQueue != null) : "responseQueue value should not be null!";
        return this.responseQueue;
    }

    public void addJaxbClasses(Set<Class<?>> extraJaxbClassList) {
        this.extraJaxbClasses.addAll(extraJaxbClassList);
    }

    public void clearJaxbClasses() {
        this.extraJaxbClasses.clear();
    }

    Set<Class<?>> getExtraJaxbClasses() {
        return this.extraJaxbClasses;
    }

    JaxbSerializationProvider getJaxbSerializationProvider() {
        JaxbSerializationProvider provider = new JaxbSerializationProvider(this.extraJaxbClasses);
        return provider;
    }

    public Type getType() {
        return this.type;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public boolean getUseUssl() {
        return this.useSsl;
    }

    Long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public void setProcessInstanceId(long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setExtraJaxbClasses(Set<Class<?>> extraJaxbClasses) {
        this.extraJaxbClasses = extraJaxbClasses;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public void setKsessionQueue(Queue ksessionQueue) {
        this.ksessionQueue = ksessionQueue;
    }

    public void setTaskQueue(Queue taskQueue) {
        this.taskQueue = taskQueue;
    }

    public void setResponseQueue(Queue responseQueue) {
        this.responseQueue = responseQueue;
    }

    public void setUseFormBasedAuth(boolean useFormBasedAuth) {
        this.useFormBasedAuth = useFormBasedAuth;
    }

    public void setUseSsl(boolean useSsl) {
        this.useSsl = useSsl;
    }

    private RemoteConfiguration(RemoteConfiguration config) {
        this.connectionFactory = config.connectionFactory;
        this.deploymentId = config.deploymentId;
        this.extraJaxbClasses = config.extraJaxbClasses;
        this.jmsSerializationType = config.jmsSerializationType;
        this.ksessionQueue = config.ksessionQueue;
        this.password = config.password;
        this.processInstanceId = config.processInstanceId;
        this.responseQueue = config.responseQueue;
        this.requestFactory = config.requestFactory;
        this.taskQueue = config.taskQueue;
        this.timeout = config.timeout;
        this.type = config.type;
        this.useFormBasedAuth = config.useFormBasedAuth;
        this.userName = config.userName;
        this.useSsl = config.useSsl;
    }

    public RemoteConfiguration clone() {
        return new RemoteConfiguration(this);
    }

    public static enum Type {
        REST,
        JMS,
        CONSTRUCTOR;

    }

    static class PreemptiveAuth
    implements HttpRequestInterceptor {
        private final String contextId;

        public PreemptiveAuth(String contextId) {
            this.contextId = contextId;
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
            if (authState.getAuthScheme() == null) {
                AuthScheme authScheme = (AuthScheme)context.getAttribute(this.contextId);
                CredentialsProvider credsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
                HttpHost targetHost = (HttpHost)context.getAttribute("http.target_host");
                if (authScheme != null) {
                    Credentials creds = credsProvider.getCredentials(new AuthScope(targetHost.getHostName(), targetHost.getPort()));
                    if (creds == null) {
                        throw new HttpException("No credentials for preemptive authentication");
                    }
                    authState.update(authScheme, creds);
                }
            }
        }
    }

    static class FormBasedAuthenticatingInterceptor
    implements ClientExecutionInterceptor {
        private static final Logger logger = LoggerFactory.getLogger(FormBasedAuthenticatingInterceptor.class);
        private static final String LOGIN_FORM = "/uf_security_check";
        private static final String FORM_BASED_AUTH_PROPERTY = "org.kie.remote.form.based.auth";
        private final String username;
        private final String password;
        private String sessionCookie = null;

        public FormBasedAuthenticatingInterceptor(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public ClientResponse<?> execute(ClientExecutionContext ctx) throws Exception {
            ClientRequest origRequest = ctx.getRequest();
            if (this.sessionCookie != null) {
                origRequest.header("Cookie", (Object)this.sessionCookie);
            }
            URL restUrl = new URL(origRequest.getUri());
            String restUrlString = restUrl.toExternalForm();
            String origRequestMethod = origRequest.getHttpMethod();
            this.debug("Processing request: [" + origRequestMethod + "] " + restUrlString + (this.sessionCookie == null ? "" : " (session: " + this.sessionCookie + ")"));
            ClientResponse response = ctx.proceed();
            int status = response.getStatus();
            this.debug("Response received [" + status + "]");
            if (restUrlString.endsWith(LOGIN_FORM) || Boolean.parseBoolean((String)origRequest.getAttributes().get(FORM_BASED_AUTH_PROPERTY))) {
                return response;
            }
            String requestCookie = (String)response.getHeaders().getFirst((Object)"Set-Cookie");
            Object contentTypeObj = response.getHeaders().getFirst((Object)"Content-Type");
            boolean doFormBasedAuth = false;
            if (contentTypeObj != null && contentTypeObj instanceof String && ((String)contentTypeObj).startsWith("text/html") && requestCookie != null && !requestCookie.equals(this.sessionCookie)) {
                this.debug("New session cookie: " + requestCookie);
                doFormBasedAuth = true;
                this.sessionCookie = requestCookie;
            }
            if (doFormBasedAuth) {
                response.releaseConnection();
                String appBase = "/" + restUrl.getPath().substring(1).replaceAll("/.*", "");
                URL appBaseUrl = new URL(restUrl.getProtocol(), restUrl.getHost(), restUrl.getPort(), appBase);
                ClientRequestFactory requestFactory = new ClientRequestFactory(appBaseUrl.toURI());
                ClientRequest formRequest = requestFactory.createRelativeRequest(LOGIN_FORM);
                formRequest = formRequest.formParameter("uf_username", (Object)this.username).formParameter("uf_password", (Object)this.password);
                if (this.sessionCookie != null) {
                    formRequest.header("Cookie", (Object)this.sessionCookie);
                }
                try {
                    this.debug("Trying form-based authentication for session '" + this.sessionCookie + "'");
                    response = formRequest.post();
                    int formRequestStatus = response.getStatus();
                    if (formRequestStatus != 302) {
                        String errMsg = "Unable to complete form-based authentication in via " + formRequest.getUri();
                        System.err.println(errMsg + "\n [" + formRequestStatus + "] " + (String)response.getEntity(String.class));
                        throw new RemoteCommunicationException(errMsg + " (see output)");
                    }
                    this.debug("Form-based authentication succeeded.");
                }
                catch (RemoteCommunicationException rce) {
                    throw rce;
                }
                catch (Exception e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    String errMsg = "Unable to complete form-based authentication in via " + formRequest.getUri();
                    throw new RemoteCommunicationException(errMsg, e);
                }
                finally {
                    try {
                        response.releaseConnection();
                    }
                    catch (Exception e) {}
                }
                try {
                    if (this.sessionCookie == null) {
                        throw new IllegalStateException("A cookie for a authenticated session should be available at this point!");
                    }
                    this.debug("Retrying original request (proceed): [" + origRequestMethod + "] " + restUrlString);
                    response = ctx.proceed();
                }
                catch (Exception e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RemoteCommunicationException("Unable to " + origRequestMethod + " to " + restUrlString, e);
                }
            }
            return response;
        }

        private void debug(String msg) {
            logger.debug(msg);
        }
    }

    static class FormBasedAuthenticatingClientRequestFactory
    extends ClientRequestFactory {
        private final String username;
        private final String password;
        private final ClientExecutor executor;

        public FormBasedAuthenticatingClientRequestFactory(URI uri, String username, String password, int timeout) {
            super(uri);
            this.username = username;
            this.password = password;
            DefaultHttpClient httpClient = new DefaultHttpClient();
            HttpParams params = httpClient.getParams();
            HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)(timeout * 1000));
            HttpConnectionParams.setSoTimeout((HttpParams)params, (int)(timeout * 1000));
            this.executor = new ApacheHttpClient4Executor((HttpClient)httpClient);
        }

        public ClientRequest createRelativeRequest(String uriTemplate) {
            ClientRequest request = this.executor.createRequest(this.getBase().toString() + uriTemplate);
            request.registerInterceptor((Object)new FormBasedAuthenticatingInterceptor(this.username, this.password));
            return request;
        }

        public ClientRequest createRequest(String uriTemplate) {
            ClientRequest request = this.executor.createRequest(uriTemplate);
            request.registerInterceptor((Object)new FormBasedAuthenticatingInterceptor(this.username, this.password));
            return request;
        }
    }
}

