/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.date;

import java.util.Date;
import org.dashbuilder.dataset.date.Month;
import org.dashbuilder.dataset.date.Quarter;
import org.dashbuilder.dataset.date.TimeAmount;
import org.dashbuilder.dataset.group.DateIntervalType;

public class TimeInstant {
    private TimeMode timeMode = null;
    private DateIntervalType intervalType = DateIntervalType.YEAR;
    private Month firstMonthOfYear = Month.JANUARY;
    private TimeAmount timeAmount = null;
    private transient Date startTime = null;
    public static Date START_TIME = null;

    public TimeInstant() {
        this(TimeMode.NOW, DateIntervalType.YEAR, Month.JANUARY, null);
    }

    public TimeInstant(TimeMode timeMode, DateIntervalType intervalType, Month firstMonthOfYear, TimeAmount timeAmount) {
        this.timeMode = timeMode;
        this.intervalType = intervalType;
        this.firstMonthOfYear = firstMonthOfYear;
        this.timeAmount = timeAmount;
    }

    public TimeMode getTimeMode() {
        return this.timeMode;
    }

    public void setTimeMode(TimeMode timeMode) {
        this.timeMode = timeMode;
    }

    public DateIntervalType getIntervalType() {
        return this.intervalType;
    }

    public void setIntervalType(DateIntervalType intervalType) {
        this.intervalType = intervalType;
    }

    public Month getFirstMonthOfYear() {
        return this.firstMonthOfYear;
    }

    public void setFirstMonthOfYear(Month firstMonthOfYear) {
        this.firstMonthOfYear = firstMonthOfYear;
    }

    public TimeAmount getTimeAmount() {
        return this.timeAmount;
    }

    public void setTimeAmount(TimeAmount timeAmount) {
        this.timeAmount = timeAmount;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        if (this.timeMode != null) {
            out.append(this.timeMode.name().toLowerCase());
            if (!TimeMode.NOW.equals((Object)this.timeMode)) {
                out.append("[").append(this.intervalType.name().toLowerCase());
                if (this.intervalType != null && this.intervalType.getIndex() > DateIntervalType.MONTH.getIndex() && this.firstMonthOfYear != null) {
                    out.append(" ").append(this.firstMonthOfYear.name().toLowerCase());
                }
                out.append("]");
            }
        }
        if (this.timeAmount != null && this.timeAmount.getQuantity() != 0L) {
            if (out.length() > 0) {
                out.append(" ");
            }
            out.append(this.timeAmount);
        }
        if (out.length() == 0) {
            out.append(TimeMode.NOW.name().toLowerCase());
        }
        return out.toString();
    }

    public TimeInstant cloneInstance() {
        TimeInstant clone = new TimeInstant();
        clone.timeMode = this.timeMode;
        clone.intervalType = this.intervalType;
        clone.firstMonthOfYear = this.firstMonthOfYear;
        if (this.timeAmount != null) {
            clone.timeAmount = this.timeAmount.cloneInstance();
        }
        return clone;
    }

    public Date getTimeInstant() {
        Date _start = this.calculateStartTime();
        if (this.timeAmount != null) {
            this.timeAmount.adjustDate(_start);
        }
        return _start;
    }

    public void setStartTime(Date now) {
        this.startTime = now;
    }

    public Date getStartTime() {
        if (this.startTime == null) {
            if (START_TIME != null) {
                return new Date(START_TIME.getTime());
            }
            return new Date();
        }
        return new Date(this.startTime.getTime());
    }

    protected Date calculateStartTime() {
        int yearInc;
        int firstMonth;
        int month;
        int inc;
        int base;
        Date startDate = this.getStartTime();
        if (this.timeMode == null || TimeMode.NOW.equals((Object)this.timeMode)) {
            return startDate;
        }
        if (DateIntervalType.MILLENIUM.equals((Object)this.intervalType)) {
            base = startDate.getYear() / 1000;
            inc = TimeMode.END.equals((Object)this.timeMode) ? 1 : 0;
            startDate.setYear((base + inc) * 1000);
            startDate.setMonth(this.firstMonthOfYear.getIndex() - 1);
            startDate.setDate(1);
            startDate.setHours(0);
            startDate.setMinutes(0);
            startDate.setSeconds(0);
        }
        if (DateIntervalType.CENTURY.equals((Object)this.intervalType)) {
            base = startDate.getYear() / 100;
            inc = TimeMode.END.equals((Object)this.timeMode) ? 1 : 0;
            startDate.setYear((base + inc) * 100);
            startDate.setMonth(this.firstMonthOfYear.getIndex() - 1);
            startDate.setDate(1);
            startDate.setHours(0);
            startDate.setMinutes(0);
            startDate.setSeconds(0);
        }
        if (DateIntervalType.DECADE.equals((Object)this.intervalType)) {
            base = startDate.getYear() / 10;
            inc = TimeMode.END.equals((Object)this.timeMode) ? 1 : 0;
            startDate.setYear((base + inc) * 10);
            startDate.setMonth(this.firstMonthOfYear.getIndex() - 1);
            startDate.setDate(1);
            startDate.setHours(0);
            startDate.setMinutes(0);
            startDate.setSeconds(0);
        }
        if (DateIntervalType.YEAR.equals((Object)this.intervalType)) {
            month = startDate.getMonth();
            firstMonth = this.firstMonthOfYear.getIndex() - 1;
            yearInc = 0;
            yearInc = TimeMode.BEGIN.equals((Object)this.timeMode) ? (month < firstMonth ? -1 : 0) : (month < firstMonth ? 0 : 1);
            startDate.setYear(startDate.getYear() + yearInc);
            startDate.setMonth(firstMonth);
            startDate.setDate(1);
            startDate.setHours(0);
            startDate.setMinutes(0);
            startDate.setSeconds(0);
        }
        if (DateIntervalType.QUARTER.equals((Object)this.intervalType)) {
            month = startDate.getMonth();
            firstMonth = Quarter.getQuarterFirstMonth(this.firstMonthOfYear.getIndex(), month + 1) - 1;
            yearInc = 0;
            int monthInc = 3;
            if (TimeMode.BEGIN.equals((Object)this.timeMode)) {
                yearInc = firstMonth > month ? -1 : 0;
                monthInc = 0;
            }
            startDate.setYear(startDate.getYear() + yearInc);
            startDate.setMonth(firstMonth + monthInc);
            startDate.setDate(1);
            startDate.setHours(0);
            startDate.setMinutes(0);
            startDate.setSeconds(0);
        }
        if (DateIntervalType.MONTH.equals((Object)this.intervalType)) {
            startDate.setDate(1);
            startDate.setHours(0);
            startDate.setMinutes(0);
            startDate.setSeconds(0);
            if (TimeMode.END.equals((Object)this.timeMode)) {
                startDate.setMonth(startDate.getMonth() + 1);
            }
        }
        if (DateIntervalType.DAY.equals((Object)this.intervalType)) {
            startDate.setHours(0);
            startDate.setMinutes(0);
            startDate.setSeconds(0);
            if (TimeMode.END.equals((Object)this.timeMode)) {
                startDate.setDate(startDate.getDate() + 1);
            }
        }
        if (DateIntervalType.HOUR.equals((Object)this.intervalType)) {
            startDate.setMinutes(0);
            startDate.setSeconds(0);
            if (TimeMode.END.equals((Object)this.timeMode)) {
                startDate.setHours(startDate.getHours() + 1);
            }
        }
        if (DateIntervalType.MINUTE.equals((Object)this.intervalType)) {
            startDate.setSeconds(0);
            if (TimeMode.END.equals((Object)this.timeMode)) {
                startDate.setMinutes(startDate.getMinutes() + 1);
            }
        }
        return startDate;
    }

    public static TimeInstant now() {
        return new TimeInstant();
    }

    public static TimeInstant parse(String timeInstantExpr) {
        if (timeInstantExpr == null || timeInstantExpr.length() == 0) {
            throw new IllegalArgumentException("Empty time instant expression");
        }
        TimeInstant instant = new TimeInstant();
        String expr = timeInstantExpr.toLowerCase().trim();
        boolean begin = expr.startsWith("begin");
        boolean end = expr.startsWith("end");
        if (!begin && !end) {
            if (expr.startsWith("now")) {
                instant.setTimeMode(TimeMode.NOW);
                if (expr.length() > 3) {
                    instant.setTimeAmount(TimeAmount.parse(expr.substring(3)));
                }
            } else {
                instant.setTimeMode(null);
                instant.setTimeAmount(TimeAmount.parse(expr));
            }
            return instant;
        }
        instant.setTimeMode(begin ? TimeMode.BEGIN : TimeMode.END);
        String example = begin ? "begin[year March]" : "end[year March]";
        int bracesBegin = expr.indexOf(91);
        int bracesEnd = expr.indexOf(93);
        if (bracesBegin == -1 || bracesEnd == -1 || bracesBegin >= bracesEnd) {
            throw new IllegalArgumentException("Missing braces (ex '" + example + "'):  " + timeInstantExpr);
        }
        String[] intervalTerms = expr.substring(bracesBegin + 1, bracesEnd).split("\\s+");
        if (intervalTerms.length > 2) {
            throw new IllegalArgumentException("Too many settings (ex '" + example + "'):  " + timeInstantExpr);
        }
        instant.setIntervalType(DateIntervalType.getByName(intervalTerms[0]));
        if (instant.getIntervalType() == null) {
            throw new IllegalArgumentException("Invalid interval (ex '" + example + "'): " + timeInstantExpr);
        }
        if (intervalTerms.length == 2) {
            instant.setFirstMonthOfYear(Month.getByName(intervalTerms[1]));
            if (instant.getFirstMonthOfYear() == null) {
                throw new IllegalArgumentException("Invalid first year month (ex '" + example + "'): " + timeInstantExpr);
            }
        }
        if (bracesEnd < expr.length() && !(expr = expr.substring(bracesEnd + 1).trim()).isEmpty()) {
            TimeAmount timeAmount = TimeAmount.parse(expr);
            instant.setTimeAmount(timeAmount);
        }
        return instant;
    }

    public static enum TimeMode {
        NOW,
        BEGIN,
        END;

        private static final TimeMode[] modes;

        public int getIndex() {
            return this.ordinal();
        }

        public static TimeMode getByName(String name) {
            try {
                return TimeMode.valueOf(name.toUpperCase());
            }
            catch (Exception e) {
                return null;
            }
        }

        public static TimeMode getByIndex(int index) {
            return modes[index];
        }

        static {
            modes = TimeMode.values();
        }
    }
}

