/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.sort;

public enum SortOrder {
    ASCENDING,
    DESCENDING,
    UNSPECIFIED;

    private static final String ASC = "asc";
    private static final String DESC = "desc";

    public int asInt() {
        switch (this) {
            case ASCENDING: {
                return 1;
            }
            case DESCENDING: {
                return -1;
            }
        }
        return 0;
    }

    public static SortOrder getByName(String str) {
        try {
            if (ASC.equals(str)) {
                return ASCENDING;
            }
            if (DESC.equals(str)) {
                return DESCENDING;
            }
            return SortOrder.valueOf(str.toUpperCase());
        }
        catch (Exception e) {
            return null;
        }
    }

    public SortOrder reverse() {
        switch (this) {
            case ASCENDING: {
                return DESCENDING;
            }
            case DESCENDING: {
                return ASCENDING;
            }
        }
        return UNSPECIFIED;
    }
}

