/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.codegenfactories;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import org.kie.pmml.api.enums.CAST_INTEGER;
import org.kie.pmml.api.enums.OP_TYPE;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.commons.model.KiePMMLTarget;
import org.kie.pmml.commons.model.KiePMMLTargetValue;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLTargetValueFactory;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;

public class KiePMMLTargetFactory {
    static final String KIE_PMML_TARGET_TEMPLATE_JAVA = "KiePMMLTargetTemplate.tmpl";
    static final String KIE_PMML_TARGET_TEMPLATE = "KiePMMLTargetTemplate";
    static final String GETKIEPMMLTARGET = "getKiePMMLTarget";
    static final String TARGET = "target";
    static final ClassOrInterfaceDeclaration TARGET_TEMPLATE;

    private KiePMMLTargetFactory() {
    }

    static MethodCallExpr getKiePMMLTargetVariableInitializer(KiePMMLTarget kiepmmlTargetField) {
        MethodDeclaration methodDeclaration = ((MethodDeclaration)TARGET_TEMPLATE.getMethodsByName(GETKIEPMMLTARGET).get(0)).clone();
        BlockStmt targetBody = (BlockStmt)methodDeclaration.getBody().orElseThrow(() -> new KiePMMLException(String.format("Missing body in %s", methodDeclaration)));
        VariableDeclarator variableDeclarator = CommonCodegenUtils.getVariableDeclarator(targetBody, TARGET).orElseThrow(() -> new KiePMMLException(String.format("Missing expected variable '%s' in body %s", TARGET, targetBody)));
        variableDeclarator.setName(kiepmmlTargetField.getName());
        MethodCallExpr toReturn = ((Expression)variableDeclarator.getInitializer().orElseThrow(() -> new KiePMMLException(String.format("Missing '%s' initializer in %s", TARGET, targetBody)))).asMethodCallExpr();
        MethodCallExpr builder = CommonCodegenUtils.getChainedMethodCallExprFrom("builder", toReturn);
        StringLiteralExpr nameExpr = new StringLiteralExpr(kiepmmlTargetField.getName());
        builder.setArgument(0, (Expression)nameExpr);
        NodeList arguments = new NodeList();
        if (kiepmmlTargetField.getTargetValues() != null) {
            for (KiePMMLTargetValue targetValue : kiepmmlTargetField.getTargetValues()) {
                arguments.add((Node)KiePMMLTargetValueFactory.getKiePMMLTargetValueVariableInitializer(targetValue));
            }
        }
        CommonCodegenUtils.getChainedMethodCallExprFrom("asList", toReturn).setArguments(arguments);
        OP_TYPE oPT = kiepmmlTargetField.getOpType();
        NameExpr opType = oPT != null ? new NameExpr(oPT.getClass().getName() + "." + oPT.name()) : new NullLiteralExpr();
        CommonCodegenUtils.getChainedMethodCallExprFrom("withOpType", toReturn).setArgument(0, (Expression)opType);
        CommonCodegenUtils.getChainedMethodCallExprFrom("withField", toReturn).setArgument(0, CommonCodegenUtils.getExpressionForObject(kiepmmlTargetField.getField()));
        CAST_INTEGER cstInt = kiepmmlTargetField.getCastInteger();
        NameExpr castInteger = cstInt != null ? new NameExpr(cstInt.getClass().getName() + "." + cstInt.name()) : new NullLiteralExpr();
        CommonCodegenUtils.getChainedMethodCallExprFrom("withCastInteger", toReturn).setArgument(0, (Expression)castInteger);
        CommonCodegenUtils.getChainedMethodCallExprFrom("withMin", toReturn).setArgument(0, CommonCodegenUtils.getExpressionForObject(kiepmmlTargetField.getMin()));
        CommonCodegenUtils.getChainedMethodCallExprFrom("withMax", toReturn).setArgument(0, CommonCodegenUtils.getExpressionForObject(kiepmmlTargetField.getMax()));
        CommonCodegenUtils.getChainedMethodCallExprFrom("withRescaleConstant", toReturn).setArgument(0, CommonCodegenUtils.getExpressionForObject(kiepmmlTargetField.getRescaleConstant()));
        CommonCodegenUtils.getChainedMethodCallExprFrom("withRescaleFactor", toReturn).setArgument(0, CommonCodegenUtils.getExpressionForObject(kiepmmlTargetField.getRescaleFactor()));
        return toReturn;
    }

    static {
        CompilationUnit cloneCU = JavaParserUtils.getFromFileName(KIE_PMML_TARGET_TEMPLATE_JAVA);
        TARGET_TEMPLATE = (ClassOrInterfaceDeclaration)cloneCU.getClassByName(KIE_PMML_TARGET_TEMPLATE).orElseThrow(() -> new KiePMMLException("Main class not found: KiePMMLTargetTemplate"));
        ((MethodDeclaration)TARGET_TEMPLATE.getMethodsByName(GETKIEPMMLTARGET).get(0)).clone();
    }
}

