/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.compat;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.kitesdk.compat.DynMethods;

public class DynConstructors {

    private static class MakeAccessible
    implements PrivilegedAction<Void> {
        private Constructor<?> hidden;

        public MakeAccessible(Constructor<?> hidden) {
            this.hidden = hidden;
        }

        @Override
        public Void run() {
            this.hidden.setAccessible(true);
            return null;
        }
    }

    public static class Builder {
        private final Class<?> baseClass;
        private ClassLoader loader = Thread.currentThread().getContextClassLoader();
        private Ctor ctor = null;

        public Builder(Class<?> baseClass) {
            this.baseClass = baseClass;
        }

        public Builder() {
            this.baseClass = null;
        }

        public Builder loader(ClassLoader loader) {
            this.loader = loader;
            return this;
        }

        public Builder impl(Class<?> ... types) {
            this.impl((Class<T>)this.baseClass, types);
            return this;
        }

        public Builder impl(String className, Class<?> ... types) {
            if (this.ctor != null) {
                return this;
            }
            try {
                Class<?> targetClass = Class.forName(className, true, this.loader);
                this.impl((Class<T>)targetClass, types);
            }
            catch (NoClassDefFoundError e) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return this;
        }

        public <T> Builder impl(Class<T> targetClass, Class<?> ... types) {
            if (this.ctor != null) {
                return this;
            }
            try {
                this.ctor = new Ctor(targetClass.getConstructor(types), targetClass);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            return this;
        }

        public Builder hiddenImpl(Class<?> ... types) {
            this.hiddenImpl((Class<T>)this.baseClass, types);
            return this;
        }

        public Builder hiddenImpl(String className, Class<?> ... types) {
            if (this.ctor != null) {
                return this;
            }
            try {
                Class<?> targetClass = Class.forName(className, true, this.loader);
                this.hiddenImpl((Class<T>)targetClass, types);
            }
            catch (NoClassDefFoundError e) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return this;
        }

        public <T> Builder hiddenImpl(Class<T> targetClass, Class<?> ... types) {
            if (this.ctor != null) {
                return this;
            }
            try {
                Constructor<T> hidden = targetClass.getDeclaredConstructor(types);
                AccessController.doPrivileged(new MakeAccessible(hidden));
                this.ctor = new Ctor(hidden, targetClass);
            }
            catch (SecurityException e) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            return this;
        }

        public <C> Ctor<C> buildChecked() throws NoSuchMethodException {
            if (this.ctor != null) {
                return this.ctor;
            }
            throw new NoSuchMethodException("Cannot find constructor for " + this.baseClass);
        }

        public <C> Ctor<C> build() {
            if (this.ctor != null) {
                return this.ctor;
            }
            throw new RuntimeException("Cannot find constructor for " + this.baseClass);
        }
    }

    public static class Ctor<C>
    extends DynMethods.UnboundMethod {
        private final Constructor<C> ctor;
        private final Class<? extends C> constructed;

        private Ctor(Constructor<C> constructor, Class<? extends C> constructed) {
            super(null, "newInstance");
            this.ctor = constructor;
            this.constructed = constructed;
        }

        public Class<? extends C> getConstructedClass() {
            return this.constructed;
        }

        public C newInstanceChecked(Object ... args) throws Exception {
            try {
                return this.ctor.newInstance(args);
            }
            catch (InstantiationException e) {
                throw e;
            }
            catch (IllegalAccessException e) {
                throw e;
            }
            catch (InvocationTargetException e) {
                Throwables.propagateIfPossible((Throwable)e.getCause(), Exception.class);
                throw Throwables.propagate((Throwable)e.getCause());
            }
        }

        public C newInstance(Object ... args) {
            try {
                return this.newInstanceChecked(args);
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        @Override
        public <R> R invoke(Object target, Object ... args) {
            Preconditions.checkArgument((target == null ? 1 : 0) != 0, (Object)"Invalid call to constructor: target must be null");
            return (R)this.newInstance(target, args);
        }

        @Override
        public <R> R invokeChecked(Object target, Object ... args) throws Exception {
            Preconditions.checkArgument((target == null ? 1 : 0) != 0, (Object)"Invalid call to constructor: target must be null");
            return (R)this.newInstanceChecked(args);
        }

        @Override
        public boolean isStatic() {
            return true;
        }

        @Override
        public String toString() {
            return Objects.toStringHelper((Object)this).add("constructor", this.ctor).add("class", this.constructed).toString();
        }
    }
}

