/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.avro;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.typesafe.config.Config;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericContainer;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericEnumSymbol;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.util.Utf8;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.CommandBuilder;
import org.kitesdk.morphline.api.MorphlineCompilationException;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.api.MorphlineRuntimeException;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.base.AbstractCommand;
import org.kitesdk.morphline.base.Configs;

public final class ExtractAvroPathsBuilder
implements CommandBuilder {
    public Collection<String> getNames() {
        return Collections.singletonList("extractAvroPaths");
    }

    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new ExtractAvroPaths(this, config, parent, child, context);
    }

    private static final class ExtractAvroPaths
    extends AbstractCommand {
        private final boolean flatten;
        private final Map<String, Collection<String>> stepMap;
        private static final String ARRAY_TOKEN = "[]";

        public ExtractAvroPaths(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
            ArrayListMultimap stepMultiMap = ArrayListMultimap.create();
            this.flatten = this.getConfigs().getBoolean(config, "flatten", true);
            Config paths = this.getConfigs().getConfig(config, "paths");
            for (Map.Entry entry : new Configs().getEntrySet(paths)) {
                String fieldName = (String)entry.getKey();
                String path = entry.getValue().toString().trim();
                if (path.contains("//")) {
                    throw new MorphlineCompilationException("No support for descendant axis available yet", config);
                }
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                if (path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                path = path.trim();
                for (String step : path.split("/")) {
                    if ((step = step.trim()).length() > ARRAY_TOKEN.length() && step.endsWith(ARRAY_TOKEN)) {
                        step = step.substring(0, step.length() - ARRAY_TOKEN.length());
                        stepMultiMap.put((Object)fieldName, (Object)this.normalize(step));
                        stepMultiMap.put((Object)fieldName, (Object)ARRAY_TOKEN);
                        continue;
                    }
                    stepMultiMap.put((Object)fieldName, (Object)this.normalize(step));
                }
            }
            this.stepMap = stepMultiMap.asMap();
            this.LOG.debug("stepMap: {}", this.stepMap);
            this.validateArguments();
        }

        private String normalize(String step) {
            return ARRAY_TOKEN.equals(step) ? ARRAY_TOKEN : step;
        }

        protected boolean doProcess(Record inputRecord) {
            GenericContainer datum = (GenericContainer)inputRecord.getFirstValue("_attachment_body");
            Preconditions.checkNotNull((Object)datum);
            Preconditions.checkNotNull((Object)datum.getSchema());
            Record outputRecord = inputRecord.copy();
            for (Map.Entry<String, Collection<String>> entry : this.stepMap.entrySet()) {
                String fieldName = entry.getKey();
                List steps = (List)entry.getValue();
                this.extractPath(datum, datum.getSchema(), fieldName, steps, outputRecord, 0);
            }
            return this.getChild().process(outputRecord);
        }

        private void extractPath(Object datum, Schema schema, String fieldName, List<String> steps, Record record, int level) {
            if (level >= steps.size()) {
                return;
            }
            boolean isLeaf = level + 1 == steps.size();
            String step = steps.get(level);
            if (ARRAY_TOKEN == step) {
                if (schema.getType() == Schema.Type.ARRAY) {
                    if (isLeaf) {
                        this.resolve(datum, schema, record, fieldName);
                    } else {
                        Iterator iter = ((Collection)datum).iterator();
                        while (iter.hasNext()) {
                            this.extractPath(iter.next(), schema.getElementType(), fieldName, steps, record, level + 1);
                        }
                    }
                }
            } else if (schema.getType() == Schema.Type.RECORD) {
                GenericRecord genericAvroRecord = (GenericRecord)datum;
                Object value = genericAvroRecord.get(step);
                if (value != null) {
                    Schema childSchema = schema.getField(step).schema();
                    if (isLeaf) {
                        this.resolve(value, childSchema, record, fieldName);
                    } else {
                        this.extractPath(value, childSchema, fieldName, steps, record, level + 1);
                    }
                }
            } else if (schema.getType() == Schema.Type.MAP) {
                Map map = (Map)datum;
                Object value = map.get(step);
                if (value == null) {
                    value = map.get(new Utf8(step));
                }
                if (value != null) {
                    Schema childSchema = schema.getValueType();
                    if (isLeaf) {
                        this.resolve(value, childSchema, record, fieldName);
                    } else {
                        this.extractPath(value, childSchema, fieldName, steps, record, level + 1);
                    }
                }
            } else if (schema.getType() == Schema.Type.UNION) {
                int index = GenericData.get().resolveUnion(schema, datum);
                this.extractPath(datum, (Schema)schema.getTypes().get(index), fieldName, steps, record, level);
            }
        }

        private void resolve(Object datum, Schema schema, Record record, String fieldName) {
            if (datum == null) {
                return;
            }
            if (this.flatten) {
                this.flatten(datum, schema, record.get(fieldName));
                return;
            }
            switch (schema.getType()) {
                case RECORD: {
                    record.put(fieldName, datum);
                    break;
                }
                case ENUM: {
                    GenericEnumSymbol symbol = (GenericEnumSymbol)datum;
                    record.put(fieldName, (Object)symbol.toString());
                    break;
                }
                case ARRAY: {
                    record.put(fieldName, datum);
                    break;
                }
                case MAP: {
                    record.put(fieldName, datum);
                    break;
                }
                case UNION: {
                    record.put(fieldName, this.normalizeUtf8(datum));
                    break;
                }
                case FIXED: {
                    GenericFixed fixed = (GenericFixed)datum;
                    record.put(fieldName, (Object)fixed.bytes());
                    break;
                }
                case BYTES: {
                    ByteBuffer buf = (ByteBuffer)datum;
                    int pos = buf.position();
                    byte[] bytes = new byte[buf.remaining()];
                    buf.get(bytes);
                    buf.position(pos);
                    record.put(fieldName, (Object)bytes);
                    break;
                }
                case STRING: {
                    record.put(fieldName, (Object)datum.toString());
                    break;
                }
                case INT: {
                    record.put(fieldName, datum);
                    break;
                }
                case LONG: {
                    record.put(fieldName, datum);
                    break;
                }
                case FLOAT: {
                    record.put(fieldName, datum);
                    break;
                }
                case DOUBLE: {
                    record.put(fieldName, datum);
                    break;
                }
                case BOOLEAN: {
                    record.put(fieldName, datum);
                    break;
                }
                case NULL: {
                    break;
                }
                default: {
                    throw new MorphlineRuntimeException("Unknown Avro schema type: " + schema.getType());
                }
            }
        }

        private Object normalizeUtf8(Object datum) {
            if (datum instanceof Utf8) {
                return ((Utf8)datum).toString();
            }
            return datum;
        }

        private void flatten(Object datum, Schema schema, List list) {
            if (datum == null) {
                return;
            }
            switch (schema.getType()) {
                case RECORD: {
                    IndexedRecord avroRecord = (IndexedRecord)datum;
                    for (Schema.Field field : schema.getFields()) {
                        this.flatten(avroRecord.get(field.pos()), field.schema(), list);
                    }
                    break;
                }
                case ENUM: {
                    GenericEnumSymbol symbol = (GenericEnumSymbol)datum;
                    list.add(symbol.toString());
                    break;
                }
                case ARRAY: {
                    Iterator iter = ((Collection)datum).iterator();
                    while (iter.hasNext()) {
                        this.flatten(iter.next(), schema.getElementType(), list);
                    }
                    break;
                }
                case MAP: {
                    Map map = (Map)datum;
                    for (Map.Entry entry : map.entrySet()) {
                        this.flatten(entry.getValue(), schema.getValueType(), list);
                    }
                    break;
                }
                case UNION: {
                    int index = GenericData.get().resolveUnion(schema, datum);
                    this.flatten(datum, (Schema)schema.getTypes().get(index), list);
                    break;
                }
                case FIXED: {
                    GenericFixed fixed = (GenericFixed)datum;
                    list.add(fixed.bytes());
                    break;
                }
                case BYTES: {
                    ByteBuffer buf = (ByteBuffer)datum;
                    int pos = buf.position();
                    byte[] bytes = new byte[buf.remaining()];
                    buf.get(bytes);
                    buf.position(pos);
                    list.add(bytes);
                    break;
                }
                case STRING: {
                    list.add(datum.toString());
                    break;
                }
                case INT: {
                    list.add(datum);
                    break;
                }
                case LONG: {
                    list.add(datum);
                    break;
                }
                case FLOAT: {
                    list.add(datum);
                    break;
                }
                case DOUBLE: {
                    list.add(datum);
                    break;
                }
                case BOOLEAN: {
                    list.add(datum);
                    break;
                }
                case NULL: {
                    break;
                }
                default: {
                    throw new MorphlineRuntimeException("Unknown Avro schema type: " + schema.getType());
                }
            }
        }
    }
}

