/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.api;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.kitesdk.morphline.api.CommandBuilder;
import org.kitesdk.morphline.api.ExceptionHandler;
import org.kitesdk.morphline.api.MorphlineRuntimeException;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.shaded.com.google.common.reflect.ClassPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MorphlineContext {
    private ExceptionHandler exceptionHandler;
    private MetricRegistry metricRegistry;
    private HealthCheckRegistry healthCheckRegistry;
    private Map<String, Class<CommandBuilder>> commandBuilders = Collections.emptyMap();
    private static final Logger LOG = LoggerFactory.getLogger(MorphlineContext.class);

    protected MorphlineContext() {
    }

    public ExceptionHandler getExceptionHandler() {
        assert (this.exceptionHandler != null);
        return this.exceptionHandler;
    }

    public MetricRegistry getMetricRegistry() {
        assert (this.metricRegistry != null);
        return this.metricRegistry;
    }

    public HealthCheckRegistry getHealthCheckRegistry() {
        assert (this.healthCheckRegistry != null);
        return this.healthCheckRegistry;
    }

    public Class<CommandBuilder> getCommandBuilder(String builderName) {
        return this.commandBuilders.get(builderName);
    }

    public void importCommandBuilders(Collection<String> importSpecs) {
        if (this.commandBuilders == Collections.EMPTY_MAP) {
            this.commandBuilders = Maps.newHashMap();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Importing commands from Java classpath: {}", (Object)System.getProperty("java.class.path"));
            } else {
                LOG.info("Importing commands");
            }
            Collection<Class<CommandBuilder>> builderClasses = this.getTopLevelClasses(importSpecs, CommandBuilder.class);
            for (Class<CommandBuilder> builderClass : builderClasses) {
                try {
                    CommandBuilder builder = builderClass.newInstance();
                    for (String builderName : builder.getNames()) {
                        LOG.debug("Importing command: {} from class: {}", (Object)builderName, (Object)builderClass.getName());
                        if (builderName.contains(".")) {
                            LOG.warn("Command name should not contain a period character: " + builderName);
                        }
                        this.commandBuilders.put(builderName, builderClass);
                    }
                }
                catch (Exception e) {
                    throw new MorphlineRuntimeException(e);
                }
            }
            LOG.info("Done importing commands");
        }
    }

    @VisibleForTesting
    <T> Collection<Class<T>> getTopLevelClasses(Collection<String> importSpecs, Class<T> iface) {
        int fqcnCount = 0;
        for (String importSpec : importSpecs) {
            if (importSpec.endsWith(".*") || importSpec.endsWith(".**")) continue;
            ++fqcnCount;
        }
        LinkedHashMap classes = Maps.newLinkedHashMap();
        for (ClassLoader loader : this.getClassLoaders()) {
            ClassPath classPath;
            if (importSpecs.size() == fqcnCount) {
                for (String importSpec : importSpecs) {
                    Class<?> clazz;
                    try {
                        clazz = loader.loadClass(importSpec);
                    }
                    catch (ClassNotFoundException e) {
                        continue;
                    }
                    this.addClass(clazz, classes, iface);
                }
                continue;
            }
            try {
                classPath = ClassPath.from(loader);
            }
            catch (IOException e) {
                continue;
            }
            for (String importSpec : importSpecs) {
                String packageName;
                ImmutableSet<ClassPath.ClassInfo> classInfos = null;
                if (importSpec.endsWith(".**")) {
                    packageName = importSpec.substring(0, importSpec.length() - ".**".length());
                    classInfos = classPath.getTopLevelClassesRecursive(packageName);
                } else if (importSpec.endsWith(".*")) {
                    packageName = importSpec.substring(0, importSpec.length() - ".*".length());
                    classInfos = classPath.getTopLevelClasses(packageName);
                } else {
                    Class<?> clazz;
                    try {
                        clazz = loader.loadClass(importSpec);
                    }
                    catch (ClassNotFoundException e) {
                        continue;
                    }
                    this.addClass(clazz, classes, iface);
                    continue;
                }
                for (ClassPath.ClassInfo info : classInfos) {
                    Class<?> clazz;
                    try {
                        clazz = info.load();
                    }
                    catch (NoClassDefFoundError e) {
                        continue;
                    }
                    catch (ExceptionInInitializerError e) {
                        continue;
                    }
                    catch (UnsatisfiedLinkError e) {
                        continue;
                    }
                    this.addClass(clazz, classes, iface);
                }
            }
        }
        return ((HashMap)classes).values();
    }

    private <T> void addClass(Class<T> clazz, HashMap<String, Class<T>> classes, Class<T> iface) {
        if (!classes.containsKey(clazz.getName()) && iface.isAssignableFrom(clazz) && !clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers())) {
            for (Constructor<?> ctor : clazz.getConstructors()) {
                if (ctor.getParameterTypes().length != 0) continue;
                classes.put(clazz.getName(), clazz);
            }
        }
    }

    private ClassLoader[] getClassLoaders() {
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader myLoader = this.getClass().getClassLoader();
        if (contextLoader == null) {
            return new ClassLoader[]{myLoader};
        }
        if (contextLoader == myLoader || myLoader == null) {
            return new ClassLoader[]{contextLoader};
        }
        return new ClassLoader[]{contextLoader, myLoader};
    }

    private static final class DefaultExceptionHandler
    implements ExceptionHandler {
        private DefaultExceptionHandler() {
        }

        @Override
        public void handleException(Throwable t, Record record) {
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new MorphlineRuntimeException(t);
        }
    }

    public static class Builder {
        protected MorphlineContext context = this.create();
        private ExceptionHandler exceptionHandler = new DefaultExceptionHandler();
        private MetricRegistry metricRegistry = new MetricRegistry();
        private HealthCheckRegistry healthCheckRegistry = new HealthCheckRegistry();

        public Builder setExceptionHandler(ExceptionHandler exceptionHandler) {
            Preconditions.checkNotNull((Object)exceptionHandler);
            this.exceptionHandler = exceptionHandler;
            return this;
        }

        public Builder setMetricRegistry(MetricRegistry metricRegistry) {
            Preconditions.checkNotNull((Object)metricRegistry);
            this.metricRegistry = metricRegistry;
            return this;
        }

        public Builder setHealthCheckRegistry(HealthCheckRegistry healthCheckRegistry) {
            Preconditions.checkNotNull((Object)healthCheckRegistry);
            this.healthCheckRegistry = healthCheckRegistry;
            return this;
        }

        public MorphlineContext build() {
            this.context.exceptionHandler = this.exceptionHandler;
            this.context.metricRegistry = this.metricRegistry;
            this.context.healthCheckRegistry = this.healthCheckRegistry;
            return this.context;
        }

        protected MorphlineContext create() {
            return new MorphlineContext();
        }
    }
}

