/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.stdio;

import com.typesafe.config.Config;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.CommandBuilder;
import org.kitesdk.morphline.api.MorphlineCompilationException;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.base.Validator;
import org.kitesdk.morphline.shaded.com.googlecode.jcsv.fastreader.CSVTokenizer;
import org.kitesdk.morphline.shaded.com.googlecode.jcsv.fastreader.QuotedCSVTokenizer;
import org.kitesdk.morphline.shaded.com.googlecode.jcsv.fastreader.SimpleCSVTokenizer;
import org.kitesdk.morphline.stdio.AbstractParser;

public final class ReadCSVBuilder
implements CommandBuilder {
    @Override
    public Collection<String> getNames() {
        return Collections.singletonList("readCSV");
    }

    @Override
    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new ReadCSV(this, config, parent, child, context);
    }

    private static final class ReadCSV
    extends AbstractParser {
        private final char separatorChar;
        private final List<String> columnNames;
        private final Charset charset;
        private final boolean ignoreFirstLine;
        private final boolean trim;
        private final boolean addEmptyStrings;
        private final String commentPrefix;
        private final String quoteChar;
        private final boolean ignoreEmptyLines = true;
        private final int maxCharactersPerRecord;
        private final boolean ignoreTooLongRecords;
        private final CSVTokenizer tokenizer;

        public ReadCSV(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
            String separator = this.getConfigs().getString(config, "separator", ",");
            if (separator.length() != 1) {
                throw new MorphlineCompilationException("CSV separator must be one character only: " + separator, config);
            }
            this.separatorChar = separator.charAt(0);
            this.columnNames = this.getConfigs().getStringList(config, "columns");
            this.charset = this.getConfigs().getCharset(config, "charset", null);
            this.ignoreFirstLine = this.getConfigs().getBoolean(config, "ignoreFirstLine", false);
            this.trim = this.getConfigs().getBoolean(config, "trim", true);
            this.addEmptyStrings = this.getConfigs().getBoolean(config, "addEmptyStrings", true);
            this.quoteChar = this.getConfigs().getString(config, "quoteChar", "");
            if (this.quoteChar.length() > 1) {
                throw new MorphlineCompilationException("Quote character must not have a length of more than one character: " + this.quoteChar, config);
            }
            if (this.quoteChar.equals(String.valueOf(this.separatorChar))) {
                throw new MorphlineCompilationException("Quote character must not be the same as separator: " + this.quoteChar, config);
            }
            this.commentPrefix = this.getConfigs().getString(config, "commentPrefix", "");
            if (this.commentPrefix.length() > 1) {
                throw new MorphlineCompilationException("Comment prefix must not have a length of more than one character: " + this.commentPrefix, config);
            }
            this.maxCharactersPerRecord = this.getConfigs().getInt(config, "maxCharactersPerRecord", 1000000);
            this.ignoreTooLongRecords = new Validator().validateEnum(config, this.getConfigs().getString(config, "onMaxCharactersPerRecord", OnMaxCharactersPerRecord.throwException.toString()), OnMaxCharactersPerRecord.class, new OnMaxCharactersPerRecord[0]) == OnMaxCharactersPerRecord.ignoreRecord;
            this.tokenizer = this.quoteChar.length() == 0 ? new SimpleCSVTokenizer(this.separatorChar, this.trim, this.addEmptyStrings, this.columnNames) : new QuotedCSVTokenizer(this.separatorChar, this.trim, this.addEmptyStrings, this.columnNames, this.maxCharactersPerRecord, this.ignoreTooLongRecords, this.quoteChar.charAt(0));
            this.validateArguments();
        }

        @Override
        protected boolean doProcess(Record inputRecord, InputStream stream) throws IOException {
            Record outputRecord;
            Record template = inputRecord.copy();
            ReadCSV.removeAttachments(template);
            Charset detectedCharset = this.detectCharset(inputRecord, this.charset);
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, detectedCharset), this.getBufferSize(stream));
            if (this.ignoreFirstLine) {
                reader.readLine();
            }
            while ((outputRecord = this.readNext(reader, template)) != null) {
                this.incrementNumRecords();
                if (this.getChild().process(outputRecord)) continue;
                return false;
            }
            return true;
        }

        private Record readNext(BufferedReader reader, Record template) throws IOException {
            Record outputRecord;
            String line;
            do {
                if ((line = reader.readLine()) != null) continue;
                return null;
            } while (!QuotedCSVTokenizer.verifyRecordLength(line.length(), this.maxCharactersPerRecord, line, this.ignoreTooLongRecords, this.LOG) || this.isTrimmedLineEmpty(line) || this.commentPrefix.length() > 0 && line.startsWith(this.commentPrefix) || !this.tokenizer.tokenizeLine(line, reader, outputRecord = template.copy()));
            return outputRecord;
        }

        private boolean isTrimmedLineEmpty(String line) {
            int len;
            int i = len = line.length();
            while (--i >= 0) {
                if (line.charAt(i) <= ' ') continue;
                return false;
            }
            return true;
        }

        private static enum OnMaxCharactersPerRecord {
            ignoreRecord,
            throwException;

        }
    }
}

